/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Date;
import com.google.cloud.spanner.Value;
import com.google.protobuf.ListValue;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SpannerTypeConverter {
    private static final ZoneId UTC_ZONE = ZoneId.of("UTC");
    private static final DateTimeFormatter ISO_8601_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    SpannerTypeConverter() {
    }

    static <T> Value createUntypedArrayValue(Stream<T> stream) {
        List values = stream.map(val -> com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(val)).build()).collect(Collectors.toList());
        return Value.untyped(com.google.protobuf.Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(values).build()).build());
    }

    static <T extends TemporalAccessor> String convertToISO8601(T dateTime) {
        return ISO_8601_DATE_FORMATTER.format(dateTime);
    }

    static <T> Value createUntypedStringValue(T value) {
        return Value.untyped(com.google.protobuf.Value.newBuilder().setStringValue(String.valueOf(value)).build());
    }

    static <T, U> Iterable<U> convertToTypedIterable(Function<T, U> func, T val, Iterator<?> iterator) {
        ArrayList values = new ArrayList();
        SpannerTypeConverter.processIterable(val, iterator, func, values::add);
        return values;
    }

    static <T> Iterable<T> convertToTypedIterable(T val, Iterator<?> iterator) {
        return SpannerTypeConverter.convertToTypedIterable(v -> v, val, iterator);
    }

    static <T, U> void processIterable(T val, Iterator<?> iterator, Function<T, U> func, Consumer<U> consumer) {
        consumer.accept(func.apply(val));
        iterator.forEachRemaining(values -> consumer.accept(func.apply(values)));
    }

    static Date convertLocalDateToSpannerDate(LocalDate date) {
        return Date.fromYearMonthDay((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth());
    }

    static <T> Value createUntypedIterableValue(T value, Iterator<?> iterator, Function<T, String> func) {
        ListValue.Builder listValueBuilder = ListValue.newBuilder();
        SpannerTypeConverter.processIterable(value, iterator, val -> com.google.protobuf.Value.newBuilder().setStringValue((String)func.apply(val)).build(), arg_0 -> ((ListValue.Builder)listValueBuilder).addValues(arg_0));
        return Value.untyped(com.google.protobuf.Value.newBuilder().setListValue(listValueBuilder.build()).build());
    }

    static ZonedDateTime atUTC(LocalDateTime localDateTime) {
        return SpannerTypeConverter.atUTC(localDateTime.atZone(ZoneId.systemDefault()));
    }

    static ZonedDateTime atUTC(OffsetDateTime localDateTime) {
        return localDateTime.atZoneSameInstant(UTC_ZONE);
    }

    static ZonedDateTime atUTC(ZonedDateTime localDateTime) {
        return localDateTime.withZoneSameInstant(UTC_ZONE);
    }
}

