/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SessionPool;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;

class MultiplexedSessionTransactionRunner
implements TransactionRunner {
    private final SessionPool sessionPool;
    private final TransactionRunnerImpl transactionRunnerForMultiplexedSession;
    private SessionPool.SessionPoolTransactionRunner transactionRunnerForRegularSession;
    private final Options.TransactionOption[] options;
    private boolean isUsingMultiplexedSession = true;

    public MultiplexedSessionTransactionRunner(SessionImpl multiplexedSession, SessionPool sessionPool, Options.TransactionOption ... options) {
        this.sessionPool = sessionPool;
        this.transactionRunnerForMultiplexedSession = new TransactionRunnerImpl(multiplexedSession, options);
        multiplexedSession.setActive(this.transactionRunnerForMultiplexedSession);
        this.options = options;
    }

    private TransactionRunner getRunner() {
        if (this.isUsingMultiplexedSession) {
            return this.transactionRunnerForMultiplexedSession;
        }
        if (this.transactionRunnerForRegularSession == null) {
            this.transactionRunnerForRegularSession = new SessionPool.SessionPoolTransactionRunner<SessionPool.PooledSessionFuture>(this.sessionPool.getSession(), this.sessionPool.getPooledSessionReplacementHandler(), this.options);
        }
        return this.transactionRunnerForRegularSession;
    }

    @Override
    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        while (true) {
            try {
                return this.getRunner().run(callable);
            }
            catch (SpannerException e) {
                if (e.getErrorCode() == ErrorCode.UNIMPLEMENTED && this.verifyUnimplementedErrorMessageForRWMux(e)) {
                    this.isUsingMultiplexedSession = false;
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    @Override
    public Timestamp getCommitTimestamp() {
        return this.getRunner().getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        return this.getRunner().getCommitResponse();
    }

    @Override
    public TransactionRunner allowNestedTransaction() {
        this.getRunner().allowNestedTransaction();
        return this;
    }

    private boolean verifyUnimplementedErrorMessageForRWMux(SpannerException spannerException) {
        if (spannerException.getCause() == null) {
            return false;
        }
        if (spannerException.getCause().getMessage() == null) {
            return false;
        }
        return spannerException.getCause().getMessage().contains("Transaction type read_write not supported with multiplexed sessions");
    }
}

