/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbstractResultSet;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.protobuf.ListValue;
import com.google.protobuf.Value;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.ResultSetMetadata;
import com.google.spanner.v1.ResultSetStats;
import com.google.spanner.v1.TypeCode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class GrpcValueIterator
extends AbstractIterator<Value> {
    private final AbstractResultSet.CloseableIterator<PartialResultSet> stream;
    private ResultSetMetadata metadata;
    private Type type;
    private PartialResultSet current;
    private int pos;
    private ResultSetStats statistics;
    private final AbstractResultSet.Listener listener;

    GrpcValueIterator(AbstractResultSet.CloseableIterator<PartialResultSet> stream, AbstractResultSet.Listener listener) {
        this.stream = stream;
        this.listener = listener;
    }

    protected Value computeNext() {
        Object merged;
        Value value;
        Value.KindCase kind;
        if (!this.ensureReady(StreamValue.RESULT)) {
            this.endOfData();
            return null;
        }
        if (!this.isMergeable(kind = (value = this.current.getValues(this.pos++)).getKindCase())) {
            if (this.pos == this.current.getValuesCount() && this.current.getChunkedValue()) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected chunked PartialResultSet.");
            }
            return value;
        }
        if (!this.current.getChunkedValue() || this.pos != this.current.getValuesCount()) {
            return value;
        }
        Object object = merged = kind == Value.KindCase.STRING_VALUE ? value.getStringValue() : new ArrayList(value.getListValue().getValuesList());
        while (this.current.getChunkedValue() && this.pos == this.current.getValuesCount()) {
            Value newValue;
            if (!this.ensureReady(StreamValue.RESULT)) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed in the middle of chunked value");
            }
            if ((newValue = this.current.getValues(this.pos++)).getKindCase() != kind) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Unexpected type in middle of chunked value. Expected: " + kind + " but got: " + newValue.getKindCase());
            }
            if (kind == Value.KindCase.STRING_VALUE) {
                merged = merged + newValue.getStringValue();
                continue;
            }
            this.concatLists((List)merged, newValue.getListValue().getValuesList());
        }
        if (kind == Value.KindCase.STRING_VALUE) {
            return Value.newBuilder().setStringValue((String)merged).build();
        }
        return Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues((Iterable)((List)merged))).build();
    }

    ResultSetMetadata getMetadata() throws SpannerException {
        if (this.metadata == null && !this.ensureReady(StreamValue.METADATA)) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Stream closed without sending metadata");
        }
        return this.metadata;
    }

    @Nullable
    ResultSetStats getStats() {
        return this.statistics;
    }

    boolean initiateStreaming(AsyncResultSet.StreamMessageListener streamMessageListener) {
        return this.stream.initiateStreaming(streamMessageListener);
    }

    Type type() {
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"metadata has not been received");
        return this.type;
    }

    private boolean ensureReady(StreamValue requiredValue) throws SpannerException {
        while (this.current == null || this.pos >= this.current.getValuesCount()) {
            if (!this.stream.hasNext()) {
                return false;
            }
            this.current = (PartialResultSet)this.stream.next();
            this.pos = 0;
            if (this.type == null) {
                if (!this.current.hasMetadata() || !this.current.getMetadata().hasRowType()) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing type metadata in first message");
                }
                this.metadata = this.current.getMetadata();
                com.google.spanner.v1.Type typeProto = com.google.spanner.v1.Type.newBuilder().setCode(TypeCode.STRUCT).setStructType(this.metadata.getRowType()).build();
                try {
                    this.type = Type.fromProto(typeProto);
                }
                catch (IllegalArgumentException e) {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Invalid type metadata: " + e.getMessage(), e);
                }
            }
            if (this.current.hasPrecommitToken()) {
                this.listener.onPrecommitToken(this.current.getPrecommitToken());
            }
            if (this.current.hasStats()) {
                this.statistics = this.current.getStats();
            }
            if (requiredValue != StreamValue.METADATA) continue;
            return true;
        }
        return true;
    }

    void close(@Nullable String message) {
        this.stream.close(message);
    }

    boolean isWithBeginTransaction() {
        return this.stream.isWithBeginTransaction();
    }

    private void concatLists(List<Value> a, List<Value> b) {
        if (a.size() == 0 || b.size() == 0) {
            a.addAll(b);
            return;
        }
        Value last = a.get(a.size() - 1);
        Value first = b.get(0);
        Value.KindCase lastKind = last.getKindCase();
        Value.KindCase firstKind = first.getKindCase();
        if (this.isMergeable(lastKind) && lastKind == firstKind) {
            Value merged;
            if (lastKind == Value.KindCase.STRING_VALUE) {
                String lastStr = last.getStringValue();
                String firstStr = first.getStringValue();
                merged = Value.newBuilder().setStringValue(lastStr + firstStr).build();
            } else {
                ArrayList<Value> mergedList = new ArrayList<Value>();
                mergedList.addAll(last.getListValue().getValuesList());
                this.concatLists(mergedList, first.getListValue().getValuesList());
                merged = Value.newBuilder().setListValue(ListValue.newBuilder().addAllValues(mergedList)).build();
            }
            a.set(a.size() - 1, merged);
            a.addAll(b.subList(1, b.size()));
        } else {
            a.addAll(b);
        }
    }

    private boolean isMergeable(Value.KindCase kind) {
        return kind == Value.KindCase.STRING_VALUE || kind == Value.KindCase.LIST_VALUE;
    }

    private static enum StreamValue {
        METADATA,
        RESULT;

    }
}

