/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerException;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DmlBatchUpdateCountVerificationFailedException
extends AbortedException {
    private static final long serialVersionUID = 1L;
    private final long[] expected;
    private final long[] actual;

    DmlBatchUpdateCountVerificationFailedException(SpannerException.DoNotConstructDirectly token, long[] expected, long[] actual) {
        super(token, String.format("Actual update counts that were returned during execution do not match the previously returned update counts.\nExpected: %s\nActual: %s\nSet auto_batch_dml_update_count_verification to false to skip this verification.", Arrays.stream(expected).mapToObj(Long::toString).collect(Collectors.joining()), Arrays.stream(actual).mapToObj(Long::toString).collect(Collectors.joining())), null);
        this.expected = expected;
        this.actual = actual;
    }

    public long[] getExpected() {
        return Arrays.copyOf(this.expected, this.expected.length);
    }

    public long[] getActual() {
        return Arrays.copyOf(this.actual, this.actual.length);
    }
}

