/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionRunner;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class DelayedTransactionRunner
implements TransactionRunner {
    private final ApiFuture<TransactionRunner> transactionRunnerFuture;

    DelayedTransactionRunner(ApiFuture<TransactionRunner> transactionRunnerFuture) {
        this.transactionRunnerFuture = transactionRunnerFuture;
    }

    TransactionRunner getTransactionRunner() {
        try {
            return (TransactionRunner)this.transactionRunnerFuture.get();
        }
        catch (ExecutionException executionException) {
            throw SpannerExceptionFactory.causeAsRunTimeException(executionException);
        }
        catch (InterruptedException interruptedException) {
            throw SpannerExceptionFactory.propagateInterrupt(interruptedException);
        }
    }

    @Override
    @Nullable
    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        return this.getTransactionRunner().run(callable);
    }

    @Override
    public Timestamp getCommitTimestamp() {
        return this.getTransactionRunner().getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        return this.getTransactionRunner().getCommitResponse();
    }

    @Override
    public TransactionRunner allowNestedTransaction() {
        return this.getTransactionRunner().allowNestedTransaction();
    }
}

