/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.MethodName;
import com.google.api.gax.tracing.MetricsRecorder;
import com.google.api.gax.tracing.MetricsTracer;
import com.google.cloud.spanner.BuiltInMetricsRecorder;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;

class BuiltInMetricsTracer
extends MetricsTracer
implements ApiTracer {
    private final BuiltInMetricsRecorder builtInOpenTelemetryMetricsRecorder;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private Float gfeLatency = null;
    private Float afeLatency = null;
    private long gfeHeaderMissingCount = 0L;
    private long afeHeaderMissingCount = 0L;

    BuiltInMetricsTracer(MethodName methodName, BuiltInMetricsRecorder builtInOpenTelemetryMetricsRecorder) {
        super(methodName, (MetricsRecorder)builtInOpenTelemetryMetricsRecorder);
        this.builtInOpenTelemetryMetricsRecorder = builtInOpenTelemetryMetricsRecorder;
        this.attributes.put("method", methodName.toString());
    }

    public void attemptSucceeded() {
        super.attemptSucceeded();
        this.attributes.put("status", StatusCode.Code.OK.toString());
        this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
    }

    public void attemptCancelled() {
        super.attemptCancelled();
        this.attributes.put("status", StatusCode.Code.CANCELLED.toString());
        this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
    }

    public void attemptFailedDuration(Throwable error, Duration delay) {
        super.attemptFailedDuration(error, delay);
        this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
        this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
    }

    public void attemptFailedRetriesExhausted(Throwable error) {
        super.attemptFailedRetriesExhausted(error);
        this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
        this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
    }

    public void attemptPermanentFailure(Throwable error) {
        super.attemptPermanentFailure(error);
        this.attributes.put("status", BuiltInMetricsTracer.extractStatus(error));
        this.builtInOpenTelemetryMetricsRecorder.recordServerTimingHeaderMetrics(this.gfeLatency, this.afeLatency, this.gfeHeaderMissingCount, this.afeHeaderMissingCount, this.attributes);
    }

    void recordGFELatency(Float gfeLatency) {
        this.gfeLatency = gfeLatency;
    }

    void recordAFELatency(Float afeLatency) {
        this.afeLatency = afeLatency;
    }

    void recordGfeHeaderMissingCount(Long value) {
        this.gfeHeaderMissingCount = value;
    }

    void recordAfeHeaderMissingCount(Long value) {
        this.afeHeaderMissingCount = value;
    }

    public void addAttributes(Map<String, String> attributes) {
        super.addAttributes(attributes);
        this.attributes.putAll(attributes);
    }

    public void addAttributes(String key, String value) {
        super.addAttributes(key, value);
        this.attributes.put(key, value);
    }

    private static String extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return StatusCode.Code.OK.toString();
        }
        String statusString = error instanceof CancellationException ? StatusCode.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : StatusCode.Code.UNKNOWN.toString());
        return statusString;
    }
}

