/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

@InternalApi
public interface Connection
extends AutoCloseable {
    @Override
    public void close();

    public ApiFuture<Void> closeAsync();

    public boolean isClosed();

    public void setAutocommit(boolean var1);

    public boolean isAutocommit();

    public void setReadOnly(boolean var1);

    public boolean isReadOnly();

    public void setStatementTimeout(long var1, TimeUnit var3);

    public void clearStatementTimeout();

    public long getStatementTimeout(TimeUnit var1);

    public boolean hasStatementTimeout();

    public void cancel();

    public void beginTransaction();

    public ApiFuture<Void> beginTransactionAsync();

    public void setTransactionMode(TransactionMode var1);

    public TransactionMode getTransactionMode();

    default public void setTransactionTag(String tag) {
        throw new UnsupportedOperationException();
    }

    default public String getTransactionTag() {
        throw new UnsupportedOperationException();
    }

    default public void setStatementTag(String tag) {
        throw new UnsupportedOperationException();
    }

    default public String getStatementTag() {
        throw new UnsupportedOperationException();
    }

    public boolean isRetryAbortsInternally();

    public void setRetryAbortsInternally(boolean var1);

    public void addTransactionRetryListener(TransactionRetryListener var1);

    public boolean removeTransactionRetryListener(TransactionRetryListener var1);

    public Iterator<TransactionRetryListener> getTransactionRetryListeners();

    public void setAutocommitDmlMode(AutocommitDmlMode var1);

    public AutocommitDmlMode getAutocommitDmlMode();

    public void setReadOnlyStaleness(TimestampBound var1);

    public TimestampBound getReadOnlyStaleness();

    public void setOptimizerVersion(String var1);

    public String getOptimizerVersion();

    default public void setOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    default public String getOptimizerStatisticsPackage() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    public void setReturnCommitStats(boolean var1);

    public boolean isReturnCommitStats();

    public void commit();

    public ApiFuture<Void> commitAsync();

    public void rollback();

    public ApiFuture<Void> rollbackAsync();

    public boolean isInTransaction();

    public boolean isTransactionStarted();

    public Timestamp getReadTimestamp();

    public Timestamp getCommitTimestamp();

    public CommitResponse getCommitResponse();

    public void startBatchDdl();

    public void startBatchDml();

    public long[] runBatch();

    public ApiFuture<long[]> runBatchAsync();

    public void abortBatch();

    public boolean isDdlBatchActive();

    public boolean isDmlBatchActive();

    public StatementResult execute(Statement var1);

    public AsyncStatementResult executeAsync(Statement var1);

    public ResultSet executeQuery(Statement var1, Options.QueryOption ... var2);

    public AsyncResultSet executeQueryAsync(Statement var1, Options.QueryOption ... var2);

    public ResultSet analyzeQuery(Statement var1, ReadContext.QueryAnalyzeMode var2);

    public long executeUpdate(Statement var1);

    public ApiFuture<Long> executeUpdateAsync(Statement var1);

    public long[] executeBatchUpdate(Iterable<Statement> var1);

    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<Statement> var1);

    public void write(Mutation var1);

    public ApiFuture<Void> writeAsync(Mutation var1);

    public void write(Iterable<Mutation> var1);

    public ApiFuture<Void> writeAsync(Iterable<Mutation> var1);

    public void bufferedWrite(Mutation var1);

    public void bufferedWrite(Iterable<Mutation> var1);

    @InternalApi
    public static final class InternalMetadataQuery
    implements Options.QueryOption {
        @InternalApi
        public static final InternalMetadataQuery INSTANCE = new InternalMetadataQuery();

        private InternalMetadataQuery() {
        }
    }
}

