/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.cloud.spanner.SpannerRpcMetrics;
import com.google.cloud.spanner.spi.v1.EncodingInterceptor;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.HeaderInterceptor;
import com.google.cloud.spanner.spi.v1.LoggingInterceptor;
import com.google.cloud.spanner.spi.v1.SpannerErrorInterceptor;
import com.google.common.collect.ImmutableList;
import io.grpc.ClientInterceptor;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi(value="Exposed for testing")
public class SpannerInterceptorProvider
implements GrpcInterceptorProvider {
    private final List<ClientInterceptor> clientInterceptors;

    private SpannerInterceptorProvider(List<ClientInterceptor> clientInterceptors) {
        this.clientInterceptors = clientInterceptors;
    }

    @ObsoleteApi(value="This method always uses Global OpenTelemetry")
    public static SpannerInterceptorProvider createDefault() {
        return SpannerInterceptorProvider.createDefault(GlobalOpenTelemetry.get());
    }

    public static SpannerInterceptorProvider createDefault(OpenTelemetry openTelemetry) {
        ArrayList<Object> defaultInterceptorList = new ArrayList<Object>();
        defaultInterceptorList.add(new SpannerErrorInterceptor());
        defaultInterceptorList.add(new LoggingInterceptor(Logger.getLogger(GapicSpannerRpc.class.getName()), Level.FINER));
        defaultInterceptorList.add(new HeaderInterceptor(new SpannerRpcMetrics(openTelemetry)));
        return new SpannerInterceptorProvider((List<ClientInterceptor>)ImmutableList.copyOf(defaultInterceptorList));
    }

    static SpannerInterceptorProvider create(GrpcInterceptorProvider provider) {
        return new SpannerInterceptorProvider((List<ClientInterceptor>)ImmutableList.copyOf((Collection)provider.getInterceptors()));
    }

    public SpannerInterceptorProvider with(ClientInterceptor clientInterceptor) {
        ImmutableList interceptors = ImmutableList.builder().addAll(this.clientInterceptors).add((Object)clientInterceptor).build();
        return new SpannerInterceptorProvider((List<ClientInterceptor>)interceptors);
    }

    SpannerInterceptorProvider withEncoding(String encoding) {
        if (encoding != null) {
            return this.with(new EncodingInterceptor(encoding));
        }
        return this;
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.clientInterceptors;
    }
}

