/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.spi.v1;

import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRpcMetrics;
import com.google.cloud.spanner.spi.v1.SpannerRpcViews;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.spanner.admin.database.v1.DatabaseName;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opencensus.stats.MeasureMap;
import io.opencensus.stats.Stats;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;
import io.opencensus.tags.Tags;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class HeaderInterceptor
implements ClientInterceptor {
    private static final DatabaseName UNDEFINED_DATABASE_NAME = DatabaseName.of((String)"undefined-project", (String)"undefined-instance", (String)"undefined-database");
    private static final Metadata.Key<String> SERVER_TIMING_HEADER_KEY = Metadata.Key.of((String)"server-timing", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final String SERVER_TIMING_HEADER_PREFIX = "gfet4t7; dur=";
    private static final Metadata.Key<String> GOOGLE_CLOUD_RESOURCE_PREFIX_KEY = Metadata.Key.of((String)"google-cloud-resource-prefix", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Pattern GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN = Pattern.compile(".*projects/(?<project>\\p{ASCII}[^/]*)(/instances/(?<instance>\\p{ASCII}[^/]*))?(/databases/(?<database>\\p{ASCII}[^/]*))?");
    private final Cache<String, DatabaseName> databaseNameCache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final Cache<String, TagContext> tagsCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private final Cache<String, Attributes> attributesCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    private static final Tagger TAGGER = Tags.getTagger();
    private static final StatsRecorder STATS_RECORDER = Stats.getStatsRecorder();
    private static final Logger LOGGER = Logger.getLogger(HeaderInterceptor.class.getName());
    private static final Level LEVEL = Level.INFO;
    private final SpannerRpcMetrics spannerRpcMetrics;

    HeaderInterceptor(SpannerRpcMetrics spannerRpcMetrics) {
        this.spannerRpcMetrics = spannerRpcMetrics;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                try {
                    final Span span = Span.current();
                    DatabaseName databaseName = HeaderInterceptor.this.extractDatabaseName(headers);
                    String key = databaseName + method.getFullMethodName();
                    final TagContext tagContext = HeaderInterceptor.this.getTagContext(key, method.getFullMethodName(), databaseName);
                    final Attributes attributes = HeaderInterceptor.this.getMetricAttributes(key, method.getFullMethodName(), databaseName);
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onHeaders(Metadata metadata) {
                            HeaderInterceptor.this.processHeader(metadata, tagContext, attributes, span);
                            super.onHeaders(metadata);
                        }
                    }, headers);
                }
                catch (ExecutionException executionException) {
                    throw SpannerExceptionFactory.asSpannerException(executionException.getCause());
                }
            }
        };
    }

    private void processHeader(Metadata metadata, TagContext tagContext, Attributes attributes, Span span) {
        MeasureMap measureMap = STATS_RECORDER.newMeasureMap();
        String serverTiming = (String)metadata.get(SERVER_TIMING_HEADER_KEY);
        if (serverTiming != null && serverTiming.startsWith(SERVER_TIMING_HEADER_PREFIX)) {
            try {
                long latency = Long.parseLong(serverTiming.substring(SERVER_TIMING_HEADER_PREFIX.length()));
                measureMap.put(SpannerRpcViews.SPANNER_GFE_LATENCY, latency);
                measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 0L);
                measureMap.record(tagContext);
                this.spannerRpcMetrics.recordGfeLatency(latency, attributes);
                this.spannerRpcMetrics.recordGfeHeaderMissingCount(0L, attributes);
                if (span != null) {
                    span.setAttribute("gfe_latency", String.valueOf(latency));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(LEVEL, "Invalid server-timing object in header: {}", serverTiming);
            }
        } else {
            this.spannerRpcMetrics.recordGfeHeaderMissingCount(1L, attributes);
            measureMap.put(SpannerRpcViews.SPANNER_GFE_HEADER_MISSING_COUNT, 1L).record(tagContext);
        }
    }

    private DatabaseName extractDatabaseName(Metadata headers) throws ExecutionException {
        String googleResourcePrefix = (String)headers.get(GOOGLE_CLOUD_RESOURCE_PREFIX_KEY);
        if (googleResourcePrefix != null) {
            return (DatabaseName)this.databaseNameCache.get((Object)googleResourcePrefix, () -> {
                String projectId = "undefined-project";
                String instanceId = "undefined-database";
                String databaseId = "undefined-database";
                Matcher matcher = GOOGLE_CLOUD_RESOURCE_PREFIX_PATTERN.matcher(googleResourcePrefix);
                if (matcher.find()) {
                    projectId = matcher.group("project");
                    if (matcher.group("instance") != null) {
                        instanceId = matcher.group("instance");
                    }
                    if (matcher.group("database") != null) {
                        databaseId = matcher.group("database");
                    }
                } else {
                    LOGGER.log(LEVEL, "Error parsing google cloud resource header: " + googleResourcePrefix);
                }
                return DatabaseName.of((String)projectId, (String)instanceId, (String)databaseId);
            });
        }
        return UNDEFINED_DATABASE_NAME;
    }

    private TagContext getTagContext(String key, String method, DatabaseName databaseName) throws ExecutionException {
        return (TagContext)this.tagsCache.get((Object)key, () -> TAGGER.currentBuilder().putLocal(SpannerRpcViews.PROJECT_ID, TagValue.create((String)databaseName.getProject())).putLocal(SpannerRpcViews.INSTANCE_ID, TagValue.create((String)databaseName.getInstance())).putLocal(SpannerRpcViews.DATABASE_ID, TagValue.create((String)databaseName.getDatabase())).putLocal(SpannerRpcViews.METHOD, TagValue.create((String)method)).build());
    }

    private Attributes getMetricAttributes(String key, String method, DatabaseName databaseName) throws ExecutionException {
        return (Attributes)this.attributesCache.get((Object)key, () -> {
            AttributesBuilder attributesBuilder = Attributes.builder();
            attributesBuilder.put("database", databaseName.getDatabase());
            attributesBuilder.put("instance_id", databaseName.getInstance());
            attributesBuilder.put("project_id", databaseName.getProject());
            attributesBuilder.put("method", method);
            return attributesBuilder.build();
        });
    }
}

