/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracerFactory;
import com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.grpc.GcpManagedChannelOptions;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spanner.CompositeTracerFactory;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.DecodeMode;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.OpenTelemetryApiTracerFactory;
import com.google.cloud.spanner.SessionPoolOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.admin.database.v1.stub.DatabaseAdminStubSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.cloud.spanner.spi.SpannerRpcFactory;
import com.google.cloud.spanner.spi.v1.GapicSpannerRpc;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.spanner.v1.DirectedReadOptions;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.SpannerGrpc;
import io.grpc.CallCredentials;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.ExperimentalApi;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;

public class SpannerOptions
extends ServiceOptions<Spanner, SpannerOptions> {
    private static final long serialVersionUID = 2789571558532701170L;
    private static SpannerEnvironment environment = SpannerEnvironmentImpl.access$000();
    private static boolean enableOpenCensusMetrics = true;
    private static boolean enableOpenTelemetryMetrics = false;
    private static final String JDBC_API_CLIENT_LIB_TOKEN = "sp-jdbc";
    private static final String HIBERNATE_API_CLIENT_LIB_TOKEN = "sp-hib";
    private static final String LIQUIBASE_API_CLIENT_LIB_TOKEN = "sp-liq";
    private static final String PG_ADAPTER_CLIENT_LIB_TOKEN = "pg-adapter";
    private static final String API_SHORT_NAME = "Spanner";
    private static final String DEFAULT_HOST = "https://spanner.googleapis.com";
    private static final ImmutableSet<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/spanner.admin", (Object)"https://www.googleapis.com/auth/spanner.data");
    static final int MAX_CHANNELS = 256;
    @VisibleForTesting
    static final int DEFAULT_CHANNELS = 4;
    @VisibleForTesting
    static final int GRPC_GCP_ENABLED_DEFAULT_CHANNELS = 8;
    private final TransportChannelProvider channelProvider;
    private final ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
    private final GrpcInterceptorProvider interceptorProvider;
    private final SessionPoolOptions sessionPoolOptions;
    private final int prefetchChunks;
    private final DecodeMode decodeMode;
    private final int numChannels;
    private final String transportChannelExecutorThreadNameFormat;
    private final String databaseRole;
    private final ImmutableMap<String, String> sessionLabels;
    private final SpannerStubSettings spannerStubSettings;
    private final InstanceAdminStubSettings instanceAdminStubSettings;
    private final DatabaseAdminStubSettings databaseAdminStubSettings;
    private final Duration partitionedDmlTimeout;
    private final boolean grpcGcpExtensionEnabled;
    private final GcpManagedChannelOptions grpcGcpOptions;
    private final boolean autoThrottleAdministrativeRequests;
    private final RetrySettings retryAdministrativeRequestsSettings;
    private final boolean trackTransactionStarter;
    private final Map<DatabaseId, ExecuteSqlRequest.QueryOptions> defaultQueryOptions;
    private final ExecuteSqlRequest.QueryOptions envQueryOptions;
    private final Map<DatabaseId, ExecuteSqlRequest.QueryOptions> mergedQueryOptions;
    private final CallCredentialsProvider callCredentialsProvider;
    private final CloseableExecutorProvider asyncExecutorProvider;
    private final String compressorName;
    private final boolean leaderAwareRoutingEnabled;
    private final boolean attemptDirectPath;
    private final DirectedReadOptions directedReadOptions;
    private final boolean useVirtualThreads;
    private final OpenTelemetry openTelemetry;
    private final boolean enableApiTracing;
    private final boolean enableExtendedTracing;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static TracingFramework activeTracingFramework;
    public static final Context.Key<CallContextConfigurator> CALL_CONTEXT_CONFIGURATOR_KEY;
    private static final AtomicInteger DEFAULT_POOL_COUNT;

    @VisibleForTesting
    static CloseableExecutorProvider createDefaultAsyncExecutorProvider() {
        return SpannerOptions.createAsyncExecutorProvider(SpannerOptions.getDefaultAsyncExecutorProviderCoreThreadCount(), 60L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    static int getDefaultAsyncExecutorProviderCoreThreadCount() {
        String propertyName = "com.google.cloud.spanner.async_num_core_threads";
        String propertyValue = System.getProperty(propertyName, "8");
        try {
            int corePoolSize = Integer.parseInt(propertyValue);
            if (corePoolSize < 0) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("The value for %s must be >=0. Invalid value: %s", propertyName, propertyValue));
            }
            return corePoolSize;
        }
        catch (NumberFormatException exception) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, String.format("The %s system property must be a valid integer. The value %s could not be parsed as an integer.", propertyName, propertyValue));
        }
    }

    public static CloseableExecutorProvider createAsyncExecutorProvider(int poolSize, long keepAliveTime, TimeUnit unit) {
        String format = String.format("spanner-async-pool-%d-thread-%%d", DEFAULT_POOL_COUNT.incrementAndGet());
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(format).build();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(poolSize, threadFactory);
        executor.setKeepAliveTime(keepAliveTime, unit);
        executor.allowCoreThreadTimeOut(true);
        return FixedCloseableExecutorProvider.create(executor);
    }

    protected SpannerOptions(Builder builder) {
        super(SpannerFactory.class, SpannerRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new SpannerDefaults());
        this.numChannels = builder.numChannels == null ? 4 : builder.numChannels;
        Preconditions.checkArgument((this.numChannels >= 1 && this.numChannels <= 256 ? 1 : 0) != 0, (String)"Number of channels must fall in the range [1, %s], found: %s", (int)256, (int)this.numChannels);
        this.transportChannelExecutorThreadNameFormat = builder.transportChannelExecutorThreadNameFormat;
        this.channelProvider = builder.channelProvider;
        this.channelConfigurator = builder.channelConfigurator;
        this.interceptorProvider = builder.interceptorProvider;
        this.sessionPoolOptions = builder.sessionPoolOptions != null ? builder.sessionPoolOptions : SessionPoolOptions.newBuilder().build();
        this.prefetchChunks = builder.prefetchChunks;
        this.decodeMode = builder.decodeMode;
        this.databaseRole = builder.databaseRole;
        this.sessionLabels = builder.sessionLabels;
        try {
            this.spannerStubSettings = builder.spannerStubSettingsBuilder.build();
            this.instanceAdminStubSettings = builder.instanceAdminStubSettingsBuilder.build();
            this.databaseAdminStubSettings = builder.databaseAdminStubSettingsBuilder.build();
        }
        catch (IOException e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
        this.partitionedDmlTimeout = builder.partitionedDmlTimeout;
        this.grpcGcpExtensionEnabled = builder.grpcGcpExtensionEnabled;
        this.grpcGcpOptions = builder.grpcGcpOptions;
        this.autoThrottleAdministrativeRequests = builder.autoThrottleAdministrativeRequests;
        this.retryAdministrativeRequestsSettings = builder.retryAdministrativeRequestsSettings;
        this.trackTransactionStarter = builder.trackTransactionStarter;
        this.defaultQueryOptions = builder.defaultQueryOptions;
        this.envQueryOptions = builder.getEnvironmentQueryOptions();
        if (this.envQueryOptions.equals((Object)ExecuteSqlRequest.QueryOptions.getDefaultInstance())) {
            this.mergedQueryOptions = ImmutableMap.copyOf((Map)builder.defaultQueryOptions);
        } else {
            HashMap<DatabaseId, ExecuteSqlRequest.QueryOptions> merged = new HashMap<DatabaseId, ExecuteSqlRequest.QueryOptions>(builder.defaultQueryOptions);
            for (Map.Entry entry : builder.defaultQueryOptions.entrySet()) {
                merged.put((DatabaseId)entry.getKey(), ((ExecuteSqlRequest.QueryOptions)entry.getValue()).toBuilder().mergeFrom(this.envQueryOptions).build());
            }
            this.mergedQueryOptions = ImmutableMap.copyOf(merged);
        }
        this.callCredentialsProvider = builder.callCredentialsProvider;
        this.asyncExecutorProvider = builder.asyncExecutorProvider;
        this.compressorName = builder.compressorName;
        this.leaderAwareRoutingEnabled = builder.leaderAwareRoutingEnabled;
        this.attemptDirectPath = builder.attemptDirectPath;
        this.directedReadOptions = builder.directedReadOptions;
        this.useVirtualThreads = builder.useVirtualThreads;
        this.openTelemetry = builder.openTelemetry;
        this.enableApiTracing = builder.enableApiTracing;
        this.enableExtendedTracing = builder.enableExtendedTracing;
    }

    public static SpannerOptions getDefaultInstance() {
        return SpannerOptions.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static void useEnvironment(SpannerEnvironment environment) {
        SpannerOptions.environment = environment;
    }

    public static void useDefaultEnvironment() {
        environment = SpannerEnvironmentImpl.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableOpenTelemetryTraces() {
        Object object = lock;
        synchronized (object) {
            if (activeTracingFramework != null && activeTracingFramework != TracingFramework.OPEN_TELEMETRY) {
                throw new IllegalStateException("ActiveTracingFramework is set to OpenCensus and cannot be reset after SpannerOptions object is created.");
            }
            activeTracingFramework = TracingFramework.OPEN_TELEMETRY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ObsoleteApi(value="The OpenCensus project is deprecated. Use enableOpenTelemetryTraces to switch to OpenTelemetry traces")
    public static void enableOpenCensusTraces() {
        Object object = lock;
        synchronized (object) {
            if (activeTracingFramework != null && activeTracingFramework != TracingFramework.OPEN_CENSUS) {
                throw new IllegalStateException("ActiveTracingFramework is set to OpenTelemetry and cannot be reset after SpannerOptions object is created.");
            }
            activeTracingFramework = TracingFramework.OPEN_CENSUS;
        }
    }

    @ObsoleteApi(value="The OpenCensus project is deprecated. Use enableOpenTelemetryTraces to switch to OpenTelemetry traces")
    static void resetActiveTracingFramework() {
        activeTracingFramework = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TracingFramework getActiveTracingFramework() {
        Object object = lock;
        synchronized (object) {
            if (activeTracingFramework == null) {
                return TracingFramework.OPEN_CENSUS;
            }
            return activeTracingFramework;
        }
    }

    public static void disableOpenCensusMetrics() {
        enableOpenCensusMetrics = false;
    }

    @VisibleForTesting
    static void enableOpenCensusMetrics() {
        enableOpenCensusMetrics = true;
    }

    public static boolean isEnabledOpenCensusMetrics() {
        return enableOpenCensusMetrics;
    }

    public static void enableOpenTelemetryMetrics() {
        enableOpenTelemetryMetrics = true;
    }

    public static boolean isEnabledOpenTelemetryMetrics() {
        return enableOpenTelemetryMetrics;
    }

    protected String getDefaultProject() {
        String projectId = SpannerOptions.getDefaultProjectId();
        if (projectId == null && System.getenv("SPANNER_EMULATOR_HOST") != null) {
            return "emulator-project";
        }
        return projectId;
    }

    public TransportChannelProvider getChannelProvider() {
        return this.channelProvider;
    }

    public ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> getChannelConfigurator() {
        return this.channelConfigurator;
    }

    public GrpcInterceptorProvider getInterceptorProvider() {
        return this.interceptorProvider;
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public String getTransportChannelExecutorThreadNameFormat() {
        return this.transportChannelExecutorThreadNameFormat;
    }

    public SessionPoolOptions getSessionPoolOptions() {
        return this.sessionPoolOptions;
    }

    public String getDatabaseRole() {
        return this.databaseRole;
    }

    public Map<String, String> getSessionLabels() {
        return this.sessionLabels;
    }

    public SpannerStubSettings getSpannerStubSettings() {
        return this.spannerStubSettings;
    }

    public InstanceAdminStubSettings getInstanceAdminStubSettings() {
        return this.instanceAdminStubSettings;
    }

    public DatabaseAdminStubSettings getDatabaseAdminStubSettings() {
        return this.databaseAdminStubSettings;
    }

    public Duration getPartitionedDmlTimeout() {
        return this.partitionedDmlTimeout;
    }

    public boolean isGrpcGcpExtensionEnabled() {
        return this.grpcGcpExtensionEnabled;
    }

    public GcpManagedChannelOptions getGrpcGcpOptions() {
        return this.grpcGcpOptions;
    }

    public boolean isAutoThrottleAdministrativeRequests() {
        return this.autoThrottleAdministrativeRequests;
    }

    public RetrySettings getRetryAdministrativeRequestsSettings() {
        return this.retryAdministrativeRequestsSettings;
    }

    public boolean isTrackTransactionStarter() {
        return this.trackTransactionStarter;
    }

    public CallCredentialsProvider getCallCredentialsProvider() {
        return this.callCredentialsProvider;
    }

    public String getCompressorName() {
        return this.compressorName;
    }

    public boolean isLeaderAwareRoutingEnabled() {
        return this.leaderAwareRoutingEnabled;
    }

    public DirectedReadOptions getDirectedReadOptions() {
        return this.directedReadOptions;
    }

    @BetaApi
    public boolean isAttemptDirectPath() {
        return this.attemptDirectPath;
    }

    public OpenTelemetry getOpenTelemetry() {
        if (this.openTelemetry != null) {
            return this.openTelemetry;
        }
        return GlobalOpenTelemetry.get();
    }

    public ApiTracerFactory getApiTracerFactory() {
        ArrayList<ApiTracerFactory> apiTracerFactories = new ArrayList<ApiTracerFactory>();
        apiTracerFactories.add((ApiTracerFactory)MoreObjects.firstNonNull((Object)super.getApiTracerFactory(), (Object)this.getDefaultApiTracerFactory()));
        return new CompositeTracerFactory(apiTracerFactories);
    }

    private ApiTracerFactory getDefaultApiTracerFactory() {
        if (this.isEnableApiTracing()) {
            if (activeTracingFramework == TracingFramework.OPEN_TELEMETRY) {
                return new OpenTelemetryApiTracerFactory(this.getOpenTelemetry().getTracer("cloud.google.com/java", GaxProperties.getLibraryVersion(((Object)((Object)this)).getClass())), Attributes.empty());
            }
            if (activeTracingFramework == TracingFramework.OPEN_CENSUS) {
                return new OpencensusTracerFactory();
            }
        }
        return BaseApiTracerFactory.getInstance();
    }

    public boolean isEnableApiTracing() {
        return this.enableApiTracing;
    }

    @BetaApi
    public boolean isUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    public boolean isEnableExtendedTracing() {
        return this.enableExtendedTracing;
    }

    public ExecuteSqlRequest.QueryOptions getDefaultQueryOptions(DatabaseId databaseId) {
        ExecuteSqlRequest.QueryOptions options = this.mergedQueryOptions.get(databaseId);
        if (options == null) {
            options = this.envQueryOptions;
        }
        return options;
    }

    public CloseableExecutorProvider getAsyncExecutorProvider() {
        return this.asyncExecutorProvider;
    }

    public int getPrefetchChunks() {
        return this.prefetchChunks;
    }

    public DecodeMode getDecodeMode() {
        return this.decodeMode;
    }

    public static GrpcTransportOptions getDefaultGrpcTransportOptions() {
        return GrpcTransportOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    public Set<String> getScopes() {
        return SCOPES;
    }

    protected SpannerRpc getSpannerRpcV1() {
        return (SpannerRpc)this.getRpc();
    }

    protected boolean shouldRefreshService(Spanner cachedService) {
        return cachedService == null || cachedService.isClosed();
    }

    protected boolean shouldRefreshRpc(ServiceRpc cachedRpc) {
        return cachedRpc == null || ((SpannerRpc)cachedRpc).isClosed();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String getEndpoint() {
        URL url;
        try {
            url = new URL(this.getHost());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid host: " + this.getHost(), e);
        }
        return String.format("%s:%s", url.getHost(), url.getPort() < 0 ? url.getDefaultPort() : url.getPort());
    }

    static {
        CALL_CONTEXT_CONFIGURATOR_KEY = Context.key((String)"call-context-configurator");
        DEFAULT_POOL_COUNT = new AtomicInteger();
    }

    static enum TracingFramework {
        OPEN_CENSUS,
        OPEN_TELEMETRY;

    }

    public static interface CloseableExecutorProvider
    extends ExecutorProvider,
    AutoCloseable {
        @Override
        public void close();
    }

    public static interface CallCredentialsProvider {
        public CallCredentials getCallCredentials();
    }

    public static interface SpannerEnvironment {
        @Nonnull
        default public String getOptimizerVersion() {
            return "";
        }

        @Nonnull
        default public String getOptimizerStatisticsPackage() {
            return "";
        }

        default public boolean isEnableExtendedTracing() {
            return false;
        }

        default public boolean isEnableApiTracing() {
            return false;
        }
    }

    public static class FixedCloseableExecutorProvider
    implements CloseableExecutorProvider {
        private final ScheduledExecutorService executor;

        private FixedCloseableExecutorProvider(ScheduledExecutorService executor) {
            this.executor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)executor);
        }

        @Override
        public void close() {
            this.executor.shutdown();
        }

        public ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        public boolean shouldAutoClose() {
            return false;
        }

        public static FixedCloseableExecutorProvider create(ScheduledExecutorService executor) {
            return new FixedCloseableExecutorProvider(executor);
        }
    }

    private static class SpannerDefaults
    implements ServiceDefaults<Spanner, SpannerOptions> {
        private SpannerDefaults() {
        }

        public SpannerFactory getDefaultServiceFactory() {
            return DefaultSpannerFactory.INSTANCE;
        }

        public SpannerRpcFactory getDefaultRpcFactory() {
            return DefaultSpannerRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return SpannerOptions.getDefaultGrpcTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Spanner, SpannerOptions, Builder> {
        static final int DEFAULT_PREFETCH_CHUNKS = 4;
        static final ExecuteSqlRequest.QueryOptions DEFAULT_QUERY_OPTIONS = ExecuteSqlRequest.QueryOptions.getDefaultInstance();
        static final DecodeMode DEFAULT_DECODE_MODE = DecodeMode.DIRECT;
        static final RetrySettings DEFAULT_ADMIN_REQUESTS_LIMIT_EXCEEDED_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofSeconds((long)5L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofSeconds((long)60L)).setMaxAttempts(10).build();
        private final ImmutableSet<String> allowedClientLibTokens = ImmutableSet.of((Object)ServiceOptions.getGoogApiClientLibName(), (Object)Builder.createCustomClientLibToken("sp-jdbc"), (Object)Builder.createCustomClientLibToken("sp-hib"), (Object)Builder.createCustomClientLibToken("sp-liq"), (Object)Builder.createCustomClientLibToken("pg-adapter"));
        private TransportChannelProvider channelProvider;
        private ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator;
        private GrpcInterceptorProvider interceptorProvider;
        private Integer numChannels;
        private String transportChannelExecutorThreadNameFormat = "Cloud-Spanner-TransportChannel-%d";
        private int prefetchChunks = 4;
        private DecodeMode decodeMode = DEFAULT_DECODE_MODE;
        private SessionPoolOptions sessionPoolOptions;
        private String databaseRole;
        private ImmutableMap<String, String> sessionLabels;
        private SpannerStubSettings.Builder spannerStubSettingsBuilder = SpannerStubSettings.newBuilder();
        private InstanceAdminStubSettings.Builder instanceAdminStubSettingsBuilder = InstanceAdminStubSettings.newBuilder();
        private DatabaseAdminStubSettings.Builder databaseAdminStubSettingsBuilder = DatabaseAdminStubSettings.newBuilder();
        private Duration partitionedDmlTimeout = Duration.ofHours((long)2L);
        private boolean grpcGcpExtensionEnabled = false;
        private GcpManagedChannelOptions grpcGcpOptions;
        private RetrySettings retryAdministrativeRequestsSettings = DEFAULT_ADMIN_REQUESTS_LIMIT_EXCEEDED_RETRY_SETTINGS;
        private boolean autoThrottleAdministrativeRequests = false;
        private boolean trackTransactionStarter = false;
        private Map<DatabaseId, ExecuteSqlRequest.QueryOptions> defaultQueryOptions = new HashMap<DatabaseId, ExecuteSqlRequest.QueryOptions>();
        private CallCredentialsProvider callCredentialsProvider;
        private CloseableExecutorProvider asyncExecutorProvider;
        private String compressorName;
        private String emulatorHost = System.getenv("SPANNER_EMULATOR_HOST");
        private boolean leaderAwareRoutingEnabled = true;
        private boolean attemptDirectPath = true;
        private DirectedReadOptions directedReadOptions;
        private boolean useVirtualThreads = false;
        private OpenTelemetry openTelemetry;
        private boolean enableApiTracing = SpannerOptions.access$3300().isEnableApiTracing();
        private boolean enableExtendedTracing = SpannerOptions.access$3300().isEnableExtendedTracing();

        private static String createCustomClientLibToken(String token) {
            return token + " " + ServiceOptions.getGoogApiClientLibName();
        }

        protected Builder() {
            OperationTimedPollAlgorithm longRunningPollingAlgorithm = OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setMaxRpcTimeout(Duration.ofSeconds((long)600L)).setInitialRetryDelay(Duration.ofSeconds((long)20L)).setMaxRetryDelay(Duration.ofSeconds((long)45L)).setRetryDelayMultiplier(1.5).setRpcTimeoutMultiplier(1.5).setTotalTimeout(Duration.ofHours((long)48L)).build());
            this.databaseAdminStubSettingsBuilder.createDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)longRunningPollingAlgorithm);
            this.databaseAdminStubSettingsBuilder.createBackupOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)longRunningPollingAlgorithm);
            this.databaseAdminStubSettingsBuilder.restoreDatabaseOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)longRunningPollingAlgorithm);
        }

        Builder(SpannerOptions options) {
            super((ServiceOptions)options);
            if (options.getHost() != null && this.emulatorHost != null && !options.getHost().equals(this.emulatorHost)) {
                this.emulatorHost = null;
            }
            this.numChannels = options.numChannels;
            this.transportChannelExecutorThreadNameFormat = options.transportChannelExecutorThreadNameFormat;
            this.sessionPoolOptions = options.sessionPoolOptions;
            this.prefetchChunks = options.prefetchChunks;
            this.decodeMode = options.decodeMode;
            this.databaseRole = options.databaseRole;
            this.sessionLabels = options.sessionLabels;
            this.spannerStubSettingsBuilder = options.spannerStubSettings.toBuilder();
            this.instanceAdminStubSettingsBuilder = options.instanceAdminStubSettings.toBuilder();
            this.databaseAdminStubSettingsBuilder = options.databaseAdminStubSettings.toBuilder();
            this.partitionedDmlTimeout = options.partitionedDmlTimeout;
            this.grpcGcpExtensionEnabled = options.grpcGcpExtensionEnabled;
            this.grpcGcpOptions = options.grpcGcpOptions;
            this.autoThrottleAdministrativeRequests = options.autoThrottleAdministrativeRequests;
            this.retryAdministrativeRequestsSettings = options.retryAdministrativeRequestsSettings;
            this.trackTransactionStarter = options.trackTransactionStarter;
            this.defaultQueryOptions = options.defaultQueryOptions;
            this.callCredentialsProvider = options.callCredentialsProvider;
            this.asyncExecutorProvider = options.asyncExecutorProvider;
            this.compressorName = options.compressorName;
            this.channelProvider = options.channelProvider;
            this.channelConfigurator = options.channelConfigurator;
            this.interceptorProvider = options.interceptorProvider;
            this.attemptDirectPath = options.attemptDirectPath;
            this.directedReadOptions = options.directedReadOptions;
            this.useVirtualThreads = options.useVirtualThreads;
            this.enableApiTracing = options.enableApiTracing;
            this.enableExtendedTracing = options.enableExtendedTracing;
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only grpc transport is allowed for Spanner.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        protected Set<String> getAllowedClientLibTokens() {
            return this.allowedClientLibTokens;
        }

        @InternalApi
        public Builder setClientLibToken(String clientLibToken) {
            return (Builder)super.setClientLibToken(clientLibToken + " " + ServiceOptions.getGoogApiClientLibName());
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = channelProvider;
            return this;
        }

        public Builder setChannelConfigurator(ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator) {
            this.channelConfigurator = channelConfigurator;
            return this;
        }

        public Builder setInterceptorProvider(GrpcInterceptorProvider interceptorProvider) {
            this.interceptorProvider = interceptorProvider;
            return this;
        }

        public Builder setNumChannels(int numChannels) {
            this.numChannels = numChannels;
            return this;
        }

        Builder setTransportChannelExecutorThreadNameFormat(String transportChannelExecutorThreadNameFormat) {
            this.transportChannelExecutorThreadNameFormat = transportChannelExecutorThreadNameFormat;
            return this;
        }

        public Builder setSessionPoolOption(SessionPoolOptions sessionPoolOptions) {
            this.sessionPoolOptions = sessionPoolOptions;
            return this;
        }

        public Builder setDatabaseRole(String databaseRole) {
            this.databaseRole = databaseRole;
            return this;
        }

        public Builder setSessionLabels(Map<String, String> sessionLabels) {
            Preconditions.checkNotNull(sessionLabels, (Object)"Session labels map cannot be null");
            for (String value : sessionLabels.values()) {
                Preconditions.checkNotNull((Object)value, (Object)"Null values are not allowed in the labels map.");
            }
            this.sessionLabels = ImmutableMap.copyOf(sessionLabels);
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            throw new UnsupportedOperationException("SpannerOptions does not support setting global retry settings. Call spannerStubSettingsBuilder().<method-name>Settings().setRetrySettings(RetrySettings) instead.");
        }

        public SpannerStubSettings.Builder getSpannerStubSettingsBuilder() {
            return this.spannerStubSettingsBuilder;
        }

        public InstanceAdminStubSettings.Builder getInstanceAdminStubSettingsBuilder() {
            return this.instanceAdminStubSettingsBuilder;
        }

        public DatabaseAdminStubSettings.Builder getDatabaseAdminStubSettingsBuilder() {
            return this.databaseAdminStubSettingsBuilder;
        }

        public Builder setPartitionedDmlTimeout(Duration timeout) {
            this.partitionedDmlTimeout = timeout;
            return this;
        }

        public Builder setAutoThrottleAdministrativeRequests() {
            this.autoThrottleAdministrativeRequests = true;
            return this;
        }

        public Builder disableAdministrativeRequestRetries() {
            this.retryAdministrativeRequestsSettings = this.retryAdministrativeRequestsSettings.toBuilder().setMaxAttempts(1).build();
            return this;
        }

        Builder setRetryAdministrativeRequestsSettings(RetrySettings retryAdministrativeRequestsSettings) {
            this.retryAdministrativeRequestsSettings = (RetrySettings)Preconditions.checkNotNull((Object)retryAdministrativeRequestsSettings);
            return this;
        }

        public Builder setTrackTransactionStarter() {
            this.trackTransactionStarter = true;
            return this;
        }

        public Builder setDefaultQueryOptions(DatabaseId database, ExecuteSqlRequest.QueryOptions defaultQueryOptions) {
            this.defaultQueryOptions.put(database, defaultQueryOptions);
            return this;
        }

        ExecuteSqlRequest.QueryOptions getEnvironmentQueryOptions() {
            return ExecuteSqlRequest.QueryOptions.newBuilder().setOptimizerVersion(environment.getOptimizerVersion()).setOptimizerStatisticsPackage(environment.getOptimizerStatisticsPackage()).build();
        }

        public Builder setCallCredentialsProvider(CallCredentialsProvider callCredentialsProvider) {
            this.callCredentialsProvider = callCredentialsProvider;
            return this;
        }

        @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1704")
        public Builder setCompressorName(@Nullable String compressorName) {
            Preconditions.checkArgument((compressorName == null || CompressorRegistry.getDefaultInstance().lookupCompressor(compressorName) != null ? 1 : 0) != 0, (Object)String.format("%s is not a known compressor", compressorName));
            this.compressorName = compressorName;
            return this;
        }

        public Builder setAsyncExecutorProvider(CloseableExecutorProvider provider) {
            this.asyncExecutorProvider = provider;
            return this;
        }

        public Builder setDirectedReadOptions(DirectedReadOptions directedReadOptions) {
            this.directedReadOptions = (DirectedReadOptions)Preconditions.checkNotNull((Object)directedReadOptions, (Object)"DirectedReadOptions cannot be null");
            return this;
        }

        public Builder setPrefetchChunks(int prefetchChunks) {
            this.prefetchChunks = prefetchChunks;
            return this;
        }

        public Builder setDecodeMode(DecodeMode decodeMode) {
            this.decodeMode = decodeMode;
            return this;
        }

        public Builder setHost(String host) {
            super.setHost(host);
            this.setEmulatorHost(null);
            return this;
        }

        public Builder enableGrpcGcpExtension() {
            return this.enableGrpcGcpExtension(null);
        }

        public Builder enableGrpcGcpExtension(GcpManagedChannelOptions options) {
            this.grpcGcpExtensionEnabled = true;
            this.grpcGcpOptions = options;
            return this;
        }

        public Builder disableGrpcGcpExtension() {
            this.grpcGcpExtensionEnabled = false;
            return this;
        }

        public Builder setEmulatorHost(String emulatorHost) {
            this.emulatorHost = emulatorHost;
            return this;
        }

        public Builder setOpenTelemetry(OpenTelemetry openTelemetry) {
            this.openTelemetry = openTelemetry;
            return this;
        }

        public Builder enableLeaderAwareRouting() {
            this.leaderAwareRoutingEnabled = true;
            return this;
        }

        public Builder disableLeaderAwareRouting() {
            this.leaderAwareRoutingEnabled = false;
            return this;
        }

        @BetaApi
        public Builder disableDirectPath() {
            this.attemptDirectPath = false;
            return this;
        }

        @BetaApi
        protected Builder setUseVirtualThreads(boolean useVirtualThreads) {
            this.useVirtualThreads = useVirtualThreads;
            return this;
        }

        public Builder setEnableApiTracing(boolean enableApiTracing) {
            this.enableApiTracing = enableApiTracing;
            return this;
        }

        public Builder setEnableExtendedTracing(boolean enableExtendedTracing) {
            this.enableExtendedTracing = enableExtendedTracing;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SpannerOptions build() {
            if (this.emulatorHost != null) {
                if (!this.emulatorHost.startsWith("http")) {
                    this.emulatorHost = "http://" + this.emulatorHost;
                }
                this.setHost(this.emulatorHost);
                this.setChannelConfigurator((ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>)((ApiFunction)ManagedChannelBuilder::usePlaintext));
                this.setCredentials((Credentials)NoCredentials.getInstance());
            }
            if (this.numChannels == null) {
                this.numChannels = this.grpcGcpExtensionEnabled ? 8 : 4;
            }
            Object object = lock;
            synchronized (object) {
                if (activeTracingFramework == null) {
                    activeTracingFramework = TracingFramework.OPEN_CENSUS;
                }
            }
            return new SpannerOptions(this);
        }
    }

    private static class SpannerEnvironmentImpl
    implements SpannerEnvironment {
        private static final SpannerEnvironmentImpl INSTANCE = new SpannerEnvironmentImpl();
        private static final String SPANNER_OPTIMIZER_VERSION_ENV_VAR = "SPANNER_OPTIMIZER_VERSION";
        private static final String SPANNER_OPTIMIZER_STATISTICS_PACKAGE_ENV_VAR = "SPANNER_OPTIMIZER_STATISTICS_PACKAGE";
        private static final String SPANNER_ENABLE_EXTENDED_TRACING = "SPANNER_ENABLE_EXTENDED_TRACING";
        private static final String SPANNER_ENABLE_API_TRACING = "SPANNER_ENABLE_API_TRACING";

        private SpannerEnvironmentImpl() {
        }

        @Override
        @Nonnull
        public String getOptimizerVersion() {
            return (String)MoreObjects.firstNonNull((Object)System.getenv(SPANNER_OPTIMIZER_VERSION_ENV_VAR), (Object)"");
        }

        @Override
        @Nonnull
        public String getOptimizerStatisticsPackage() {
            return (String)MoreObjects.firstNonNull((Object)System.getenv(SPANNER_OPTIMIZER_STATISTICS_PACKAGE_ENV_VAR), (Object)"");
        }

        @Override
        public boolean isEnableExtendedTracing() {
            return Boolean.parseBoolean(System.getenv(SPANNER_ENABLE_EXTENDED_TRACING));
        }

        @Override
        public boolean isEnableApiTracing() {
            return Boolean.parseBoolean(System.getenv(SPANNER_ENABLE_API_TRACING));
        }
    }

    private static class DefaultSpannerRpcFactory
    implements SpannerRpcFactory {
        private static final DefaultSpannerRpcFactory INSTANCE = new DefaultSpannerRpcFactory();

        private DefaultSpannerRpcFactory() {
        }

        public ServiceRpc create(SpannerOptions options) {
            return new GapicSpannerRpc(options);
        }
    }

    private static class DefaultSpannerFactory
    implements SpannerFactory {
        private static final DefaultSpannerFactory INSTANCE = new DefaultSpannerFactory();

        private DefaultSpannerFactory() {
        }

        public Spanner create(SpannerOptions serviceOptions) {
            return new SpannerImpl(serviceOptions);
        }
    }

    public static class SpannerCallContextTimeoutConfigurator
    implements CallContextConfigurator {
        private Duration commitTimeout;
        private Duration rollbackTimeout;
        private Duration executeQueryTimeout;
        private Duration executeUpdateTimeout;
        private Duration batchUpdateTimeout;
        private Duration readTimeout;
        private Duration partitionQueryTimeout;
        private Duration partitionReadTimeout;

        public static SpannerCallContextTimeoutConfigurator create() {
            return new SpannerCallContextTimeoutConfigurator();
        }

        private SpannerCallContextTimeoutConfigurator() {
        }

        @Override
        public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
            SpannerMethod spannerMethod = SpannerMethod.valueOf(request, method);
            if (spannerMethod == null) {
                return null;
            }
            switch (SpannerMethod.valueOf(request, method)) {
                case BATCH_UPDATE: {
                    return this.batchUpdateTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.batchUpdateTimeout);
                }
                case COMMIT: {
                    return this.commitTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.commitTimeout);
                }
                case EXECUTE_QUERY: {
                    return this.executeQueryTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.executeQueryTimeout).withStreamWaitTimeout(this.executeQueryTimeout);
                }
                case EXECUTE_UPDATE: {
                    return this.executeUpdateTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.executeUpdateTimeout);
                }
                case PARTITION_QUERY: {
                    return this.partitionQueryTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.partitionQueryTimeout);
                }
                case PARTITION_READ: {
                    return this.partitionReadTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.partitionReadTimeout);
                }
                case READ: {
                    return this.readTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.readTimeout).withStreamWaitTimeout(this.readTimeout);
                }
                case ROLLBACK: {
                    return this.rollbackTimeout == null ? null : GrpcCallContext.createDefault().withTimeout(this.rollbackTimeout);
                }
            }
            return null;
        }

        public Duration getCommitTimeout() {
            return this.commitTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withCommitTimeout(Duration commitTimeout) {
            this.commitTimeout = commitTimeout;
            return this;
        }

        public Duration getRollbackTimeout() {
            return this.rollbackTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withRollbackTimeout(Duration rollbackTimeout) {
            this.rollbackTimeout = rollbackTimeout;
            return this;
        }

        public Duration getExecuteQueryTimeout() {
            return this.executeQueryTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withExecuteQueryTimeout(Duration executeQueryTimeout) {
            this.executeQueryTimeout = executeQueryTimeout;
            return this;
        }

        public Duration getExecuteUpdateTimeout() {
            return this.executeUpdateTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withExecuteUpdateTimeout(Duration executeUpdateTimeout) {
            this.executeUpdateTimeout = executeUpdateTimeout;
            return this;
        }

        public Duration getBatchUpdateTimeout() {
            return this.batchUpdateTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withBatchUpdateTimeout(Duration batchUpdateTimeout) {
            this.batchUpdateTimeout = batchUpdateTimeout;
            return this;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Duration getPartitionQueryTimeout() {
            return this.partitionQueryTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withPartitionQueryTimeout(Duration partitionQueryTimeout) {
            this.partitionQueryTimeout = partitionQueryTimeout;
            return this;
        }

        public Duration getPartitionReadTimeout() {
            return this.partitionReadTimeout;
        }

        public SpannerCallContextTimeoutConfigurator withPartitionReadTimeout(Duration partitionReadTimeout) {
            this.partitionReadTimeout = partitionReadTimeout;
            return this;
        }
    }

    private static enum SpannerMethod {
        COMMIT{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getCommitMethod();
            }
        }
        ,
        ROLLBACK{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getRollbackMethod();
            }
        }
        ,
        EXECUTE_QUERY{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getExecuteStreamingSqlMethod();
            }
        }
        ,
        READ{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getStreamingReadMethod();
            }
        }
        ,
        EXECUTE_UPDATE{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                if (method == SpannerGrpc.getExecuteSqlMethod()) {
                    ExecuteSqlRequest sqlRequest = (ExecuteSqlRequest)request;
                    return sqlRequest.getSeqno() != 0L;
                }
                return false;
            }
        }
        ,
        BATCH_UPDATE{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getExecuteBatchDmlMethod();
            }
        }
        ,
        PARTITION_QUERY{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getPartitionQueryMethod();
            }
        }
        ,
        PARTITION_READ{

            @Override
            <ReqT, RespT> boolean isMethod(ReqT request, MethodDescriptor<ReqT, RespT> method) {
                return method == SpannerGrpc.getPartitionReadMethod();
            }
        };


        abstract <ReqT, RespT> boolean isMethod(ReqT var1, MethodDescriptor<ReqT, RespT> var2);

        static <ReqT, RespT> SpannerMethod valueOf(ReqT request, MethodDescriptor<ReqT, RespT> method) {
            for (SpannerMethod m : SpannerMethod.values()) {
                if (!m.isMethod(request, method)) continue;
                return m;
            }
            return null;
        }
    }

    public static interface CallContextConfigurator {
        @Nullable
        public <ReqT, RespT> ApiCallContext configure(ApiCallContext var1, ReqT var2, MethodDescriptor<ReqT, RespT> var3);
    }
}

