/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.CommitStats;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionImpl;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ReadOnlyStalenessUtil;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Duration;
import com.google.spanner.v1.RequestOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class ConnectionStatementExecutorImpl
implements ConnectionStatementExecutor {
    private static final Map<RequestOptions.Priority, Options.RpcPriority> validRPCPriorityValues;
    private final ConnectionImpl connection;

    ConnectionStatementExecutorImpl(ConnectionImpl connection) {
        this.connection = connection;
    }

    ConnectionImpl getConnection() {
        return this.connection;
    }

    @Override
    public StatementResult statementSetAutocommit(Boolean autocommit) {
        Preconditions.checkNotNull((Object)autocommit);
        this.getConnection().setAutocommit(autocommit);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_AUTOCOMMIT);
    }

    @Override
    public StatementResult statementShowAutocommit() {
        return StatementResultImpl.resultSet("AUTOCOMMIT", this.getConnection().isAutocommit(), StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT);
    }

    @Override
    public StatementResult statementSetReadOnly(Boolean readOnly) {
        Preconditions.checkNotNull((Object)readOnly);
        this.getConnection().setReadOnly(readOnly);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_READONLY);
    }

    @Override
    public StatementResult statementShowReadOnly() {
        return StatementResultImpl.resultSet("READONLY", this.getConnection().isReadOnly(), StatementResult.ClientSideStatementType.SHOW_READONLY);
    }

    @Override
    public StatementResult statementSetRetryAbortsInternally(Boolean retryAbortsInternally) {
        Preconditions.checkNotNull((Object)retryAbortsInternally);
        this.getConnection().setRetryAbortsInternally(retryAbortsInternally);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RETRY_ABORTS_INTERNALLY);
    }

    @Override
    public StatementResult statementShowRetryAbortsInternally() {
        return StatementResultImpl.resultSet("RETRY_ABORTS_INTERNALLY", this.getConnection().isRetryAbortsInternally(), StatementResult.ClientSideStatementType.SHOW_RETRY_ABORTS_INTERNALLY);
    }

    @Override
    public StatementResult statementSetAutocommitDmlMode(AutocommitDmlMode mode) {
        this.getConnection().setAutocommitDmlMode(mode);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_AUTOCOMMIT_DML_MODE);
    }

    @Override
    public StatementResult statementShowAutocommitDmlMode() {
        return StatementResultImpl.resultSet("AUTOCOMMIT_DML_MODE", this.getConnection().getAutocommitDmlMode(), StatementResult.ClientSideStatementType.SHOW_AUTOCOMMIT_DML_MODE);
    }

    @Override
    public StatementResult statementSetStatementTimeout(Duration duration) {
        if (duration.getSeconds() == 0L && duration.getNanos() == 0) {
            this.getConnection().clearStatementTimeout();
        } else {
            TimeUnit unit = ReadOnlyStalenessUtil.getAppropriateTimeUnit(new ReadOnlyStalenessUtil.DurationGetter(duration));
            this.getConnection().setStatementTimeout(ReadOnlyStalenessUtil.durationToUnits(duration, unit), unit);
        }
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_STATEMENT_TIMEOUT);
    }

    @Override
    public StatementResult statementShowStatementTimeout() {
        return StatementResultImpl.resultSet("STATEMENT_TIMEOUT", this.getConnection().hasStatementTimeout() ? ReadOnlyStalenessUtil.durationToString(new StatementTimeoutGetter(this.getConnection())) : null, StatementResult.ClientSideStatementType.SHOW_STATEMENT_TIMEOUT);
    }

    @Override
    public StatementResult statementShowReadTimestamp() {
        return StatementResultImpl.resultSet("READ_TIMESTAMP", this.getConnection().getReadTimestampOrNull(), StatementResult.ClientSideStatementType.SHOW_READ_TIMESTAMP);
    }

    @Override
    public StatementResult statementShowCommitTimestamp() {
        return StatementResultImpl.resultSet("COMMIT_TIMESTAMP", this.getConnection().getCommitTimestampOrNull(), StatementResult.ClientSideStatementType.SHOW_COMMIT_TIMESTAMP);
    }

    @Override
    public StatementResult statementShowCommitResponse() {
        CommitResponse response = this.getConnection().getCommitResponseOrNull();
        CommitStats stats = null;
        if (response != null && response.hasCommitStats()) {
            stats = response.getCommitStats();
        }
        ResultSet resultSet = ResultSets.forRows(Type.struct(Type.StructField.of("COMMIT_TIMESTAMP", Type.timestamp()), Type.StructField.of("MUTATION_COUNT", Type.int64())), Arrays.asList(Struct.newBuilder().set("COMMIT_TIMESTAMP").to(response == null ? null : response.getCommitTimestamp()).set("MUTATION_COUNT").to(stats == null ? null : Long.valueOf(stats.getMutationCount())).build()));
        return StatementResultImpl.of(resultSet, StatementResult.ClientSideStatementType.SHOW_COMMIT_RESPONSE);
    }

    @Override
    public StatementResult statementSetReadOnlyStaleness(TimestampBound staleness) {
        this.getConnection().setReadOnlyStaleness(staleness);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_READ_ONLY_STALENESS);
    }

    @Override
    public StatementResult statementShowReadOnlyStaleness() {
        TimestampBound staleness = this.getConnection().getReadOnlyStaleness();
        return StatementResultImpl.resultSet("READ_ONLY_STALENESS", ReadOnlyStalenessUtil.timestampBoundToString(staleness), StatementResult.ClientSideStatementType.SHOW_READ_ONLY_STALENESS);
    }

    @Override
    public StatementResult statementSetOptimizerVersion(String optimizerVersion) {
        this.getConnection().setOptimizerVersion(optimizerVersion);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_OPTIMIZER_VERSION);
    }

    @Override
    public StatementResult statementShowOptimizerVersion() {
        return StatementResultImpl.resultSet("OPTIMIZER_VERSION", this.getConnection().getOptimizerVersion(), StatementResult.ClientSideStatementType.SHOW_OPTIMIZER_VERSION);
    }

    @Override
    public StatementResult statementSetOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        this.getConnection().setOptimizerStatisticsPackage(optimizerStatisticsPackage);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_OPTIMIZER_STATISTICS_PACKAGE);
    }

    @Override
    public StatementResult statementShowOptimizerStatisticsPackage() {
        return StatementResultImpl.resultSet("OPTIMIZER_STATISTICS_PACKAGE", this.getConnection().getOptimizerStatisticsPackage(), StatementResult.ClientSideStatementType.SHOW_OPTIMIZER_STATISTICS_PACKAGE);
    }

    @Override
    public StatementResult statementSetReturnCommitStats(Boolean returnCommitStats) {
        this.getConnection().setReturnCommitStats(returnCommitStats);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RETURN_COMMIT_STATS);
    }

    @Override
    public StatementResult statementShowReturnCommitStats() {
        return StatementResultImpl.resultSet("RETURN_COMMIT_STATS", this.getConnection().isReturnCommitStats(), StatementResult.ClientSideStatementType.SHOW_RETURN_COMMIT_STATS);
    }

    @Override
    public StatementResult statementSetStatementTag(String tag) {
        this.getConnection().setStatementTag("".equals(tag) ? null : tag);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_STATEMENT_TAG);
    }

    @Override
    public StatementResult statementShowStatementTag() {
        return StatementResultImpl.resultSet("STATEMENT_TAG", (String)MoreObjects.firstNonNull((Object)this.getConnection().getStatementTag(), (Object)""), StatementResult.ClientSideStatementType.SHOW_STATEMENT_TAG);
    }

    @Override
    public StatementResult statementSetTransactionTag(String tag) {
        this.getConnection().setTransactionTag("".equals(tag) ? null : tag);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_TAG);
    }

    @Override
    public StatementResult statementShowTransactionTag() {
        return StatementResultImpl.resultSet("TRANSACTION_TAG", (String)MoreObjects.firstNonNull((Object)this.getConnection().getTransactionTag(), (Object)""), StatementResult.ClientSideStatementType.SHOW_TRANSACTION_TAG);
    }

    @Override
    public StatementResult statementBeginTransaction() {
        this.getConnection().beginTransaction();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.BEGIN);
    }

    @Override
    public StatementResult statementCommit() {
        this.getConnection().commit();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.COMMIT);
    }

    @Override
    public StatementResult statementRollback() {
        this.getConnection().rollback();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.ROLLBACK);
    }

    @Override
    public StatementResult statementSetTransactionMode(TransactionMode mode) {
        this.getConnection().setTransactionMode(mode);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_TRANSACTION_MODE);
    }

    @Override
    public StatementResult statementStartBatchDdl() {
        this.getConnection().startBatchDdl();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.START_BATCH_DDL);
    }

    @Override
    public StatementResult statementStartBatchDml() {
        this.getConnection().startBatchDml();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.START_BATCH_DML);
    }

    @Override
    public StatementResult statementRunBatch() {
        long[] updateCounts = this.getConnection().runBatch();
        return StatementResultImpl.resultSet("UPDATE_COUNTS", updateCounts, StatementResult.ClientSideStatementType.RUN_BATCH);
    }

    @Override
    public StatementResult statementAbortBatch() {
        this.getConnection().abortBatch();
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.ABORT_BATCH);
    }

    @Override
    public StatementResult statementSetRPCPriority(RequestOptions.Priority priority) {
        Options.RpcPriority value = validRPCPriorityValues.get(priority);
        this.getConnection().setRPCPriority(value);
        return StatementResultImpl.noResult(StatementResult.ClientSideStatementType.SET_RPC_PRIORITY);
    }

    @Override
    public StatementResult statementShowRPCPriority() {
        return StatementResultImpl.resultSet("RPC_PRIORITY", this.getConnection().getRPCPriority() == null ? RequestOptions.Priority.PRIORITY_UNSPECIFIED : this.getConnection().getRPCPriority(), StatementResult.ClientSideStatementType.SHOW_RPC_PRIORITY);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)RequestOptions.Priority.PRIORITY_HIGH, (Object)Options.RpcPriority.HIGH);
        builder.put((Object)RequestOptions.Priority.PRIORITY_MEDIUM, (Object)Options.RpcPriority.MEDIUM);
        builder.put((Object)RequestOptions.Priority.PRIORITY_LOW, (Object)Options.RpcPriority.LOW);
        validRPCPriorityValues = builder.build();
    }

    static final class StatementTimeoutGetter
    implements ReadOnlyStalenessUtil.DurationValueGetter {
        private final Connection connection;

        public StatementTimeoutGetter(Connection connection) {
            this.connection = connection;
        }

        @Override
        public long getDuration(TimeUnit unit) {
            return this.connection.getStatementTimeout(unit);
        }

        @Override
        public boolean hasDuration() {
            return this.connection.hasStatementTimeout();
        }
    }
}

