/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.ForwardingAsyncResultSet;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerRetryHelper;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.RequestOptions;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

class TransactionRunnerImpl
implements SessionImpl.SessionTransaction,
TransactionRunner {
    private static final Tracer tracer = Tracing.getTracer();
    private static final Logger txnLogger = Logger.getLogger(TransactionRunner.class.getName());
    private static final String TRANSACTION_CANCELLED_MESSAGE = "invalidated by a later transaction";
    private boolean blockNestedTxn = true;
    private final SessionImpl session;
    private final Options options;
    private Span span;
    private TransactionContextImpl txn;
    private volatile boolean isValid = true;

    @Override
    public TransactionRunner allowNestedTransaction() {
        this.blockNestedTxn = false;
        return this;
    }

    TransactionRunnerImpl(SessionImpl session, Options.TransactionOption ... options) {
        this.session = session;
        this.options = Options.fromTransactionOptions(options);
        this.txn = session.newTransaction(this.options);
    }

    @Override
    public void setSpan(Span span) {
        this.span = span;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public <T> T run(TransactionRunner.TransactionCallable<T> callable) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <T> T runInternal(final TransactionRunner.TransactionCallable<T> txCallable) {
        final AtomicInteger attempt = new AtomicInteger();
        Callable retryCallable = new Callable<T>(){

            @Override
            public T call() {
                Object result;
                boolean useInlinedBegin = true;
                if (attempt.get() > 0) {
                    useInlinedBegin = ((TransactionRunnerImpl)TransactionRunnerImpl.this).txn.transactionId != null;
                    TransactionRunnerImpl.this.txn = TransactionRunnerImpl.this.session.newTransaction(TransactionRunnerImpl.this.options);
                }
                Preconditions.checkState((boolean)TransactionRunnerImpl.this.isValid, (Object)"TransactionRunner has been invalidated by a new operation on the session");
                attempt.incrementAndGet();
                TransactionRunnerImpl.this.span.addAnnotation("Starting Transaction Attempt", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                if (!useInlinedBegin) {
                    TransactionRunnerImpl.this.txn.ensureTxn();
                }
                boolean shouldRollback = true;
                try {
                    result = txCallable.run(TransactionRunnerImpl.this.txn);
                    shouldRollback = false;
                }
                catch (Exception e) {
                    txnLogger.log(Level.FINE, "User-provided TransactionCallable raised exception", e);
                    if (TransactionRunnerImpl.this.txn.isAborted() || e instanceof AbortedException) {
                        TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Aborted in user operation. Retrying", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                        shouldRollback = false;
                        if (e instanceof AbortedException) {
                            throw (AbortedException)((Object)e);
                        }
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), e);
                    }
                    SpannerException toThrow = e instanceof SpannerException ? (SpannerException)((Object)e) : SpannerExceptionFactory.newSpannerException(ErrorCode.UNKNOWN, e.getMessage(), e);
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Failed in user operation", (Map)ImmutableMap.builder().putAll(TraceUtil.getExceptionAnnotations(toThrow)).put((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())).build());
                    throw toThrow;
                }
                finally {
                    if (shouldRollback) {
                        TransactionRunnerImpl.this.txn.rollback();
                    }
                }
                try {
                    TransactionRunnerImpl.this.txn.commit();
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Succeeded", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                    return result;
                }
                catch (AbortedException e) {
                    txnLogger.log(Level.FINE, "Commit aborted", (Throwable)((Object)e));
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Aborted in Commit. Retrying", (Map)ImmutableMap.of((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())));
                    throw e;
                }
                catch (SpannerException e) {
                    TransactionRunnerImpl.this.span.addAnnotation("Transaction Attempt Failed in Commit", (Map)ImmutableMap.builder().putAll(TraceUtil.getExceptionAnnotations(e)).put((Object)"Attempt", (Object)AttributeValue.longAttributeValue((long)attempt.longValue())).build());
                    throw e;
                }
            }
        };
        return SpannerRetryHelper.runTxWithRetriesOnAborted(retryCallable);
    }

    @Override
    public Timestamp getCommitTimestamp() {
        Preconditions.checkState((this.txn != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
        return this.txn.getCommitResponse().getCommitTimestamp();
    }

    @Override
    public CommitResponse getCommitResponse() {
        Preconditions.checkState((this.txn != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
        return this.txn.getCommitResponse();
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @VisibleForTesting
    static class TransactionContextImpl
    extends AbstractReadContext
    implements TransactionContext {
        @GuardedBy(value="lock")
        private volatile boolean committing;
        @GuardedBy(value="lock")
        private volatile SettableApiFuture<Void> finishedAsyncOperations = SettableApiFuture.create();
        @GuardedBy(value="lock")
        private volatile int runningAsyncOperations;
        @GuardedBy(value="lock")
        private List<Mutation> mutations = new ArrayList<Mutation>();
        @GuardedBy(value="lock")
        private boolean aborted;
        private final Options options;
        @GuardedBy(value="lock")
        private long retryDelayInMillis = -1L;
        private volatile SettableApiFuture<ByteString> transactionIdFuture = null;
        @VisibleForTesting
        long waitForTransactionTimeoutMillis = 60000L;
        private final boolean trackTransactionStarter;
        private Exception transactionStarter;
        volatile ByteString transactionId;
        private CommitResponse commitResponse;
        volatile ApiFuture<CommitResponse> commitFuture;

        static Builder newBuilder() {
            return new Builder();
        }

        private TransactionContextImpl(Builder builder) {
            super(builder);
            this.transactionId = builder.transactionId;
            this.trackTransactionStarter = builder.trackTransactionStarter;
            this.options = builder.options;
            this.finishedAsyncOperations.set(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void increaseAsynOperations() {
            Object object = this.lock;
            synchronized (object) {
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations = SettableApiFuture.create();
                }
                ++this.runningAsyncOperations;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void decreaseAsyncOperations() {
            Object object = this.lock;
            synchronized (object) {
                --this.runningAsyncOperations;
                if (this.runningAsyncOperations == 0) {
                    this.finishedAsyncOperations.set(null);
                }
            }
        }

        void ensureTxn() {
            try {
                this.ensureTxnAsync().get();
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }

        ApiFuture<Void> ensureTxnAsync() {
            SettableApiFuture res = SettableApiFuture.create();
            if (this.transactionId == null || this.isAborted()) {
                this.createTxnAsync((SettableApiFuture<Void>)res);
            } else {
                this.span.addAnnotation("Transaction Initialized", (Map)ImmutableMap.of((Object)"Id", (Object)AttributeValue.stringAttributeValue((String)this.transactionId.toStringUtf8())));
                txnLogger.log(Level.FINER, "Using prepared transaction {0}", txnLogger.isLoggable(Level.FINER) ? this.transactionId.asReadOnlyByteBuffer() : null);
                res.set(null);
            }
            return res;
        }

        private void createTxnAsync(final SettableApiFuture<Void> res) {
            this.span.addAnnotation("Creating Transaction");
            final ApiFuture<ByteString> fut = this.session.beginTransactionAsync();
            fut.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        transactionId = (ByteString)fut.get();
                        span.addAnnotation("Transaction Creation Done", (Map)ImmutableMap.of((Object)"Id", (Object)AttributeValue.stringAttributeValue((String)transactionId.toStringUtf8())));
                        txnLogger.log(Level.FINER, "Started transaction {0}", txnLogger.isLoggable(Level.FINER) ? transactionId.asReadOnlyByteBuffer() : null);
                        res.set(null);
                    }
                    catch (ExecutionException e) {
                        span.addAnnotation("Transaction Creation Failed", TraceUtil.getExceptionAnnotations(e.getCause() == null ? e : e.getCause()));
                        res.setException(e.getCause() == null ? e : e.getCause());
                    }
                    catch (InterruptedException e) {
                        res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                    }
                }
            }, MoreExecutors.directExecutor());
        }

        void commit() {
            try {
                this.commitResponse = (CommitResponse)this.commitAsync().get();
            }
            catch (InterruptedException e) {
                if (this.commitFuture != null) {
                    this.commitFuture.cancel(true);
                }
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
            catch (ExecutionException e) {
                throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ApiFuture<CommitResponse> commitAsync() {
            SettableApiFuture finishOps;
            SettableApiFuture res = SettableApiFuture.create();
            CommitRequest.Builder builder = CommitRequest.newBuilder().setSession(this.session.getName()).setReturnCommitStats(this.options.withCommitStats());
            if (this.options.hasPriority() || this.getTransactionTag() != null) {
                RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
                if (this.options.hasPriority()) {
                    requestOptionsBuilder.setPriority(this.options.priority());
                }
                if (this.getTransactionTag() != null) {
                    requestOptionsBuilder.setTransactionTag(this.getTransactionTag());
                }
                builder.setRequestOptions(requestOptionsBuilder.build());
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.transactionIdFuture == null && this.transactionId == null && this.runningAsyncOperations == 0) {
                    finishOps = SettableApiFuture.create();
                    this.createTxnAsync((SettableApiFuture<Void>)finishOps);
                } else {
                    finishOps = this.finishedAsyncOperations;
                }
                if (!this.mutations.isEmpty()) {
                    ArrayList<com.google.spanner.v1.Mutation> mutationsProto = new ArrayList<com.google.spanner.v1.Mutation>();
                    Mutation.toProto(this.mutations, mutationsProto);
                    builder.addAllMutations(mutationsProto);
                }
                this.mutations = null;
            }
            finishOps.addListener((Runnable)new CommitRunnable((SettableApiFuture<CommitResponse>)res, (ApiFuture<Void>)finishOps, builder), MoreExecutors.directExecutor());
            return res;
        }

        CommitResponse getCommitResponse() {
            Preconditions.checkState((this.commitResponse != null ? 1 : 0) != 0, (Object)"run() has not yet returned normally");
            return this.commitResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isAborted() {
            Object object = this.lock;
            synchronized (object) {
                return this.aborted;
            }
        }

        void rollback() {
            try {
                this.rollbackAsync().get();
            }
            catch (ExecutionException e) {
                txnLogger.log(Level.FINE, "Exception during rollback", e);
                this.span.addAnnotation("Rollback Failed", TraceUtil.getExceptionAnnotations(e));
            }
            catch (InterruptedException e) {
                throw SpannerExceptionFactory.propagateInterrupt(e);
            }
        }

        ApiFuture<Empty> rollbackAsync() {
            if (this.transactionId != null) {
                this.span.addAnnotation("Starting Rollback");
                return this.rpc.rollbackAsync(RollbackRequest.newBuilder().setSession(this.session.getName()).setTransactionId(this.transactionId).build(), this.session.getOptions());
            }
            return ApiFutures.immediateFuture((Object)Empty.getDefaultInstance());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        TransactionSelector getTransactionSelector() {
            if (this.transactionId == null) {
                try {
                    SettableApiFuture<ByteString> tx = null;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.transactionIdFuture == null) {
                            this.transactionIdFuture = SettableApiFuture.create();
                            if (this.trackTransactionStarter) {
                                this.transactionStarter = new Exception("Requesting new transaction");
                            }
                        } else {
                            tx = this.transactionIdFuture;
                        }
                    }
                    if (tx == null) {
                        return TransactionSelector.newBuilder().setBegin(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
                    }
                    return TransactionSelector.newBuilder().setId((ByteString)tx.get(this.waitForTransactionTimeoutMillis, TimeUnit.MILLISECONDS)).build();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof AbortedException) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.aborted = true;
                        }
                    }
                    throw SpannerExceptionFactory.newSpannerException(e.getCause());
                }
                catch (TimeoutException e) {
                    SpannerException se = SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Timeout while waiting for a transaction to be returned by another statement." + (this.trackTransactionStarter ? " See the suppressed exception for the stacktrace of the caller that should return a transaction" : ""), e);
                    if (this.transactionStarter != null) {
                        se.addSuppressed(this.transactionStarter);
                    }
                    throw se;
                }
                catch (InterruptedException e) {
                    throw SpannerExceptionFactory.newSpannerExceptionForCancellation(null, e);
                }
            }
            return TransactionSelector.newBuilder().setId(this.transactionId).build();
        }

        @Override
        public void onTransactionMetadata(Transaction transaction, boolean shouldIncludeId) {
            Preconditions.checkNotNull((Object)transaction);
            if (transaction.getId() != ByteString.EMPTY) {
                if (!(this.transactionIdFuture != null && this.transactionIdFuture.isDone() || this.transactionId != null)) {
                    this.transactionId = transaction.getId();
                    this.transactionIdFuture.set((Object)transaction.getId());
                }
            } else if (shouldIncludeId) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "The statement did not return a transaction even though one was requested");
            }
        }

        @Override
        @Nullable
        String getTransactionTag() {
            if (this.options.hasTag()) {
                return this.options.tag();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SpannerException onError(SpannerException e, boolean withBeginTransaction) {
            SpannerException exceptionToThrow;
            if (withBeginTransaction) {
                this.transactionIdFuture.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Aborted due to failed initial statement", (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay("Aborted due to failed initial statement", (Throwable)((Object)e), 0L, 1))));
            }
            if ((exceptionToThrow = withBeginTransaction && e.getErrorCode() == ErrorCode.CANCELLED && e.getMessage().contains(TransactionRunnerImpl.TRANSACTION_CANCELLED_MESSAGE) ? SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, e.getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay("Aborted due to failed initial statement", (Throwable)((Object)e), 0L, 1)) : e).getErrorCode() == ErrorCode.ABORTED) {
                long delay = -1L;
                if (exceptionToThrow instanceof AbortedException) {
                    delay = ((AbortedException)exceptionToThrow).getRetryDelayInMillis();
                }
                if (delay == -1L) {
                    txnLogger.log(Level.FINE, "Retry duration is missing from the exception.", (Throwable)((Object)exceptionToThrow));
                }
                Object object = this.lock;
                synchronized (object) {
                    this.retryDelayInMillis = delay;
                    this.aborted = true;
                }
            }
            return exceptionToThrow;
        }

        @Override
        public void onDone(boolean withBeginTransaction) {
            if (withBeginTransaction && this.transactionIdFuture != null && !this.transactionIdFuture.isDone()) {
                this.transactionIdFuture.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "ResultSet was closed before a transaction id was returned")));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Mutation mutation) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void buffer(Iterable<Mutation> mutations) {
            Object object = this.lock;
            synchronized (object) {
                Preconditions.checkNotNull(this.mutations, (Object)"Context is closed");
                for (Mutation mutation : mutations) {
                    this.mutations.add((Mutation)Preconditions.checkNotNull((Object)mutation));
                }
            }
        }

        @Override
        public long executeUpdate(Statement statement, Options.UpdateOption ... options) {
            this.beforeReadOrQuery();
            ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, ExecuteSqlRequest.QueryMode.NORMAL, Options.fromUpdateOptions(options), true);
            try {
                ResultSet resultSet = this.rpc.executeQuery(builder.build(), this.session.getOptions());
                if (resultSet.getMetadata().hasTransaction()) {
                    this.onTransactionMetadata(resultSet.getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                }
                if (!resultSet.hasStats()) {
                    throw new IllegalArgumentException("DML response missing stats possibly due to non-DML statement as input");
                }
                return resultSet.getStats().getRowCountExact();
            }
            catch (Throwable t) {
                throw this.onError(SpannerExceptionFactory.asSpannerException(t), builder.getTransaction().hasBegin());
            }
        }

        @Override
        public ApiFuture<Long> executeUpdateAsync(Statement statement, Options.UpdateOption ... options) {
            ApiFuture<ResultSet> resultSet;
            this.beforeReadOrQuery();
            final ExecuteSqlRequest.Builder builder = this.getExecuteSqlRequestBuilder(statement, ExecuteSqlRequest.QueryMode.NORMAL, Options.fromUpdateOptions(options), true);
            try {
                this.increaseAsynOperations();
                resultSet = this.rpc.executeQueryAsync(builder.build(), this.session.getOptions());
            }
            catch (Throwable t) {
                this.decreaseAsyncOperations();
                throw t;
            }
            ApiFuture updateCount = ApiFutures.transform(resultSet, (ApiFunction)new ApiFunction<ResultSet, Long>(){

                public Long apply(ResultSet input) {
                    if (!input.hasStats()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "DML response missing stats possibly due to non-DML statement as input");
                    }
                    if (builder.getTransaction().hasBegin() && (!input.getMetadata().hasTransaction() || input.getMetadata().getTransaction().getId() == ByteString.EMPTY)) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "The statement did not return a transaction even though one was requested");
                    }
                    return input.getStats().getRowCountExact();
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCount = ApiFutures.catching((ApiFuture)updateCount, Throwable.class, (ApiFunction)new ApiFunction<Throwable, Long>(){

                public Long apply(Throwable input) {
                    SpannerException e = SpannerExceptionFactory.asSpannerException(input);
                    throw this.onError(e, builder.getTransaction().hasBegin());
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCount.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (((ResultSet)resultSet.get()).getMetadata().hasTransaction()) {
                            this.onTransactionMetadata(((ResultSet)resultSet.get()).getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.decreaseAsyncOperations();
                }
            }, MoreExecutors.directExecutor());
            return updateCount;
        }

        private SpannerException createAbortedExceptionForBatchDml(ExecuteBatchDmlResponse response) {
            return SpannerExceptionFactory.newSpannerException(ErrorCode.fromRpcStatus(response.getStatus()), response.getStatus().getMessage(), (Throwable)SpannerExceptionFactory.createAbortedExceptionWithRetryDelay(response.getStatus().getMessage(), null, 0L, (int)TimeUnit.MILLISECONDS.toNanos(10L)));
        }

        @Override
        public long[] batchUpdate(Iterable<Statement> statements, Options.UpdateOption ... options) {
            this.beforeReadOrQuery();
            ExecuteBatchDmlRequest.Builder builder = this.getExecuteBatchDmlRequestBuilder(statements, Options.fromUpdateOptions(options));
            try {
                ExecuteBatchDmlResponse response = this.rpc.executeBatchDml(builder.build(), this.session.getOptions());
                long[] results = new long[response.getResultSetsCount()];
                for (int i = 0; i < response.getResultSetsCount(); ++i) {
                    results[i] = response.getResultSets(i).getStats().getRowCountExact();
                    if (!response.getResultSets(i).getMetadata().hasTransaction()) continue;
                    this.onTransactionMetadata(response.getResultSets(i).getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                }
                if (response.getStatus().getCode() == 10) {
                    throw this.createAbortedExceptionForBatchDml(response);
                }
                if (response.getStatus().getCode() != 0) {
                    throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.fromRpcStatus(response.getStatus()), response.getStatus().getMessage(), results);
                }
                return results;
            }
            catch (Throwable e) {
                throw this.onError(SpannerExceptionFactory.asSpannerException(e), builder.getTransaction().hasBegin());
            }
        }

        @Override
        public ApiFuture<long[]> batchUpdateAsync(Iterable<Statement> statements, Options.UpdateOption ... options) {
            ApiFuture<ExecuteBatchDmlResponse> response;
            this.beforeReadOrQuery();
            final ExecuteBatchDmlRequest.Builder builder = this.getExecuteBatchDmlRequestBuilder(statements, Options.fromUpdateOptions(options));
            try {
                this.increaseAsynOperations();
                response = this.rpc.executeBatchDmlAsync(builder.build(), this.session.getOptions());
            }
            catch (Throwable t) {
                this.decreaseAsyncOperations();
                throw t;
            }
            ApiFuture updateCounts = ApiFutures.transform(response, (ApiFunction)new ApiFunction<ExecuteBatchDmlResponse, long[]>(){

                public long[] apply(ExecuteBatchDmlResponse batchDmlResponse) {
                    long[] results = new long[batchDmlResponse.getResultSetsCount()];
                    for (int i = 0; i < batchDmlResponse.getResultSetsCount(); ++i) {
                        results[i] = batchDmlResponse.getResultSets(i).getStats().getRowCountExact();
                        if (!batchDmlResponse.getResultSets(i).getMetadata().hasTransaction()) continue;
                        this.onTransactionMetadata(batchDmlResponse.getResultSets(i).getMetadata().getTransaction(), builder.getTransaction().hasBegin());
                    }
                    if (batchDmlResponse.getStatus().getCode() == 10) {
                        throw this.createAbortedExceptionForBatchDml(batchDmlResponse);
                    }
                    if (batchDmlResponse.getStatus().getCode() != 0) {
                        throw SpannerExceptionFactory.newSpannerBatchUpdateException(ErrorCode.fromRpcStatus(batchDmlResponse.getStatus()), batchDmlResponse.getStatus().getMessage(), results);
                    }
                    return results;
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCounts = ApiFutures.catching((ApiFuture)updateCounts, Throwable.class, (ApiFunction)new ApiFunction<Throwable, long[]>(){

                public long[] apply(Throwable input) {
                    SpannerException e = SpannerExceptionFactory.asSpannerException(input);
                    throw this.onError(e, builder.getTransaction().hasBegin());
                }
            }, (Executor)MoreExecutors.directExecutor());
            updateCounts.addListener(new Runnable(){

                @Override
                public void run() {
                    this.decreaseAsyncOperations();
                }
            }, MoreExecutors.directExecutor());
            return updateCounts;
        }

        private AbstractReadContext.ListenableAsyncResultSet wrap(AbstractReadContext.ListenableAsyncResultSet delegate) {
            return new TransactionContextAsyncResultSetImpl(delegate);
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readAsync(String table, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readAsync(table, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet readUsingIndexAsync(String table, String index, KeySet keys, Iterable<String> columns, Options.ReadOption ... options) {
            return this.wrap((AbstractReadContext.ListenableAsyncResultSet)super.readUsingIndexAsync(table, index, keys, (Iterable)columns, options));
        }

        @Override
        public AbstractReadContext.ListenableAsyncResultSet executeQueryAsync(Statement statement, Options.QueryOption ... options) {
            return this.wrap(super.executeQueryAsync(statement, options));
        }

        private final class CommitRunnable
        implements Runnable {
            private final SettableApiFuture<CommitResponse> res;
            private final ApiFuture<Void> prev;
            private final CommitRequest.Builder requestBuilder;

            CommitRunnable(SettableApiFuture<CommitResponse> res, ApiFuture<Void> prev, CommitRequest.Builder requestBuilder) {
                this.res = res;
                this.prev = prev;
                this.requestBuilder = requestBuilder;
            }

            @Override
            public void run() {
                try {
                    this.prev.get();
                    if (TransactionContextImpl.this.transactionId == null && TransactionContextImpl.this.transactionIdFuture == null) {
                        this.requestBuilder.setSingleUseTransaction(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance()));
                    } else {
                        this.requestBuilder.setTransactionId(TransactionContextImpl.this.transactionId == null ? (ByteString)TransactionContextImpl.this.transactionIdFuture.get() : TransactionContextImpl.this.transactionId);
                    }
                    if (TransactionContextImpl.this.options.hasPriority() || TransactionContextImpl.this.getTransactionTag() != null) {
                        RequestOptions.Builder requestOptionsBuilder = RequestOptions.newBuilder();
                        if (TransactionContextImpl.this.options.hasPriority()) {
                            requestOptionsBuilder.setPriority(TransactionContextImpl.this.options.priority());
                        }
                        if (TransactionContextImpl.this.getTransactionTag() != null) {
                            requestOptionsBuilder.setTransactionTag(TransactionContextImpl.this.getTransactionTag());
                        }
                        this.requestBuilder.setRequestOptions(requestOptionsBuilder.build());
                    }
                    CommitRequest commitRequest = this.requestBuilder.build();
                    TransactionContextImpl.this.span.addAnnotation("Starting Commit");
                    final Span opSpan = tracer.spanBuilderWithExplicitParent("CloudSpannerOperation.Commit", TransactionContextImpl.this.span).startSpan();
                    final ApiFuture<com.google.spanner.v1.CommitResponse> commitFuture = TransactionContextImpl.this.rpc.commitAsync(commitRequest, TransactionContextImpl.this.session.getOptions());
                    commitFuture.addListener(tracer.withSpan(opSpan, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                com.google.spanner.v1.CommitResponse proto = (com.google.spanner.v1.CommitResponse)commitFuture.get();
                                if (!proto.hasCommitTimestamp()) {
                                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing commitTimestamp:\n" + TransactionContextImpl.this.session.getName());
                                }
                                TransactionContextImpl.this.span.addAnnotation("Commit Done");
                                opSpan.end(TraceUtil.END_SPAN_OPTIONS);
                                CommitRunnable.this.res.set((Object)new CommitResponse(proto));
                            }
                            catch (Throwable e2) {
                                SpannerException e2 = e2 instanceof ExecutionException ? SpannerExceptionFactory.newSpannerException(e2.getCause() == null ? e2 : e2.getCause()) : (e2 instanceof InterruptedException ? SpannerExceptionFactory.propagateInterrupt((InterruptedException)e2) : SpannerExceptionFactory.newSpannerException(e2));
                                TransactionContextImpl.this.span.addAnnotation("Commit Failed", TraceUtil.getExceptionAnnotations((Throwable)((Object)e2)));
                                TraceUtil.endSpanWithFailure(opSpan, (Throwable)((Object)e2));
                                CommitRunnable.this.res.setException((Throwable)((Object)TransactionContextImpl.this.onError(e2, false)));
                            }
                        }
                    }), MoreExecutors.directExecutor());
                }
                catch (InterruptedException e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                }
                catch (ExecutionException e) {
                    this.res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
                }
            }
        }

        private class TransactionContextAsyncResultSetImpl
        extends ForwardingAsyncResultSet
        implements AbstractReadContext.ListenableAsyncResultSet {
            private TransactionContextAsyncResultSetImpl(AbstractReadContext.ListenableAsyncResultSet delegate) {
                super(delegate);
            }

            @Override
            public ApiFuture<Void> setCallback(Executor exec, AsyncResultSet.ReadyCallback cb) {
                Runnable listener = new Runnable(){

                    @Override
                    public void run() {
                        TransactionContextImpl.this.decreaseAsyncOperations();
                    }
                };
                try {
                    TransactionContextImpl.this.increaseAsynOperations();
                    this.addListener(listener);
                    return super.setCallback(exec, cb);
                }
                catch (Throwable t) {
                    this.removeListener(listener);
                    TransactionContextImpl.this.decreaseAsyncOperations();
                    throw t;
                }
            }

            @Override
            public void addListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.delegate).addListener(listener);
            }

            @Override
            public void removeListener(Runnable listener) {
                ((AbstractReadContext.ListenableAsyncResultSet)this.delegate).removeListener(listener);
            }
        }

        static class Builder
        extends AbstractReadContext.Builder<Builder, TransactionContextImpl> {
            private ByteString transactionId;
            private Options options;
            private boolean trackTransactionStarter;

            private Builder() {
            }

            Builder setTransactionId(ByteString transactionId) {
                this.transactionId = transactionId;
                return (Builder)this.self();
            }

            Builder setOptions(Options options) {
                this.options = (Options)Preconditions.checkNotNull((Object)options);
                return (Builder)this.self();
            }

            Builder setTrackTransactionStarter(boolean trackTransactionStarter) {
                this.trackTransactionStarter = trackTransactionStarter;
                return (Builder)this.self();
            }

            @Override
            TransactionContextImpl build() {
                Preconditions.checkState((this.options != null ? 1 : 0) != 0, (Object)"Options must be set");
                return new TransactionContextImpl(this);
            }
        }
    }
}

