/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.ReplaceableForwardingResultSet;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.concurrent.Callable;

@VisibleForTesting
class ChecksumResultSet
extends ReplaceableForwardingResultSet
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private volatile long numberOfNextCalls;
    private final StatementParser.ParsedStatement statement;
    private final AnalyzeMode analyzeMode;
    private final Options.QueryOption[] options;
    private final ChecksumCalculator checksumCalculator = new ChecksumCalculator();
    private final NextCallable nextCallable = new NextCallable();

    ChecksumResultSet(ReadWriteTransaction transaction, ResultSet delegate, StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        super(delegate);
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull((Object)statement.getStatement());
        Preconditions.checkNotNull((Object)statement.getStatement().getSql());
        this.transaction = transaction;
        this.statement = statement;
        this.analyzeMode = analyzeMode;
        this.options = options;
    }

    @Override
    public boolean next() {
        return this.transaction.runWithRetry(this.nextCallable);
    }

    @VisibleForTesting
    HashCode getChecksum() {
        return this.checksumCalculator.getChecksum();
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        long counter;
        ChecksumCalculator newChecksumCalculator = new ChecksumCalculator();
        ResultSet resultSet = null;
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            resultSet = DirectExecuteResultSet.ofResultSet(this.transaction.internalExecuteQuery(this.statement, this.analyzeMode, this.options));
            boolean next = true;
            for (counter = 0L; counter < this.numberOfNextCalls && next; ++counter) {
                this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_NEXT_ON_RESULT_SET, this.transaction);
                next = resultSet.next();
                if (!next) continue;
                newChecksumCalculator.calculateNextChecksum(resultSet.getCurrentRowAsStruct());
            }
        }
        catch (Throwable e) {
            if (resultSet != null) {
                resultSet.close();
            }
            if (e instanceof SpannerException && !(e instanceof AbortedException)) {
                throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, (SpannerException)((Object)e));
            }
            throw e;
        }
        HashCode newChecksum = newChecksumCalculator.getChecksum();
        HashCode currentChecksum = this.checksumCalculator.getChecksum();
        if (counter == this.numberOfNextCalls && Objects.equals(newChecksum, currentChecksum)) {
            if (this.isClosed()) {
                resultSet.close();
            } else {
                this.replaceDelegate(resultSet);
            }
        } else {
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
        }
    }

    private static enum StructFunnel implements Funnel<Struct>
    {
        INSTANCE;

        private static final String NULL = "null";

        public void funnel(Struct row, PrimitiveSink into) {
            block12: for (int i = 0; i < row.getColumnCount(); ++i) {
                if (row.isNull(i)) {
                    this.funnelValue(Type.Code.STRING, null, into);
                    continue;
                }
                Type.Code type = row.getColumnType(i).getCode();
                switch (type) {
                    case ARRAY: {
                        this.funnelArray(row.getColumnType(i).getArrayElementType().getCode(), row, i, into);
                        continue block12;
                    }
                    case BOOL: {
                        this.funnelValue(type, row.getBoolean(i), into);
                        continue block12;
                    }
                    case BYTES: {
                        this.funnelValue(type, row.getBytes(i), into);
                        continue block12;
                    }
                    case DATE: {
                        this.funnelValue(type, row.getDate(i), into);
                        continue block12;
                    }
                    case FLOAT64: {
                        this.funnelValue(type, row.getDouble(i), into);
                        continue block12;
                    }
                    case NUMERIC: {
                        this.funnelValue(type, row.getBigDecimal(i), into);
                        continue block12;
                    }
                    case INT64: {
                        this.funnelValue(type, row.getLong(i), into);
                        continue block12;
                    }
                    case STRING: {
                        this.funnelValue(type, row.getString(i), into);
                        continue block12;
                    }
                    case JSON: {
                        this.funnelValue(type, row.getJson(i), into);
                        continue block12;
                    }
                    case TIMESTAMP: {
                        this.funnelValue(type, row.getTimestamp(i), into);
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("unsupported row type");
                    }
                }
            }
        }

        private void funnelArray(Type.Code arrayElementType, Struct row, int columnIndex, PrimitiveSink into) {
            this.funnelValue(Type.Code.STRING, "BeginArray", into);
            switch (arrayElementType) {
                case BOOL: {
                    into.putInt(row.getBooleanList(columnIndex).size());
                    for (Boolean value : row.getBooleanList(columnIndex)) {
                        this.funnelValue(Type.Code.BOOL, value, into);
                    }
                    break;
                }
                case BYTES: {
                    into.putInt(row.getBytesList(columnIndex).size());
                    for (ByteArray value : row.getBytesList(columnIndex)) {
                        this.funnelValue(Type.Code.BYTES, value, into);
                    }
                    break;
                }
                case DATE: {
                    into.putInt(row.getDateList(columnIndex).size());
                    for (Date value : row.getDateList(columnIndex)) {
                        this.funnelValue(Type.Code.DATE, value, into);
                    }
                    break;
                }
                case FLOAT64: {
                    into.putInt(row.getDoubleList(columnIndex).size());
                    for (Double value : row.getDoubleList(columnIndex)) {
                        this.funnelValue(Type.Code.FLOAT64, value, into);
                    }
                    break;
                }
                case NUMERIC: {
                    into.putInt(row.getBigDecimalList(columnIndex).size());
                    for (BigDecimal value : row.getBigDecimalList(columnIndex)) {
                        this.funnelValue(Type.Code.NUMERIC, value, into);
                    }
                    break;
                }
                case INT64: {
                    into.putInt(row.getLongList(columnIndex).size());
                    for (Long value : row.getLongList(columnIndex)) {
                        this.funnelValue(Type.Code.INT64, value, into);
                    }
                    break;
                }
                case STRING: {
                    into.putInt(row.getStringList(columnIndex).size());
                    for (String value : row.getStringList(columnIndex)) {
                        this.funnelValue(Type.Code.STRING, value, into);
                    }
                    break;
                }
                case JSON: {
                    into.putInt(row.getJsonList(columnIndex).size());
                    for (String value : row.getJsonList(columnIndex)) {
                        this.funnelValue(Type.Code.JSON, value, into);
                    }
                    break;
                }
                case TIMESTAMP: {
                    into.putInt(row.getTimestampList(columnIndex).size());
                    for (Timestamp value : row.getTimestampList(columnIndex)) {
                        this.funnelValue(Type.Code.TIMESTAMP, value, into);
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported array element type");
                }
            }
            this.funnelValue(Type.Code.STRING, "EndArray", into);
        }

        private <T> void funnelValue(Type.Code type, T value, PrimitiveSink into) {
            into.putUnencodedChars((CharSequence)type.name());
            if (value == null) {
                if (type == Type.Code.BYTES || type == Type.Code.STRING) {
                    into.putInt(-1);
                }
                into.putUnencodedChars((CharSequence)NULL);
            } else {
                switch (type) {
                    case BOOL: {
                        into.putBoolean(((Boolean)value).booleanValue());
                        break;
                    }
                    case BYTES: {
                        ByteArray byteArray = (ByteArray)value;
                        into.putInt(byteArray.length());
                        into.putBytes(byteArray.toByteArray());
                        break;
                    }
                    case DATE: {
                        Date date = (Date)value;
                        into.putInt(date.getYear()).putInt(date.getMonth()).putInt(date.getDayOfMonth());
                        break;
                    }
                    case FLOAT64: {
                        into.putDouble(((Double)value).doubleValue());
                        break;
                    }
                    case NUMERIC: {
                        String stringRepresentation = value.toString();
                        into.putInt(stringRepresentation.length());
                        into.putUnencodedChars((CharSequence)stringRepresentation);
                        break;
                    }
                    case INT64: {
                        into.putLong(((Long)value).longValue());
                        break;
                    }
                    case STRING: 
                    case JSON: {
                        String stringValue = (String)value;
                        into.putInt(stringValue.length());
                        into.putUnencodedChars((CharSequence)stringValue);
                        break;
                    }
                    case TIMESTAMP: {
                        Timestamp timestamp = (Timestamp)value;
                        into.putLong(timestamp.getSeconds()).putInt(timestamp.getNanos());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid type for single value");
                    }
                }
            }
        }
    }

    private static final class ChecksumCalculator {
        private static final HashFunction SHA256_FUNCTION = Hashing.sha256();
        private HashCode currentChecksum;

        private ChecksumCalculator() {
        }

        private void calculateNextChecksum(Struct row) {
            Hasher hasher = SHA256_FUNCTION.newHasher();
            if (this.currentChecksum != null) {
                hasher.putBytes(this.currentChecksum.asBytes());
            }
            hasher.putObject((Object)row, (Funnel)StructFunnel.INSTANCE);
            this.currentChecksum = hasher.hash();
        }

        private HashCode getChecksum() {
            return this.currentChecksum;
        }
    }

    private final class NextCallable
    implements Callable<Boolean> {
        private NextCallable() {
        }

        @Override
        public Boolean call() {
            ChecksumResultSet.this.transaction.getStatementExecutor().invokeInterceptors(ChecksumResultSet.this.statement, StatementExecutionStep.CALL_NEXT_ON_RESULT_SET, ChecksumResultSet.this.transaction);
            boolean res = ChecksumResultSet.super.next();
            if (res) {
                ChecksumResultSet.this.checksumCalculator.calculateNextChecksum(ChecksumResultSet.this.getCurrentRowAsStruct());
            }
            ChecksumResultSet.this.numberOfNextCalls++;
            return res;
        }
    }
}

