/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AsyncResultSet;
import com.google.cloud.spanner.CommitResponse;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerApiFutures;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.AsyncStatementResult;
import com.google.cloud.spanner.connection.AsyncStatementResultImpl;
import com.google.cloud.spanner.connection.AutocommitDmlMode;
import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.connection.ConnectionPreconditions;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutorImpl;
import com.google.cloud.spanner.connection.DdlBatch;
import com.google.cloud.spanner.connection.DdlClient;
import com.google.cloud.spanner.connection.DmlBatch;
import com.google.cloud.spanner.connection.EmulatorUtil;
import com.google.cloud.spanner.connection.ReadOnlyTransaction;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.SingleUseTransaction;
import com.google.cloud.spanner.connection.SpannerPool;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.cloud.spanner.connection.StatementResultImpl;
import com.google.cloud.spanner.connection.TransactionMode;
import com.google.cloud.spanner.connection.TransactionRetryListener;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.spanner.v1.ExecuteSqlRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.threeten.bp.Instant;

class ConnectionImpl
implements Connection {
    private static final String CLOSED_ERROR_MSG = "This connection is closed";
    private static final String ONLY_ALLOWED_IN_AUTOCOMMIT = "This method may only be called while in autocommit mode";
    private static final String NOT_ALLOWED_IN_AUTOCOMMIT = "This method may not be called while in autocommit mode";
    private volatile LeakedConnectionException leakedException = new LeakedConnectionException();
    private final SpannerPool spannerPool;
    private final StatementParser parser = StatementParser.INSTANCE;
    private final ConnectionStatementExecutor connectionStatementExecutor = new ConnectionStatementExecutorImpl(this);
    private final StatementExecutor statementExecutor;
    private final ConnectionOptions options;
    private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();
    private boolean closed = false;
    private final Spanner spanner;
    private DdlClient ddlClient;
    private DatabaseClient dbClient;
    private boolean autocommit;
    private boolean readOnly;
    private boolean returnCommitStats;
    private UnitOfWork currentUnitOfWork = null;
    private boolean inTransaction = false;
    private boolean transactionBeginMarked = false;
    private BatchMode batchMode;
    private UnitOfWorkType unitOfWorkType;
    private final Stack<UnitOfWork> transactionStack = new Stack();
    private boolean retryAbortsInternally;
    private final List<TransactionRetryListener> transactionRetryListeners = new ArrayList<TransactionRetryListener>();
    private AutocommitDmlMode autocommitDmlMode = AutocommitDmlMode.TRANSACTIONAL;
    private TimestampBound readOnlyStaleness = TimestampBound.strong();
    private ExecuteSqlRequest.QueryOptions queryOptions = ExecuteSqlRequest.QueryOptions.getDefaultInstance();
    private String transactionTag;
    private String statementTag;
    private final Commit commit = new Commit();
    private final Rollback rollback = new Rollback();

    ConnectionImpl(ConnectionOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.statementExecutor = new StatementExecutor(options.getStatementExecutionInterceptors());
        this.spannerPool = SpannerPool.INSTANCE;
        this.options = options;
        this.spanner = this.spannerPool.getSpanner(options, this);
        if (options.isAutoConfigEmulator()) {
            EmulatorUtil.maybeCreateInstanceAndDatabase(this.spanner, options.getDatabaseId());
        }
        this.dbClient = this.spanner.getDatabaseClient(options.getDatabaseId());
        this.retryAbortsInternally = options.isRetryAbortsInternally();
        this.readOnly = options.isReadOnly();
        this.autocommit = options.isAutocommit();
        this.queryOptions = this.queryOptions.toBuilder().mergeFrom(options.getQueryOptions()).build();
        this.returnCommitStats = options.isReturnCommitStats();
        this.ddlClient = this.createDdlClient();
        this.setDefaultTransactionOptions();
    }

    @VisibleForTesting
    ConnectionImpl(ConnectionOptions options, SpannerPool spannerPool, DdlClient ddlClient, DatabaseClient dbClient) {
        Preconditions.checkNotNull((Object)options);
        Preconditions.checkNotNull((Object)spannerPool);
        Preconditions.checkNotNull((Object)ddlClient);
        Preconditions.checkNotNull((Object)dbClient);
        this.statementExecutor = new StatementExecutor(Collections.emptyList());
        this.spannerPool = spannerPool;
        this.options = options;
        this.spanner = spannerPool.getSpanner(options, this);
        this.ddlClient = ddlClient;
        this.dbClient = dbClient;
        this.setReadOnly(options.isReadOnly());
        this.setAutocommit(options.isAutocommit());
        this.setReturnCommitStats(options.isReturnCommitStats());
        this.setDefaultTransactionOptions();
    }

    private DdlClient createDdlClient() {
        return DdlClient.newBuilder().setDatabaseAdminClient(this.spanner.getDatabaseAdminClient()).setInstanceId(this.options.getInstanceId()).setDatabaseName(this.options.getDatabaseName()).build();
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get(10L, TimeUnit.SECONDS);
        }
        catch (SpannerException | InterruptedException | ExecutionException | TimeoutException object) {
        }
        finally {
            this.statementExecutor.shutdownNow();
        }
    }

    @Override
    public ApiFuture<Void> closeAsync() {
        if (!this.isClosed()) {
            ArrayList<ApiFuture<Void>> futures = new ArrayList<ApiFuture<Void>>();
            if (this.isTransactionStarted()) {
                futures.add(this.rollbackAsync());
            }
            this.closed = true;
            futures.add(this.statementExecutor.submit(() -> null));
            this.statementExecutor.shutdown();
            this.leakedException = null;
            this.spannerPool.removeConnection(this.options, this);
            return ApiFutures.transform((ApiFuture)ApiFutures.allAsList(futures), ignored -> null, (Executor)MoreExecutors.directExecutor());
        }
        return ApiFutures.immediateFuture(null);
    }

    UnitOfWorkType getUnitOfWorkType() {
        return this.unitOfWorkType;
    }

    BatchMode getBatchMode() {
        return this.batchMode;
    }

    boolean isInBatch() {
        return this.batchMode != BatchMode.NONE;
    }

    LeakedConnectionException getLeakedException() {
        return this.leakedException;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setAutocommit(boolean autocommit) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set autocommit while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set autocommit while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set autocommit when a transaction has begun");
        this.autocommit = autocommit;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
        if (!(autocommit || this.readOnlyStaleness.getMode() != TimestampBound.Mode.MAX_STALENESS && this.readOnlyStaleness.getMode() != TimestampBound.Mode.MIN_READ_TIMESTAMP)) {
            this.readOnlyStaleness = TimestampBound.strong();
        }
    }

    @Override
    public boolean isAutocommit() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsAutocommit();
    }

    private boolean internalIsAutocommit() {
        return this.autocommit;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot set read-only while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot set read-only when a transaction has begun");
        this.readOnly = readOnly;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
    }

    @Override
    public boolean isReadOnly() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.readOnly;
    }

    private void clearLastTransactionAndSetDefaultTransactionOptions() {
        this.setDefaultTransactionOptions();
        this.currentUnitOfWork = null;
    }

    @Override
    public void setAutocommitDmlMode(AutocommitDmlMode mode) {
        Preconditions.checkNotNull((Object)((Object)mode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set autocommit DML mode while in a batch");
        ConnectionPreconditions.checkState(!this.isInTransaction() && this.isAutocommit(), "Cannot set autocommit DML mode while not in autocommit mode or while a transaction is active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot set autocommit DML mode for a read-only connection");
        this.autocommitDmlMode = mode;
    }

    @Override
    public AutocommitDmlMode getAutocommitDmlMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get autocommit DML mode while in a batch");
        return this.autocommitDmlMode;
    }

    @Override
    public void setReadOnlyStaleness(TimestampBound staleness) {
        Preconditions.checkNotNull((Object)staleness);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set read-only while in a batch");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot set read-only staleness when a transaction has been started");
        if (staleness.getMode() == TimestampBound.Mode.MAX_STALENESS || staleness.getMode() == TimestampBound.Mode.MIN_READ_TIMESTAMP) {
            ConnectionPreconditions.checkState(this.isAutocommit() && !this.inTransaction, "MAX_STALENESS and MIN_READ_TIMESTAMP are only allowed in autocommit mode");
        }
        this.readOnlyStaleness = staleness;
    }

    @Override
    public TimestampBound getReadOnlyStaleness() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot get read-only while in a batch");
        return this.readOnlyStaleness;
    }

    @Override
    public void setOptimizerVersion(String optimizerVersion) {
        Preconditions.checkNotNull((Object)optimizerVersion);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.queryOptions = this.queryOptions.toBuilder().setOptimizerVersion(optimizerVersion).build();
    }

    @Override
    public String getOptimizerVersion() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.queryOptions.getOptimizerVersion();
    }

    @Override
    public void setOptimizerStatisticsPackage(String optimizerStatisticsPackage) {
        Preconditions.checkNotNull((Object)optimizerStatisticsPackage);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.queryOptions = this.queryOptions.toBuilder().setOptimizerStatisticsPackage(optimizerStatisticsPackage).build();
    }

    @Override
    public String getOptimizerStatisticsPackage() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.queryOptions.getOptimizerStatisticsPackage();
    }

    @Override
    public void setStatementTimeout(long timeout, TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Zero or negative timeout values are not allowed");
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.setTimeoutValue(timeout, unit);
    }

    @Override
    public void clearStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.statementTimeout.clearTimeoutValue();
    }

    @Override
    public long getStatementTimeout(TimeUnit unit) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        Preconditions.checkArgument((boolean)StatementExecutor.StatementTimeout.isValidTimeoutUnit(unit), (Object)"Time unit must be one of NANOSECONDS, MICROSECONDS, MILLISECONDS or SECONDS");
        return this.statementTimeout.getTimeoutValue(unit);
    }

    @Override
    public boolean hasStatementTimeout() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.statementTimeout.hasTimeout();
    }

    @Override
    public void cancel() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        if (this.currentUnitOfWork != null) {
            this.currentUnitOfWork.cancel();
        }
    }

    @Override
    public TransactionMode getTransactionMode() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        return this.unitOfWorkType.getTransactionMode();
    }

    @Override
    public void setTransactionMode(TransactionMode transactionMode) {
        Preconditions.checkNotNull((Object)((Object)transactionMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction mode while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction mode cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(!this.isReadOnly() || transactionMode == TransactionMode.READ_ONLY_TRANSACTION, "The transaction mode can only be READ_ONLY when the connection is in read_only mode");
        this.transactionBeginMarked = true;
        this.unitOfWorkType = UnitOfWorkType.of(transactionMode);
    }

    @Override
    public String getTransactionTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isDdlBatchActive(), "This connection is in a DDL batch");
        return this.transactionTag;
    }

    @Override
    public void setTransactionTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot set transaction tag while in a batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "The transaction tag cannot be set after the transaction has started");
        ConnectionPreconditions.checkState(this.getTransactionMode() == TransactionMode.READ_WRITE_TRANSACTION, "Transaction tag can only be set for a read/write transaction");
        this.transactionBeginMarked = true;
        this.transactionTag = tag;
    }

    @Override
    public String getStatementTag() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        return this.statementTag;
    }

    @Override
    public void setStatementTag(String tag) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Statement tags are not allowed inside a batch");
        this.statementTag = tag;
    }

    private void checkSetRetryAbortsInternallyAvailable() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(this.getTransactionMode() == TransactionMode.READ_WRITE_TRANSACTION, "RetryAbortsInternally is only available for read-write transactions");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "RetryAbortsInternally cannot be set after the transaction has started");
    }

    @Override
    public boolean isRetryAbortsInternally() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.retryAbortsInternally;
    }

    @Override
    public void setRetryAbortsInternally(boolean retryAbortsInternally) {
        this.checkSetRetryAbortsInternallyAvailable();
        this.retryAbortsInternally = retryAbortsInternally;
    }

    @Override
    public void addTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.transactionRetryListeners.add(listener);
    }

    @Override
    public boolean removeTransactionRetryListener(TransactionRetryListener listener) {
        Preconditions.checkNotNull((Object)listener);
        return this.transactionRetryListeners.remove(listener);
    }

    @Override
    public Iterator<TransactionRetryListener> getTransactionRetryListeners() {
        return Collections.unmodifiableList(this.transactionRetryListeners).iterator();
    }

    @Override
    public boolean isInTransaction() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsInTransaction();
    }

    private boolean internalIsInTransaction() {
        return !this.isDdlBatchActive() && (!this.internalIsAutocommit() || this.inTransaction);
    }

    @Override
    public boolean isTransactionStarted() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.internalIsTransactionStarted();
    }

    private boolean internalIsTransactionStarted() {
        if (this.internalIsAutocommit() && !this.inTransaction) {
            return false;
        }
        return this.internalIsInTransaction() && this.currentUnitOfWork != null && this.currentUnitOfWork.getState() == UnitOfWork.UnitOfWorkState.STARTED;
    }

    @Override
    public Timestamp getReadTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getReadTimestamp();
    }

    Timestamp getReadTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getReadTimestampOrNull();
    }

    @Override
    public Timestamp getCommitTimestamp() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitTimestamp();
    }

    Timestamp getCommitTimestampOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitTimestampOrNull();
    }

    @Override
    public CommitResponse getCommitResponse() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.currentUnitOfWork != null, "There is no transaction on this connection");
        return this.currentUnitOfWork.getCommitResponse();
    }

    CommitResponse getCommitResponseOrNull() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.currentUnitOfWork == null ? null : this.currentUnitOfWork.getCommitResponseOrNull();
    }

    @Override
    public void setReturnCommitStats(boolean returnCommitStats) {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        this.returnCommitStats = returnCommitStats;
    }

    @Override
    public boolean isReturnCommitStats() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.returnCommitStats;
    }

    private void setDefaultTransactionOptions() {
        if (this.transactionStack.isEmpty()) {
            this.unitOfWorkType = this.isReadOnly() ? UnitOfWorkType.READ_ONLY_TRANSACTION : UnitOfWorkType.READ_WRITE_TRANSACTION;
            this.batchMode = BatchMode.NONE;
            this.transactionTag = null;
        } else {
            this.popUnitOfWorkFromTransactionStack();
        }
    }

    @Override
    public void beginTransaction() {
        SpannerApiFutures.get(this.beginTransactionAsync());
    }

    @Override
    public ApiFuture<Void> beginTransactionAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch and cannot begin a transaction");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Beginning a new transaction is not allowed when a transaction is already running");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "A transaction has already begun");
        this.transactionBeginMarked = true;
        this.clearLastTransactionAndSetDefaultTransactionOptions();
        if (this.isAutocommit()) {
            this.inTransaction = true;
        }
        return ApiFutures.immediateFuture(null);
    }

    @Override
    public void commit() {
        SpannerApiFutures.get(this.commitAsync());
    }

    @Override
    public ApiFuture<Void> commitAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.endCurrentTransactionAsync(this.commit);
    }

    @Override
    public void rollback() {
        SpannerApiFutures.get(this.rollbackAsync());
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.endCurrentTransactionAsync(this.rollback);
    }

    private ApiFuture<Void> endCurrentTransactionAsync(EndTransactionMethod endTransactionMethod) {
        ApiFuture res;
        ConnectionPreconditions.checkState(!this.isBatchActive(), "This connection has an active batch");
        ConnectionPreconditions.checkState(this.isInTransaction(), "This connection has no transaction");
        ConnectionPreconditions.checkState(this.statementTag == null, "Statement tags are not supported for COMMIT or ROLLBACK");
        try {
            if (this.isTransactionStarted()) {
                res = endTransactionMethod.endAsync(this.getCurrentUnitOfWorkOrStartNewUnitOfWork());
            } else {
                this.currentUnitOfWork = null;
                res = ApiFutures.immediateFuture(null);
            }
        }
        finally {
            this.transactionBeginMarked = false;
            if (this.isAutocommit()) {
                this.inTransaction = false;
            }
            this.setDefaultTransactionOptions();
        }
        return res;
    }

    @Override
    public StatementResult execute(Statement statement) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(statement, this.queryOptions);
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement.getSqlWithoutComments());
            }
            case QUERY: {
                return StatementResultImpl.of(this.internalExecuteQuery(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                return StatementResultImpl.of(SpannerApiFutures.get(this.internalExecuteUpdateAsync(parsedStatement, new Options.UpdateOption[0])));
            }
            case DDL: {
                SpannerApiFutures.get(this.executeDdlAsync(parsedStatement));
                return StatementResultImpl.noResult();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public AsyncStatementResult executeAsync(Statement statement) {
        Preconditions.checkNotNull((Object)statement);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(statement, this.queryOptions);
        switch (parsedStatement.getType()) {
            case CLIENT_SIDE: {
                return AsyncStatementResultImpl.of(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement.getSqlWithoutComments()), this.spanner.getAsyncExecutorProvider());
            }
            case QUERY: {
                return AsyncStatementResultImpl.of(this.internalExecuteQueryAsync(parsedStatement, AnalyzeMode.NONE, new Options.QueryOption[0]));
            }
            case UPDATE: {
                return AsyncStatementResultImpl.of(this.internalExecuteUpdateAsync(parsedStatement, new Options.UpdateOption[0]));
            }
            case DDL: {
                return AsyncStatementResultImpl.noResult(this.executeDdlAsync(parsedStatement));
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ResultSet executeQuery(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQuery(query, AnalyzeMode.NONE, options);
    }

    @Override
    public AsyncResultSet executeQueryAsync(Statement query, Options.QueryOption ... options) {
        return this.parseAndExecuteQueryAsync(query, AnalyzeMode.NONE, options);
    }

    @Override
    public ResultSet analyzeQuery(Statement query, ReadContext.QueryAnalyzeMode queryMode) {
        Preconditions.checkNotNull((Object)((Object)queryMode));
        return this.parseAndExecuteQuery(query, AnalyzeMode.of(queryMode), new Options.QueryOption[0]);
    }

    private ResultSet parseAndExecuteQuery(Statement query, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)((Object)analyzeMode));
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(query, this.queryOptions);
        if (parsedStatement.isQuery()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement.getSqlWithoutComments()).getResultSet();
                }
                case QUERY: {
                    return this.internalExecuteQuery(parsedStatement, analyzeMode, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query: " + parsedStatement.getSqlWithoutComments());
    }

    private AsyncResultSet parseAndExecuteQueryAsync(Statement query, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)query);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(query, this.queryOptions);
        if (parsedStatement.isQuery()) {
            switch (parsedStatement.getType()) {
                case CLIENT_SIDE: {
                    return ResultSets.toAsyncResultSet(parsedStatement.getClientSideStatement().execute(this.connectionStatementExecutor, parsedStatement.getSqlWithoutComments()).getResultSet(), this.spanner.getAsyncExecutorProvider(), options);
                }
                case QUERY: {
                    return this.internalExecuteQueryAsync(parsedStatement, analyzeMode, options);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not a query: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public long executeUpdate(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    return SpannerApiFutures.get(this.internalExecuteUpdateAsync(parsedStatement, new Options.UpdateOption[0]));
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public ApiFuture<Long> executeUpdateAsync(Statement update) {
        Preconditions.checkNotNull((Object)update);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        StatementParser.ParsedStatement parsedStatement = this.parser.parse(update);
        if (parsedStatement.isUpdate()) {
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    return this.internalExecuteUpdateAsync(parsedStatement, new Options.UpdateOption[0]);
                }
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Statement is not an update statement: " + parsedStatement.getSqlWithoutComments());
    }

    @Override
    public long[] executeBatchUpdate(Iterable<Statement> updates) {
        Preconditions.checkNotNull(updates);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        LinkedList<StatementParser.ParsedStatement> parsedStatements = new LinkedList<StatementParser.ParsedStatement>();
        block3: for (Statement update : updates) {
            StatementParser.ParsedStatement parsedStatement = this.parser.parse(update);
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    parsedStatements.add(parsedStatement);
                    continue block3;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The batch update list contains a statement that is not an update statement: " + parsedStatement.getSqlWithoutComments());
        }
        return SpannerApiFutures.get(this.internalExecuteBatchUpdateAsync(parsedStatements, new Options.UpdateOption[0]));
    }

    @Override
    public ApiFuture<long[]> executeBatchUpdateAsync(Iterable<Statement> updates) {
        Preconditions.checkNotNull(updates);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        LinkedList<StatementParser.ParsedStatement> parsedStatements = new LinkedList<StatementParser.ParsedStatement>();
        block3: for (Statement update : updates) {
            StatementParser.ParsedStatement parsedStatement = this.parser.parse(update);
            switch (parsedStatement.getType()) {
                case UPDATE: {
                    parsedStatements.add(parsedStatement);
                    continue block3;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "The batch update list contains a statement that is not an update statement: " + parsedStatement.getSqlWithoutComments());
        }
        return this.internalExecuteBatchUpdateAsync(parsedStatements, new Options.UpdateOption[0]);
    }

    private Options.QueryOption[] mergeQueryStatementTag(Options.QueryOption ... options) {
        if (this.statementTag != null) {
            if (options == null || options.length == 0) {
                options = new Options.QueryOption[]{Options.tag(this.statementTag)};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.tag(this.statementTag);
            }
            this.statementTag = null;
        }
        return options;
    }

    private Options.UpdateOption[] mergeUpdateStatementTag(Options.UpdateOption ... options) {
        if (this.statementTag != null) {
            if (options == null || options.length == 0) {
                options = new Options.UpdateOption[]{Options.tag(this.statementTag)};
            } else {
                options = Arrays.copyOf(options, options.length + 1);
                options[options.length - 1] = Options.tag(this.statementTag);
            }
            this.statementTag = null;
        }
        return options;
    }

    private ResultSet internalExecuteQuery(StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == StatementParser.StatementType.QUERY ? 1 : 0) != 0, (Object)"Statement must be a query");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return SpannerApiFutures.get(transaction.executeQueryAsync(statement, analyzeMode, this.mergeQueryStatementTag(options)));
    }

    private AsyncResultSet internalExecuteQueryAsync(StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkArgument((statement.getType() == StatementParser.StatementType.QUERY ? 1 : 0) != 0, (Object)"Statement must be a query");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return ResultSets.toAsyncResultSet(transaction.executeQueryAsync(statement, analyzeMode, this.mergeQueryStatementTag(options)), this.spanner.getAsyncExecutorProvider(), options);
    }

    private ApiFuture<Long> internalExecuteUpdateAsync(StatementParser.ParsedStatement update, Options.UpdateOption ... options) {
        Preconditions.checkArgument((update.getType() == StatementParser.StatementType.UPDATE ? 1 : 0) != 0, (Object)"Statement must be an update");
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return transaction.executeUpdateAsync(update, this.mergeUpdateStatementTag(options));
    }

    private ApiFuture<long[]> internalExecuteBatchUpdateAsync(List<StatementParser.ParsedStatement> updates, Options.UpdateOption ... options) {
        UnitOfWork transaction = this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        return transaction.executeBatchUpdateAsync(updates, this.mergeUpdateStatementTag(options));
    }

    @VisibleForTesting
    UnitOfWork getCurrentUnitOfWorkOrStartNewUnitOfWork() {
        if (this.currentUnitOfWork == null || !this.currentUnitOfWork.isActive()) {
            this.currentUnitOfWork = this.createNewUnitOfWork();
        }
        return this.currentUnitOfWork;
    }

    @VisibleForTesting
    UnitOfWork createNewUnitOfWork() {
        if (this.isAutocommit() && !this.isInTransaction() && !this.isInBatch()) {
            return ((SingleUseTransaction.Builder)((SingleUseTransaction.Builder)SingleUseTransaction.newBuilder().setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setReadOnly(this.isReadOnly()).setReadOnlyStaleness(this.readOnlyStaleness).setAutocommitDmlMode(this.autocommitDmlMode).setReturnCommitStats(this.returnCommitStats).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).build();
        }
        switch (this.getUnitOfWorkType()) {
            case READ_ONLY_TRANSACTION: {
                return ((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)((ReadOnlyTransaction.Builder)ReadOnlyTransaction.newBuilder().setDatabaseClient(this.dbClient).setReadOnlyStaleness(this.readOnlyStaleness).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).build();
            }
            case READ_WRITE_TRANSACTION: {
                return ((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)((ReadWriteTransaction.Builder)ReadWriteTransaction.newBuilder().setDatabaseClient(this.dbClient).setRetryAbortsInternally(this.retryAbortsInternally).setReturnCommitStats(this.returnCommitStats).setTransactionRetryListeners(this.transactionRetryListeners).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setTransactionTag(this.transactionTag)).build();
            }
            case DML_BATCH: {
                this.pushCurrentUnitOfWorkToTransactionStack();
                return ((DmlBatch.Builder)((DmlBatch.Builder)DmlBatch.newBuilder().setTransaction(this.currentUnitOfWork).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).setStatementTag(this.statementTag).build();
            }
            case DDL_BATCH: {
                return ((DdlBatch.Builder)((DdlBatch.Builder)DdlBatch.newBuilder().setDdlClient(this.ddlClient).setDatabaseClient(this.dbClient).setStatementTimeout(this.statementTimeout)).withStatementExecutor(this.statementExecutor)).build();
            }
        }
        throw SpannerExceptionFactory.newSpannerException(ErrorCode.FAILED_PRECONDITION, "This connection does not have an active transaction and the state of this connection does not allow any new transactions to be started");
    }

    private void pushCurrentUnitOfWorkToTransactionStack() {
        Preconditions.checkState((this.currentUnitOfWork != null ? 1 : 0) != 0, (Object)"There is no current transaction");
        this.transactionStack.push(this.currentUnitOfWork);
    }

    private void popUnitOfWorkFromTransactionStack() {
        Preconditions.checkState((!this.transactionStack.isEmpty() ? 1 : 0) != 0, (Object)"There is no unit of work in the transaction stack");
        this.currentUnitOfWork = this.transactionStack.pop();
    }

    private ApiFuture<Void> executeDdlAsync(StatementParser.ParsedStatement ddl) {
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork().executeDdlAsync(ddl);
    }

    @Override
    public void write(Mutation mutation) {
        SpannerApiFutures.get(this.writeAsync(Collections.singleton(Preconditions.checkNotNull((Object)mutation))));
    }

    @Override
    public ApiFuture<Void> writeAsync(Mutation mutation) {
        return this.writeAsync(Collections.singleton(Preconditions.checkNotNull((Object)mutation)));
    }

    @Override
    public void write(Iterable<Mutation> mutations) {
        SpannerApiFutures.get(this.writeAsync((Iterable)Preconditions.checkNotNull(mutations)));
    }

    @Override
    public ApiFuture<Void> writeAsync(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isAutocommit(), ONLY_ALLOWED_IN_AUTOCOMMIT);
        return this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(mutations);
    }

    @Override
    public void bufferedWrite(Mutation mutation) {
        this.bufferedWrite((Iterable)Preconditions.checkNotNull(Collections.singleton(mutation)));
    }

    @Override
    public void bufferedWrite(Iterable<Mutation> mutations) {
        Preconditions.checkNotNull(mutations);
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isAutocommit(), NOT_ALLOWED_IN_AUTOCOMMIT);
        SpannerApiFutures.get(this.getCurrentUnitOfWorkOrStartNewUnitOfWork().writeAsync(mutations));
    }

    @Override
    public void startBatchDdl() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DDL batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DDL batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isTransactionStarted(), "Cannot start a DDL batch while a transaction is active");
        ConnectionPreconditions.checkState(!this.isAutocommit() || !this.isInTransaction(), "Cannot start a DDL batch while in a temporary transaction");
        ConnectionPreconditions.checkState(!this.transactionBeginMarked, "Cannot start a DDL batch when a transaction has begun");
        this.batchMode = BatchMode.DDL;
        this.unitOfWorkType = UnitOfWorkType.DDL_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork();
    }

    @Override
    public void startBatchDml() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(!this.isBatchActive(), "Cannot start a DML batch when a batch is already active");
        ConnectionPreconditions.checkState(!this.isReadOnly(), "Cannot start a DML batch when the connection is in read-only mode");
        ConnectionPreconditions.checkState(!this.isInTransaction() || this.getTransactionMode() != TransactionMode.READ_ONLY_TRANSACTION, "Cannot start a DML batch when a read-only transaction is in progress");
        this.getCurrentUnitOfWorkOrStartNewUnitOfWork();
        this.batchMode = BatchMode.DML;
        this.unitOfWorkType = UnitOfWorkType.DML_BATCH;
        this.currentUnitOfWork = this.createNewUnitOfWork();
    }

    @Override
    public long[] runBatch() {
        return SpannerApiFutures.get(this.runBatchAsync());
    }

    @Override
    public ApiFuture<long[]> runBatchAsync() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                ApiFuture<long[]> apiFuture = this.currentUnitOfWork.runBatchAsync();
                return apiFuture;
            }
            ApiFuture apiFuture = ApiFutures.immediateFuture((Object)new long[0]);
            return apiFuture;
        }
        finally {
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions();
        }
    }

    @Override
    public void abortBatch() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        ConnectionPreconditions.checkState(this.isBatchActive(), "This connection has no active batch");
        try {
            if (this.currentUnitOfWork != null) {
                this.currentUnitOfWork.abortBatch();
            }
        }
        finally {
            this.batchMode = BatchMode.NONE;
            this.setDefaultTransactionOptions();
        }
    }

    private boolean isBatchActive() {
        return this.isDdlBatchActive() || this.isDmlBatchActive();
    }

    @Override
    public boolean isDdlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DDL;
    }

    @Override
    public boolean isDmlBatchActive() {
        ConnectionPreconditions.checkState(!this.isClosed(), CLOSED_ERROR_MSG);
        return this.batchMode == BatchMode.DML;
    }

    private static final class Rollback
    implements EndTransactionMethod {
        private Rollback() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork t) {
            return t.rollbackAsync();
        }
    }

    private static final class Commit
    implements EndTransactionMethod {
        private Commit() {
        }

        @Override
        public ApiFuture<Void> endAsync(UnitOfWork t) {
            return t.commitAsync();
        }
    }

    private static interface EndTransactionMethod {
        public ApiFuture<Void> endAsync(UnitOfWork var1);
    }

    static enum UnitOfWorkType {
        READ_ONLY_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_ONLY_TRANSACTION;
            }
        }
        ,
        READ_WRITE_TRANSACTION{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DML_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return TransactionMode.READ_WRITE_TRANSACTION;
            }
        }
        ,
        DDL_BATCH{

            @Override
            TransactionMode getTransactionMode() {
                return null;
            }
        };


        abstract TransactionMode getTransactionMode();

        static UnitOfWorkType of(TransactionMode transactionMode) {
            switch (transactionMode) {
                case READ_ONLY_TRANSACTION: {
                    return READ_ONLY_TRANSACTION;
                }
                case READ_WRITE_TRANSACTION: {
                    return READ_WRITE_TRANSACTION;
                }
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Unknown transaction mode: " + (Object)((Object)transactionMode));
        }
    }

    static final class InternalMetadataQuery
    implements Options.QueryOption {
        static final InternalMetadataQuery INSTANCE = new InternalMetadataQuery();

        private InternalMetadataQuery() {
        }
    }

    static enum BatchMode {
        NONE,
        DDL,
        DML;

    }

    static final class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("connection-rollback-executor");
            t.setDaemon(true);
            return t;
        }
    }

    static class LeakedConnectionException
    extends RuntimeException {
        private static final long serialVersionUID = 7119433786832158700L;

        private LeakedConnectionException() {
            super("Connection was opened at " + Instant.now());
        }
    }
}

