/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.connection.ClientSideStatement;
import com.google.cloud.spanner.connection.ClientSideStatementExecutor;
import com.google.cloud.spanner.connection.ConnectionStatementExecutor;
import com.google.cloud.spanner.connection.StatementResult;
import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

class ClientSideStatementImpl
implements ClientSideStatement {
    private String name;
    private String executorName;
    private StatementResult.ResultType resultType;
    private String regex;
    private String method;
    private List<String> exampleStatements;
    private List<String> examplePrerequisiteStatements;
    private ClientSideSetStatementImpl setStatement;
    private Pattern pattern;
    private ClientSideStatementExecutor executor;

    ClientSideStatementImpl() {
    }

    ClientSideStatementImpl compile() throws CompileException {
        try {
            this.pattern = Pattern.compile(this.regex);
            this.executor = (ClientSideStatementExecutor)Class.forName(this.getClass().getPackage().getName() + "." + this.executorName).newInstance();
            this.executor.compile(this);
            return this;
        }
        catch (Exception e) {
            throw new CompileException(e, this);
        }
    }

    @Override
    public StatementResult execute(ConnectionStatementExecutor connection, String statement) {
        Preconditions.checkState((this.executor != null ? 1 : 0) != 0, (Object)"This statement has not been compiled");
        try {
            return this.executor.execute(connection, statement);
        }
        catch (SpannerException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SpannerException) {
                throw (SpannerException)((Object)e.getCause());
            }
            throw new ExecuteException(e.getCause(), this, statement);
        }
        catch (Exception e) {
            throw new ExecuteException(e, this, statement);
        }
    }

    @Override
    public boolean isQuery() {
        return this.resultType == StatementResult.ResultType.RESULT_SET;
    }

    @Override
    public boolean isUpdate() {
        return this.resultType == StatementResult.ResultType.UPDATE_COUNT;
    }

    boolean matches(String statement) {
        Preconditions.checkState((this.pattern != null ? 1 : 0) != 0, (Object)"This statement has not been compiled");
        return this.pattern.matcher(statement).matches();
    }

    public String toString() {
        return this.name;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    String getMethodName() {
        return this.method;
    }

    @Override
    public List<String> getExampleStatements() {
        return Collections.unmodifiableList(this.exampleStatements);
    }

    @Override
    public List<String> getExamplePrerequisiteStatements() {
        if (this.examplePrerequisiteStatements == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.examplePrerequisiteStatements);
    }

    ClientSideSetStatementImpl getSetStatement() {
        return this.setStatement;
    }

    static class ExecuteException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final ClientSideStatementImpl statement;
        private final String sql;

        private ExecuteException(Throwable cause, ClientSideStatementImpl statement, String sql) {
            super(cause);
            this.statement = statement;
            this.sql = sql;
        }

        @Override
        public String getMessage() {
            return "Could not execute statement " + this.statement.name + " (" + this.sql + ")";
        }
    }

    static class CompileException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ClientSideStatementImpl statement;

        CompileException(Throwable cause, ClientSideStatementImpl statement) {
            super(cause);
            this.statement = statement;
        }

        @Override
        public String getMessage() {
            return "Could not compile statement " + this.statement.name;
        }
    }

    static class ClientSideSetStatementImpl {
        private String propertyName;
        private String separator;
        private String allowedValues;
        private String converterName;

        ClientSideSetStatementImpl() {
        }

        String getPropertyName() {
            return this.propertyName;
        }

        String getSeparator() {
            return this.separator;
        }

        String getAllowedValues() {
            return this.allowedValues;
        }

        String getConverterName() {
            return this.converterName;
        }
    }
}

