/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Preconditions;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;

final class TransactionManagerImpl
implements TransactionManager,
SessionImpl.SessionTransaction {
    private static final Tracer tracer = Tracing.getTracer();
    private final SessionImpl session;
    private Span span;
    private final Options options;
    private TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionManager.TransactionState txnState;

    TransactionManagerImpl(SessionImpl session, Span span, Options.TransactionOption ... options) {
        this.session = session;
        this.span = span;
        this.options = Options.fromTransactionOptions(options);
    }

    Span getSpan() {
        return this.span;
    }

    @Override
    public void setSpan(Span span) {
        this.span = span;
    }

    @Override
    public TransactionContext begin() {
        Preconditions.checkState((this.txn == null ? 1 : 0) != 0, (Object)"begin can only be called once");
        try (Scope s = tracer.withSpan(this.span);){
            this.txn = this.session.newTransaction(this.options);
            this.session.setActive(this);
            this.txnState = TransactionManager.TransactionState.STARTED;
            TransactionRunnerImpl.TransactionContextImpl transactionContextImpl = this.txn;
            return transactionContextImpl;
        }
    }

    @Override
    public void commit() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"commit can only be invoked if the transaction is in progress");
        if (this.txn.isAborted()) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Transaction already aborted");
        }
        try {
            this.txn.commit();
            this.txnState = TransactionManager.TransactionState.COMMITTED;
        }
        catch (AbortedException e1) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
            throw e1;
        }
        catch (SpannerException e2) {
            this.txnState = TransactionManager.TransactionState.COMMIT_FAILED;
            throw e2;
        }
    }

    @Override
    public void rollback() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"rollback can only be called if the transaction is in progress");
        try {
            this.txn.rollback();
        }
        finally {
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
    }

    @Override
    public TransactionContext resetForRetry() {
        if (this.txn == null || !this.txn.isAborted() && this.txnState != TransactionManager.TransactionState.ABORTED) {
            throw new IllegalStateException("resetForRetry can only be called if the previous attempt aborted");
        }
        try (Scope s = tracer.withSpan(this.span);){
            boolean useInlinedBegin = this.txn.transactionId != null;
            this.txn = this.session.newTransaction(this.options);
            if (!useInlinedBegin) {
                this.txn.ensureTxn();
            }
            this.txnState = TransactionManager.TransactionState.STARTED;
            TransactionRunnerImpl.TransactionContextImpl transactionContextImpl = this.txn;
            return transactionContextImpl;
        }
    }

    @Override
    public Timestamp getCommitTimestamp() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.COMMITTED ? 1 : 0) != 0, (Object)"getCommitTimestamp can only be invoked if the transaction committed successfully");
        return this.txn.commitTimestamp();
    }

    @Override
    public void close() {
        try {
            if (this.txnState == TransactionManager.TransactionState.STARTED && !this.txn.isAborted()) {
                this.txn.rollback();
                this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
            }
        }
        finally {
            this.span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    @Override
    public TransactionManager.TransactionState getState() {
        return this.txnState;
    }

    @Override
    public void invalidate() {
        this.close();
    }
}

