/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.RestoreInfo;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;

public class DatabaseInfo {
    private final DatabaseId id;
    private final State state;
    private final Timestamp createTime;
    private final RestoreInfo restoreInfo;
    private final com.google.spanner.admin.database.v1.Database proto;

    public DatabaseInfo(DatabaseId id, State state) {
        this.id = id;
        this.state = state;
        this.createTime = null;
        this.restoreInfo = null;
        this.proto = null;
    }

    DatabaseInfo(BuilderImpl builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.restoreInfo = builder.restoreInfo;
        this.proto = builder.proto;
    }

    public DatabaseId getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Nullable
    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo;
    }

    @Nullable
    public com.google.spanner.admin.database.v1.Database getProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseInfo that = (DatabaseInfo)o;
        return this.id.equals(that.id) && this.state == that.state && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.restoreInfo, that.restoreInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.createTime, this.restoreInfo});
    }

    public String toString() {
        return String.format("Database[%s, %s, %s, %s]", new Object[]{this.id.getName(), this.state, this.createTime, this.restoreInfo});
    }

    public static enum State {
        UNSPECIFIED,
        CREATING,
        READY,
        READY_OPTIMIZING;

    }

    static abstract class BuilderImpl
    extends Builder {
        protected final DatabaseId id;
        private State state = State.UNSPECIFIED;
        private Timestamp createTime;
        private RestoreInfo restoreInfo;
        private com.google.spanner.admin.database.v1.Database proto;

        BuilderImpl(DatabaseId id) {
            this.id = (DatabaseId)Preconditions.checkNotNull((Object)id);
        }

        BuilderImpl(DatabaseInfo other) {
            this.id = other.id;
            this.state = other.state;
            this.createTime = other.createTime;
            this.restoreInfo = other.restoreInfo;
            this.proto = other.proto;
        }

        @Override
        Builder setState(State state) {
            this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state)));
            return this;
        }

        @Override
        Builder setCreateTime(Timestamp createTime) {
            this.createTime = (Timestamp)Preconditions.checkNotNull((Object)createTime);
            return this;
        }

        @Override
        Builder setRestoreInfo(@Nullable RestoreInfo restoreInfo) {
            this.restoreInfo = restoreInfo;
            return this;
        }

        @Override
        Builder setProto(@Nullable com.google.spanner.admin.database.v1.Database proto) {
            this.proto = proto;
            return this;
        }
    }

    public static abstract class Builder {
        abstract Builder setState(State var1);

        abstract Builder setCreateTime(Timestamp var1);

        abstract Builder setRestoreInfo(RestoreInfo var1);

        abstract Builder setProto(com.google.spanner.admin.database.v1.Database var1);

        public abstract Database build();
    }
}

