/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.v1.SpannerClient;
import com.google.cloud.spanner.v1.stub.GrpcSpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BatchCreateSessionsRequest;
import com.google.spanner.v1.BatchCreateSessionsResponse;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteBatchDmlRequest;
import com.google.spanner.v1.ExecuteBatchDmlResponse;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.Transaction;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SpannerStubSettings
extends StubSettings<SpannerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/spanner.data").build();
    private final UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings;
    private final UnaryCallSettings<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsSettings;
    private final UnaryCallSettings<GetSessionRequest, Session> getSessionSettings;
    private final PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse> listSessionsSettings;
    private final UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings;
    private final UnaryCallSettings<ExecuteSqlRequest, ResultSet> executeSqlSettings;
    private final ServerStreamingCallSettings<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlSettings;
    private final UnaryCallSettings<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlSettings;
    private final UnaryCallSettings<ReadRequest, ResultSet> readSettings;
    private final ServerStreamingCallSettings<ReadRequest, PartialResultSet> streamingReadSettings;
    private final UnaryCallSettings<BeginTransactionRequest, Transaction> beginTransactionSettings;
    private final UnaryCallSettings<CommitRequest, CommitResponse> commitSettings;
    private final UnaryCallSettings<RollbackRequest, Empty> rollbackSettings;
    private final UnaryCallSettings<PartitionQueryRequest, PartitionResponse> partitionQuerySettings;
    private final UnaryCallSettings<PartitionReadRequest, PartitionResponse> partitionReadSettings;
    private static final PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session> LIST_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListSessionsRequest, ListSessionsResponse, Session>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionsRequest injectToken(ListSessionsRequest payload, String token) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageToken(token).build();
        }

        public ListSessionsRequest injectPageSize(ListSessionsRequest payload, int pageSize) {
            return ListSessionsRequest.newBuilder((ListSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Session> extractResources(ListSessionsResponse payload) {
            return payload.getSessionsList() != null ? payload.getSessionsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse> LIST_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse>(){

        public ApiFuture<SpannerClient.ListSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionsRequest, ListSessionsResponse> callable, ListSessionsRequest request, ApiCallContext context, ApiFuture<ListSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SpannerClient.ListSessionsPagedResponse.createAsync((PageContext<ListSessionsRequest, ListSessionsResponse, Session>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSessionRequest, Session> createSessionSettings() {
        return this.createSessionSettings;
    }

    public UnaryCallSettings<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsSettings() {
        return this.batchCreateSessionsSettings;
    }

    public UnaryCallSettings<GetSessionRequest, Session> getSessionSettings() {
        return this.getSessionSettings;
    }

    public PagedCallSettings<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse> listSessionsSettings() {
        return this.listSessionsSettings;
    }

    public UnaryCallSettings<DeleteSessionRequest, Empty> deleteSessionSettings() {
        return this.deleteSessionSettings;
    }

    public UnaryCallSettings<ExecuteSqlRequest, ResultSet> executeSqlSettings() {
        return this.executeSqlSettings;
    }

    public ServerStreamingCallSettings<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlSettings() {
        return this.executeStreamingSqlSettings;
    }

    public UnaryCallSettings<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlSettings() {
        return this.executeBatchDmlSettings;
    }

    public UnaryCallSettings<ReadRequest, ResultSet> readSettings() {
        return this.readSettings;
    }

    public ServerStreamingCallSettings<ReadRequest, PartialResultSet> streamingReadSettings() {
        return this.streamingReadSettings;
    }

    public UnaryCallSettings<BeginTransactionRequest, Transaction> beginTransactionSettings() {
        return this.beginTransactionSettings;
    }

    public UnaryCallSettings<CommitRequest, CommitResponse> commitSettings() {
        return this.commitSettings;
    }

    public UnaryCallSettings<RollbackRequest, Empty> rollbackSettings() {
        return this.rollbackSettings;
    }

    public UnaryCallSettings<PartitionQueryRequest, PartitionResponse> partitionQuerySettings() {
        return this.partitionQuerySettings;
    }

    public UnaryCallSettings<PartitionReadRequest, PartitionResponse> partitionReadSettings() {
        return this.partitionReadSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SpannerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSpannerStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "spanner.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SpannerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SpannerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SpannerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSessionSettings = settingsBuilder.createSessionSettings().build();
        this.batchCreateSessionsSettings = settingsBuilder.batchCreateSessionsSettings().build();
        this.getSessionSettings = settingsBuilder.getSessionSettings().build();
        this.listSessionsSettings = settingsBuilder.listSessionsSettings().build();
        this.deleteSessionSettings = settingsBuilder.deleteSessionSettings().build();
        this.executeSqlSettings = settingsBuilder.executeSqlSettings().build();
        this.executeStreamingSqlSettings = settingsBuilder.executeStreamingSqlSettings().build();
        this.executeBatchDmlSettings = settingsBuilder.executeBatchDmlSettings().build();
        this.readSettings = settingsBuilder.readSettings().build();
        this.streamingReadSettings = settingsBuilder.streamingReadSettings().build();
        this.beginTransactionSettings = settingsBuilder.beginTransactionSettings().build();
        this.commitSettings = settingsBuilder.commitSettings().build();
        this.rollbackSettings = settingsBuilder.rollbackSettings().build();
        this.partitionQuerySettings = settingsBuilder.partitionQuerySettings().build();
        this.partitionReadSettings = settingsBuilder.partitionReadSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SpannerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings;
        private final UnaryCallSettings.Builder<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsSettings;
        private final UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings;
        private final PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse> listSessionsSettings;
        private final UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings;
        private final UnaryCallSettings.Builder<ExecuteSqlRequest, ResultSet> executeSqlSettings;
        private final ServerStreamingCallSettings.Builder<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlSettings;
        private final UnaryCallSettings.Builder<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlSettings;
        private final UnaryCallSettings.Builder<ReadRequest, ResultSet> readSettings;
        private final ServerStreamingCallSettings.Builder<ReadRequest, PartialResultSet> streamingReadSettings;
        private final UnaryCallSettings.Builder<BeginTransactionRequest, Transaction> beginTransactionSettings;
        private final UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings;
        private final UnaryCallSettings.Builder<RollbackRequest, Empty> rollbackSettings;
        private final UnaryCallSettings.Builder<PartitionQueryRequest, PartitionResponse> partitionQuerySettings;
        private final UnaryCallSettings.Builder<PartitionReadRequest, PartitionResponse> partitionReadSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateSessionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSIONS_PAGE_STR_FACT);
            this.deleteSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.executeSqlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.executeStreamingSqlSettings = ServerStreamingCallSettings.newBuilder();
            this.executeBatchDmlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.streamingReadSettings = ServerStreamingCallSettings.newBuilder();
            this.beginTransactionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.commitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partitionQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.partitionReadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.batchCreateSessionsSettings, this.getSessionSettings, this.listSessionsSettings, this.deleteSessionSettings, this.executeSqlSettings, this.executeBatchDmlSettings, this.readSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.partitionQuerySettings, (Object[])new UnaryCallSettings.Builder[]{this.partitionReadSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SpannerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SpannerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SpannerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SpannerStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.batchCreateSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.getSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.listSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.executeSqlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.executeStreamingSqlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.executeBatchDmlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.readSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.streamingReadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.beginTransactionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.commitSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.rollbackSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.partitionQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.partitionReadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            return builder;
        }

        protected Builder(SpannerStubSettings settings) {
            super((StubSettings)settings);
            this.createSessionSettings = settings.createSessionSettings.toBuilder();
            this.batchCreateSessionsSettings = settings.batchCreateSessionsSettings.toBuilder();
            this.getSessionSettings = settings.getSessionSettings.toBuilder();
            this.listSessionsSettings = settings.listSessionsSettings.toBuilder();
            this.deleteSessionSettings = settings.deleteSessionSettings.toBuilder();
            this.executeSqlSettings = settings.executeSqlSettings.toBuilder();
            this.executeStreamingSqlSettings = settings.executeStreamingSqlSettings.toBuilder();
            this.executeBatchDmlSettings = settings.executeBatchDmlSettings.toBuilder();
            this.readSettings = settings.readSettings.toBuilder();
            this.streamingReadSettings = settings.streamingReadSettings.toBuilder();
            this.beginTransactionSettings = settings.beginTransactionSettings.toBuilder();
            this.commitSettings = settings.commitSettings.toBuilder();
            this.rollbackSettings = settings.rollbackSettings.toBuilder();
            this.partitionQuerySettings = settings.partitionQuerySettings.toBuilder();
            this.partitionReadSettings = settings.partitionReadSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionSettings, this.batchCreateSessionsSettings, this.getSessionSettings, this.listSessionsSettings, this.deleteSessionSettings, this.executeSqlSettings, this.executeBatchDmlSettings, this.readSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.partitionQuerySettings, (Object[])new UnaryCallSettings.Builder[]{this.partitionReadSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSessionRequest, Session> createSessionSettings() {
            return this.createSessionSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateSessionsRequest, BatchCreateSessionsResponse> batchCreateSessionsSettings() {
            return this.batchCreateSessionsSettings;
        }

        public UnaryCallSettings.Builder<GetSessionRequest, Session> getSessionSettings() {
            return this.getSessionSettings;
        }

        public PagedCallSettings.Builder<ListSessionsRequest, ListSessionsResponse, SpannerClient.ListSessionsPagedResponse> listSessionsSettings() {
            return this.listSessionsSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionRequest, Empty> deleteSessionSettings() {
            return this.deleteSessionSettings;
        }

        public UnaryCallSettings.Builder<ExecuteSqlRequest, ResultSet> executeSqlSettings() {
            return this.executeSqlSettings;
        }

        public ServerStreamingCallSettings.Builder<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlSettings() {
            return this.executeStreamingSqlSettings;
        }

        public UnaryCallSettings.Builder<ExecuteBatchDmlRequest, ExecuteBatchDmlResponse> executeBatchDmlSettings() {
            return this.executeBatchDmlSettings;
        }

        public UnaryCallSettings.Builder<ReadRequest, ResultSet> readSettings() {
            return this.readSettings;
        }

        public ServerStreamingCallSettings.Builder<ReadRequest, PartialResultSet> streamingReadSettings() {
            return this.streamingReadSettings;
        }

        public UnaryCallSettings.Builder<BeginTransactionRequest, Transaction> beginTransactionSettings() {
            return this.beginTransactionSettings;
        }

        public UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings() {
            return this.commitSettings;
        }

        public UnaryCallSettings.Builder<RollbackRequest, Empty> rollbackSettings() {
            return this.rollbackSettings;
        }

        public UnaryCallSettings.Builder<PartitionQueryRequest, PartitionResponse> partitionQuerySettings() {
            return this.partitionQuerySettings;
        }

        public UnaryCallSettings.Builder<PartitionReadRequest, PartitionResponse> partitionReadSettings() {
            return this.partitionReadSettings;
        }

        public SpannerStubSettings build() throws IOException {
            return new SpannerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)250L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

