/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AnalyzeMode;
import com.google.cloud.spanner.connection.DirectExecuteResultSet;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementParser;
import com.google.common.base.Preconditions;
import java.util.Objects;

final class FailedQuery
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final SpannerException exception;
    private final StatementParser.ParsedStatement statement;
    private final AnalyzeMode analyzeMode;
    private final Options.QueryOption[] options;

    FailedQuery(ReadWriteTransaction transaction, SpannerException exception, StatementParser.ParsedStatement statement, AnalyzeMode analyzeMode, Options.QueryOption ... options) {
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)((Object)exception));
        Preconditions.checkNotNull((Object)statement);
        this.transaction = transaction;
        this.exception = exception;
        this.statement = statement;
        this.analyzeMode = analyzeMode;
        this.options = options;
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
        try {
            this.transaction.getStatementExecutor().invokeInterceptors(this.statement, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
            DirectExecuteResultSet rs = DirectExecuteResultSet.ofResultSet(this.transaction.internalExecuteQuery(this.statement, this.analyzeMode, this.options));
            Throwable throwable = null;
            if (rs != null) {
                if (throwable != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    rs.close();
                }
            }
        }
        catch (SpannerException e) {
            if (e.getErrorCode() == this.exception.getErrorCode() && Objects.equals(e.getMessage(), this.exception.getMessage())) {
                return;
            }
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
    }
}

