/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerBatchUpdateException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.ReadWriteTransaction;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Objects;

final class FailedBatchUpdate
implements ReadWriteTransaction.RetriableStatement {
    private final ReadWriteTransaction transaction;
    private final SpannerException exception;
    private final Iterable<Statement> statements;

    FailedBatchUpdate(ReadWriteTransaction transaction, SpannerException exception, Iterable<Statement> statements) {
        Preconditions.checkNotNull((Object)transaction);
        Preconditions.checkNotNull((Object)((Object)exception));
        Preconditions.checkNotNull(statements);
        this.transaction = transaction;
        this.exception = exception;
        this.statements = statements;
    }

    @Override
    public void retry(AbortedException aborted) throws AbortedException {
        this.transaction.getStatementExecutor().invokeInterceptors(ReadWriteTransaction.EXECUTE_BATCH_UPDATE_STATEMENT, StatementExecutionStep.RETRY_STATEMENT, this.transaction);
        try {
            this.transaction.getReadContext().batchUpdate(this.statements);
        }
        catch (SpannerBatchUpdateException e) {
            if (this.exception instanceof SpannerBatchUpdateException && e.getErrorCode() == this.exception.getErrorCode() && Objects.equals(e.getMessage(), this.exception.getMessage()) && Arrays.equals(e.getUpdateCounts(), ((SpannerBatchUpdateException)this.exception).getUpdateCounts())) {
                return;
            }
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        catch (SpannerException e) {
            if (e.getErrorCode() == this.exception.getErrorCode() && Objects.equals(e.getMessage(), this.exception.getMessage())) {
                return;
            }
            throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted, e);
        }
        throw SpannerExceptionFactory.newAbortedDueToConcurrentModificationException(aborted);
    }
}

