/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractReadContext;
import com.google.cloud.spanner.AsyncRunner;
import com.google.cloud.spanner.AsyncRunnerImpl;
import com.google.cloud.spanner.AsyncTransactionManagerImpl;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.PartitionedDmlTransaction;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Session;
import com.google.cloud.spanner.SessionClient;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerImpl;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.TraceUtil;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionManagerImpl;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class SessionImpl
implements Session {
    private static final Tracer tracer = Tracing.getTracer();
    static final ThreadLocal<Boolean> hasPendingTransaction = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final SpannerImpl spanner;
    private final String name;
    private final DatabaseId databaseId;
    private SessionTransaction activeTransaction;
    ByteString readyTransactionId;
    private final Map<SpannerRpc.Option, ?> options;
    private Span currentSpan;

    static void throwIfTransactionsPending() {
        if (hasPendingTransaction.get() == Boolean.TRUE) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Nested transactions are not supported");
        }
    }

    SessionImpl(SpannerImpl spanner, String name, Map<SpannerRpc.Option, ?> options) {
        this.spanner = spanner;
        this.options = options;
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.databaseId = SessionClient.SessionId.of(name).getDatabaseId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    Map<SpannerRpc.Option, ?> getOptions() {
        return this.options;
    }

    void setCurrentSpan(Span span) {
        this.currentSpan = span;
    }

    @Override
    public long executePartitionedUpdate(Statement stmt) {
        this.setActive(null);
        PartitionedDmlTransaction txn = new PartitionedDmlTransaction(this, this.spanner.getRpc(), Ticker.systemTicker());
        return txn.executeStreamingPartitionedUpdate(stmt, ((SpannerOptions)this.spanner.getOptions()).getPartitionedDmlTimeout());
    }

    @Override
    public Timestamp write(Iterable<Mutation> mutations) throws SpannerException {
        TransactionRunner runner = this.readWriteTransaction();
        final Collection finalMutations = mutations instanceof Collection ? (Collection)mutations : Lists.newArrayList(mutations);
        runner.run(new TransactionRunner.TransactionCallable<Void>(){

            @Override
            public Void run(TransactionContext ctx) {
                ctx.buffer(finalMutations);
                return null;
            }
        });
        return runner.getCommitTimestamp();
    }

    /*
     * Exception decompiling
     */
    @Override
    public Timestamp writeAtLeastOnce(Iterable<Mutation> mutations) throws SpannerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ReadContext singleUse() {
        return this.singleUse(TimestampBound.strong());
    }

    @Override
    public ReadContext singleUse(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleReadContext.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).build());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction() {
        return this.singleUseReadOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction singleUseReadOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)((AbstractReadContext.SingleReadContext.Builder)AbstractReadContext.SingleUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).buildSingleUseReadOnlyTransaction());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction() {
        return this.readOnlyTransaction(TimestampBound.strong());
    }

    @Override
    public ReadOnlyTransaction readOnlyTransaction(TimestampBound bound) {
        return this.setActive(((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)((AbstractReadContext.MultiUseReadOnlyTransaction.Builder)AbstractReadContext.MultiUseReadOnlyTransaction.newBuilder().setSession(this)).setTimestampBound(bound).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).build());
    }

    @Override
    public TransactionRunner readWriteTransaction() {
        return this.setActive(new TransactionRunnerImpl(this, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks()));
    }

    @Override
    public AsyncRunner runAsync() {
        return new AsyncRunnerImpl(this.setActive(new TransactionRunnerImpl(this, this.spanner.getRpc(), this.spanner.getDefaultPrefetchChunks())));
    }

    @Override
    public TransactionManager transactionManager() {
        return new TransactionManagerImpl(this, this.currentSpan);
    }

    @Override
    public AsyncTransactionManagerImpl transactionManagerAsync() {
        return new AsyncTransactionManagerImpl(this, this.currentSpan);
    }

    @Override
    public void prepareReadWriteTransaction() {
        this.setActive(null);
        this.readyTransactionId = this.beginTransaction();
    }

    @Override
    public ApiFuture<Empty> asyncClose() {
        return this.spanner.getRpc().asyncDeleteSession(this.name, this.options);
    }

    @Override
    public void close() {
        Span span = tracer.spanBuilder("CloudSpannerOperation.DeleteSession").startSpan();
        try (Scope s = tracer.withSpan(span);){
            this.spanner.getRpc().deleteSession(this.name, this.options);
        }
        catch (RuntimeException e) {
            TraceUtil.setWithFailure(span, e);
            throw e;
        }
        finally {
            span.end(TraceUtil.END_SPAN_OPTIONS);
        }
    }

    ByteString beginTransaction() {
        try {
            return (ByteString)this.beginTransactionAsync().get();
        }
        catch (ExecutionException e) {
            throw SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause());
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt(e);
        }
    }

    ApiFuture<ByteString> beginTransactionAsync() {
        final SettableApiFuture res = SettableApiFuture.create();
        final Span span = tracer.spanBuilder("CloudSpannerOperation.BeginTransaction").startSpan();
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.name).setOptions(TransactionOptions.newBuilder().setReadWrite(TransactionOptions.ReadWrite.getDefaultInstance())).build();
        final ApiFuture<Transaction> requestFuture = this.spanner.getRpc().beginTransactionAsync(request, this.options);
        requestFuture.addListener(tracer.withSpan(span, new Runnable(){

            @Override
            public void run() {
                try {
                    Transaction txn = (Transaction)requestFuture.get();
                    if (txn.getId().isEmpty()) {
                        throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Missing id in transaction\n" + SessionImpl.this.getName());
                    }
                    span.end(TraceUtil.END_SPAN_OPTIONS);
                    res.set((Object)txn.getId());
                }
                catch (ExecutionException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(e.getCause() == null ? e : e.getCause())));
                }
                catch (InterruptedException e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    res.setException((Throwable)((Object)SpannerExceptionFactory.propagateInterrupt(e)));
                }
                catch (Exception e) {
                    TraceUtil.endSpanWithFailure(span, e);
                    res.setException((Throwable)e);
                }
            }
        }), MoreExecutors.directExecutor());
        return res;
    }

    TransactionRunnerImpl.TransactionContextImpl newTransaction() {
        return ((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)((TransactionRunnerImpl.TransactionContextImpl.Builder)TransactionRunnerImpl.TransactionContextImpl.newBuilder().setSession(this)).setTransactionId(this.readyTransactionId).setRpc(this.spanner.getRpc())).setDefaultQueryOptions(this.spanner.getDefaultQueryOptions(this.databaseId))).setDefaultPrefetchChunks(this.spanner.getDefaultPrefetchChunks())).setSpan(this.currentSpan)).setExecutorProvider(this.spanner.getAsyncExecutorProvider())).build();
    }

    <T extends SessionTransaction> T setActive(@Nullable T ctx) {
        SessionImpl.throwIfTransactionsPending();
        if (this.activeTransaction != null) {
            this.activeTransaction.invalidate();
        }
        this.activeTransaction = ctx;
        this.readyTransactionId = null;
        if (this.activeTransaction != null) {
            this.activeTransaction.setSpan(this.currentSpan);
        }
        return ctx;
    }

    boolean hasReadyTransaction() {
        return this.readyTransactionId != null;
    }

    static interface SessionTransaction {
        public void invalidate();

        public void setSpan(Span var1);
    }
}

