/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.DeadlineExceededException;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnavailableException;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.spi.v1.SpannerRpc;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import com.google.spanner.v1.TransactionSelector;
import io.grpc.Status;
import io.opencensus.trace.Span;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.threeten.bp.Duration;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;

class PartitionedDMLTransaction
implements SessionImpl.SessionTransaction {
    private static final Logger log = Logger.getLogger(PartitionedDMLTransaction.class.getName());
    private final SessionImpl session;
    private final SpannerRpc rpc;
    private volatile boolean isValid = true;

    PartitionedDMLTransaction(SessionImpl session, SpannerRpc rpc) {
        this.session = session;
        this.rpc = rpc;
    }

    private ByteString initTransaction() {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(this.session.getName()).setOptions(TransactionOptions.newBuilder().setPartitionedDml(TransactionOptions.PartitionedDml.getDefaultInstance())).build();
        Transaction txn = this.rpc.beginTransaction(request, this.session.getOptions());
        if (txn.getId().isEmpty()) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INTERNAL, "Failed to init transaction, missing transaction id\n" + this.session.getName());
        }
        return txn.getId();
    }

    long executeStreamingPartitionedUpdate(Statement statement, Duration timeout) {
        Preconditions.checkState((boolean)this.isValid, (Object)"Partitioned DML has been invalidated by a new operation on the session");
        log.log(Level.FINER, "Starting PartitionedUpdate statement");
        boolean foundStats = false;
        long updateCount = 0L;
        Stopwatch stopWatch = this.createStopwatchStarted();
        try {
            block6: while (true) {
                ByteString resumeToken = ByteString.EMPTY;
                try {
                    ByteString transactionId = this.initTransaction();
                    ExecuteSqlRequest.Builder builder = ExecuteSqlRequest.newBuilder().setSql(statement.getSql()).setQueryMode(ExecuteSqlRequest.QueryMode.NORMAL).setSession(this.session.getName()).setTransaction(TransactionSelector.newBuilder().setId(transactionId).build());
                    Map<String, Value> stmtParameters = statement.getParameters();
                    if (!stmtParameters.isEmpty()) {
                        Struct.Builder paramsBuilder = builder.getParamsBuilder();
                        for (Map.Entry<String, Value> param : stmtParameters.entrySet()) {
                            paramsBuilder.putFields(param.getKey(), param.getValue().toProto());
                            builder.putParamTypes(param.getKey(), param.getValue().getType().toProto());
                        }
                    }
                    while (true) {
                        Duration remainingTimeout;
                        if ((remainingTimeout = timeout.minus(stopWatch.elapsed(TimeUnit.MILLISECONDS), (TemporalUnit)ChronoUnit.MILLIS)).isNegative() || remainingTimeout.isZero()) {
                            throw new DeadlineExceededException(null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), false);
                        }
                        try {
                            builder.setResumeToken(resumeToken);
                            ServerStream<PartialResultSet> stream = this.rpc.executeStreamingPartitionedDml(builder.build(), this.session.getOptions(), remainingTimeout);
                            for (PartialResultSet rs : stream) {
                                if (rs.getResumeToken() != null && !ByteString.EMPTY.equals((Object)rs.getResumeToken())) {
                                    resumeToken = rs.getResumeToken();
                                }
                                if (!rs.hasStats()) continue;
                                foundStats = true;
                                updateCount += rs.getStats().getRowCountLowerBound();
                            }
                            break block6;
                        }
                        catch (UnavailableException e) {
                            if (!ByteString.EMPTY.equals((Object)resumeToken)) {
                                log.log(Level.FINER, "Retrying PartitionedDml stream using resume token '" + resumeToken.toStringUtf8() + "' because of broken stream", e);
                                continue;
                            }
                            throw new AbortedException((Throwable)e, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.ABORTED), true);
                        }
                        break;
                    }
                }
                catch (AbortedException e) {
                    log.log(Level.FINER, "Retrying PartitionedDml transaction after AbortedException", e);
                    continue;
                }
                break;
            }
            if (!foundStats) {
                throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "Partitioned DML response missing stats possibly due to non-DML statement as input");
            }
            log.log(Level.FINER, "Finished PartitionedUpdate statement");
            return updateCount;
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    Stopwatch createStopwatchStarted() {
        return Stopwatch.createStarted();
    }

    @Override
    public void invalidate() {
        this.isValid = false;
    }

    @Override
    public void setSpan(Span span) {
    }
}

