/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.AsyncTransactionManager;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SessionImpl;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionContextFutureImpl;
import com.google.cloud.spanner.TransactionManager;
import com.google.cloud.spanner.TransactionRunnerImpl;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.opencensus.trace.Span;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import java.util.concurrent.Executor;

final class AsyncTransactionManagerImpl
implements TransactionContextFutureImpl.CommittableAsyncTransactionManager,
SessionImpl.SessionTransaction {
    private static final Tracer tracer = Tracing.getTracer();
    private final SessionImpl session;
    private Span span;
    private TransactionRunnerImpl.TransactionContextImpl txn;
    private TransactionManager.TransactionState txnState;
    private final SettableApiFuture<Timestamp> commitTimestamp = SettableApiFuture.create();

    AsyncTransactionManagerImpl(SessionImpl session, Span span) {
        this.session = session;
        this.span = span;
    }

    @Override
    public void setSpan(Span span) {
        this.span = span;
    }

    @Override
    public void close() {
        this.txn.close();
    }

    @Override
    public TransactionContextFutureImpl beginAsync() {
        Preconditions.checkState((this.txn == null ? 1 : 0) != 0, (Object)"begin can only be called once");
        TransactionContextFutureImpl begin = new TransactionContextFutureImpl(this, this.internalBeginAsync(true));
        return begin;
    }

    private ApiFuture<TransactionContext> internalBeginAsync(boolean setActive) {
        this.txnState = TransactionManager.TransactionState.STARTED;
        this.txn = this.session.newTransaction();
        if (setActive) {
            this.session.setActive(this);
        }
        final SettableApiFuture res = SettableApiFuture.create();
        ApiFuture<Void> fut = this.txn.ensureTxnAsync();
        ApiFutures.addCallback(fut, (ApiFutureCallback)new ApiFutureCallback<Void>(){

            public void onFailure(Throwable t) {
                res.setException((Throwable)((Object)SpannerExceptionFactory.newSpannerException(t)));
            }

            public void onSuccess(Void result) {
                res.set((Object)AsyncTransactionManagerImpl.this.txn);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public void onError(Throwable t) {
        if (t instanceof AbortedException) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
        }
    }

    @Override
    public ApiFuture<Timestamp> commitAsync() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)("commit can only be invoked if the transaction is in progress. Current state: " + (Object)((Object)this.txnState)));
        if (this.txn.isAborted()) {
            this.txnState = TransactionManager.TransactionState.ABORTED;
            return ApiFutures.immediateFailedFuture((Throwable)((Object)SpannerExceptionFactory.newSpannerException(ErrorCode.ABORTED, "Transaction already aborted")));
        }
        ApiFuture<Timestamp> res = this.txn.commitAsync();
        this.txnState = TransactionManager.TransactionState.COMMITTED;
        ApiFutures.addCallback(res, (ApiFutureCallback)new ApiFutureCallback<Timestamp>(){

            public void onFailure(Throwable t) {
                if (t instanceof AbortedException) {
                    AsyncTransactionManagerImpl.this.txnState = TransactionManager.TransactionState.ABORTED;
                } else {
                    AsyncTransactionManagerImpl.this.txnState = TransactionManager.TransactionState.COMMIT_FAILED;
                    AsyncTransactionManagerImpl.this.commitTimestamp.setException(t);
                }
            }

            public void onSuccess(Timestamp result) {
                AsyncTransactionManagerImpl.this.commitTimestamp.set((Object)result);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return res;
    }

    @Override
    public ApiFuture<Void> rollbackAsync() {
        Preconditions.checkState((this.txnState == TransactionManager.TransactionState.STARTED ? 1 : 0) != 0, (Object)"rollback can only be called if the transaction is in progress");
        try {
            ApiFuture<Void> apiFuture = this.txn.rollbackAsync();
            return apiFuture;
        }
        finally {
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
    }

    @Override
    public AsyncTransactionManager.TransactionContextFuture resetForRetryAsync() {
        if (this.txn == null || !this.txn.isAborted() && this.txnState != TransactionManager.TransactionState.ABORTED) {
            throw new IllegalStateException("resetForRetry can only be called if the previous attempt aborted");
        }
        return new TransactionContextFutureImpl(this, this.internalBeginAsync(false));
    }

    @Override
    public TransactionManager.TransactionState getState() {
        return this.txnState;
    }

    @Override
    public void invalidate() {
        if (this.txnState == TransactionManager.TransactionState.STARTED || this.txnState == null) {
            this.txnState = TransactionManager.TransactionState.ROLLED_BACK;
        }
    }
}

