/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.api.core.ApiClock;
import com.google.api.core.NanoClock;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.cloud.RetryHelper;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.common.base.Throwables;
import io.grpc.Context;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.threeten.bp.Duration;

class SpannerRetryHelper {
    private static final RetrySettings txRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setMaxRetryDelay(Duration.ofMillis((long)32000L)).setTotalTimeout(Duration.ofMillis((long)Integer.MAX_VALUE)).build();

    SpannerRetryHelper() {
    }

    static <T> T runTxWithRetriesOnAborted(Callable<T> callable) {
        try {
            return (T)RetryHelper.runWithRetries(callable, (RetrySettings)txRetrySettings, new TxRetryAlgorithm(), (ApiClock)NanoClock.getDefaultClock());
        }
        catch (RetryHelper.RetryHelperException e) {
            if (e.getCause() != null) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
            }
            throw e;
        }
    }

    private static class TxRetryAlgorithm<T>
    implements ResultRetryAlgorithm<T> {
        private TxRetryAlgorithm() {
        }

        public TimedAttemptSettings createNextAttempt(Throwable prevThrowable, T prevResponse, TimedAttemptSettings prevSettings) {
            long retryDelay;
            if (prevThrowable != null && (retryDelay = SpannerException.extractRetryDelay(prevThrowable)) > -1L) {
                return prevSettings.toBuilder().setRandomizedRetryDelay(Duration.ofMillis((long)retryDelay)).build();
            }
            return null;
        }

        public boolean shouldRetry(Throwable prevThrowable, T prevResponse) throws CancellationException {
            if (Context.current().isCancelled()) {
                throw SpannerExceptionFactory.newSpannerExceptionForCancellation(Context.current(), null);
            }
            return prevThrowable != null && (prevThrowable instanceof AbortedException || prevThrowable instanceof com.google.api.gax.rpc.AbortedException);
        }
    }
}

