/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.spanner.v1.SpannerSettings;
import com.google.cloud.spanner.v1.stub.SpannerStub;
import com.google.cloud.spanner.v1.stub.SpannerStubSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import com.google.spanner.v1.BeginTransactionRequest;
import com.google.spanner.v1.CommitRequest;
import com.google.spanner.v1.CommitResponse;
import com.google.spanner.v1.CreateSessionRequest;
import com.google.spanner.v1.DatabaseName;
import com.google.spanner.v1.DeleteSessionRequest;
import com.google.spanner.v1.ExecuteSqlRequest;
import com.google.spanner.v1.GetSessionRequest;
import com.google.spanner.v1.ListSessionsRequest;
import com.google.spanner.v1.ListSessionsResponse;
import com.google.spanner.v1.Mutation;
import com.google.spanner.v1.PartialResultSet;
import com.google.spanner.v1.PartitionQueryRequest;
import com.google.spanner.v1.PartitionReadRequest;
import com.google.spanner.v1.PartitionResponse;
import com.google.spanner.v1.ReadRequest;
import com.google.spanner.v1.ResultSet;
import com.google.spanner.v1.RollbackRequest;
import com.google.spanner.v1.Session;
import com.google.spanner.v1.SessionName;
import com.google.spanner.v1.Transaction;
import com.google.spanner.v1.TransactionOptions;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SpannerClient
implements BackgroundResource {
    private final SpannerSettings settings;
    private final SpannerStub stub;

    public static final SpannerClient create() throws IOException {
        return SpannerClient.create(SpannerSettings.newBuilder().build());
    }

    public static final SpannerClient create(SpannerSettings settings) throws IOException {
        return new SpannerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SpannerClient create(SpannerStub stub) {
        return new SpannerClient(stub);
    }

    protected SpannerClient(SpannerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SpannerStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SpannerClient(SpannerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SpannerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SpannerStub getStub() {
        return this.stub;
    }

    public final Session createSession(DatabaseName database) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setDatabase(database == null ? null : database.toString()).build();
        return this.createSession(request);
    }

    public final Session createSession(String database) {
        CreateSessionRequest request = CreateSessionRequest.newBuilder().setDatabase(database).build();
        return this.createSession(request);
    }

    public final Session createSession(CreateSessionRequest request) {
        return (Session)this.createSessionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.stub.createSessionCallable();
    }

    public final Session getSession(SessionName name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSession(request);
    }

    public final Session getSession(String name) {
        GetSessionRequest request = GetSessionRequest.newBuilder().setName(name).build();
        return this.getSession(request);
    }

    public final Session getSession(GetSessionRequest request) {
        return (Session)this.getSessionCallable().call((Object)request);
    }

    public final UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.stub.getSessionCallable();
    }

    public final ListSessionsPagedResponse listSessions(String database) {
        ListSessionsRequest request = ListSessionsRequest.newBuilder().setDatabase(database).build();
        return this.listSessions(request);
    }

    public final ListSessionsPagedResponse listSessions(ListSessionsRequest request) {
        return (ListSessionsPagedResponse)((Object)this.listSessionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.stub.listSessionsPagedCallable();
    }

    public final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.stub.listSessionsCallable();
    }

    public final void deleteSession(SessionName name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteSession(request);
    }

    public final void deleteSession(String name) {
        DeleteSessionRequest request = DeleteSessionRequest.newBuilder().setName(name).build();
        this.deleteSession(request);
    }

    public final void deleteSession(DeleteSessionRequest request) {
        this.deleteSessionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.stub.deleteSessionCallable();
    }

    public final ResultSet executeSql(ExecuteSqlRequest request) {
        return (ResultSet)this.executeSqlCallable().call((Object)request);
    }

    public final UnaryCallable<ExecuteSqlRequest, ResultSet> executeSqlCallable() {
        return this.stub.executeSqlCallable();
    }

    public final ServerStreamingCallable<ExecuteSqlRequest, PartialResultSet> executeStreamingSqlCallable() {
        return this.stub.executeStreamingSqlCallable();
    }

    public final ResultSet read(ReadRequest request) {
        return (ResultSet)this.readCallable().call((Object)request);
    }

    public final UnaryCallable<ReadRequest, ResultSet> readCallable() {
        return this.stub.readCallable();
    }

    public final ServerStreamingCallable<ReadRequest, PartialResultSet> streamingReadCallable() {
        return this.stub.streamingReadCallable();
    }

    public final Transaction beginTransaction(SessionName session, TransactionOptions options) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(session == null ? null : session.toString()).setOptions(options).build();
        return this.beginTransaction(request);
    }

    public final Transaction beginTransaction(String session, TransactionOptions options) {
        BeginTransactionRequest request = BeginTransactionRequest.newBuilder().setSession(session).setOptions(options).build();
        return this.beginTransaction(request);
    }

    public final Transaction beginTransaction(BeginTransactionRequest request) {
        return (Transaction)this.beginTransactionCallable().call((Object)request);
    }

    public final UnaryCallable<BeginTransactionRequest, Transaction> beginTransactionCallable() {
        return this.stub.beginTransactionCallable();
    }

    public final CommitResponse commit(SessionName session, ByteString transactionId, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setSession(session == null ? null : session.toString()).setTransactionId(transactionId).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(String session, ByteString transactionId, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setSession(session).setTransactionId(transactionId).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(SessionName session, TransactionOptions singleUseTransaction, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setSession(session == null ? null : session.toString()).setSingleUseTransaction(singleUseTransaction).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(String session, TransactionOptions singleUseTransaction, List<Mutation> mutations) {
        CommitRequest request = CommitRequest.newBuilder().setSession(session).setSingleUseTransaction(singleUseTransaction).addAllMutations(mutations).build();
        return this.commit(request);
    }

    public final CommitResponse commit(CommitRequest request) {
        return (CommitResponse)this.commitCallable().call((Object)request);
    }

    public final UnaryCallable<CommitRequest, CommitResponse> commitCallable() {
        return this.stub.commitCallable();
    }

    public final void rollback(SessionName session, ByteString transactionId) {
        RollbackRequest request = RollbackRequest.newBuilder().setSession(session == null ? null : session.toString()).setTransactionId(transactionId).build();
        this.rollback(request);
    }

    public final void rollback(String session, ByteString transactionId) {
        RollbackRequest request = RollbackRequest.newBuilder().setSession(session).setTransactionId(transactionId).build();
        this.rollback(request);
    }

    public final void rollback(RollbackRequest request) {
        this.rollbackCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackRequest, Empty> rollbackCallable() {
        return this.stub.rollbackCallable();
    }

    public final PartitionResponse partitionQuery(PartitionQueryRequest request) {
        return (PartitionResponse)this.partitionQueryCallable().call((Object)request);
    }

    public final UnaryCallable<PartitionQueryRequest, PartitionResponse> partitionQueryCallable() {
        return this.stub.partitionQueryCallable();
    }

    public final PartitionResponse partitionRead(PartitionReadRequest request) {
        return (PartitionResponse)this.partitionReadCallable().call((Object)request);
    }

    public final UnaryCallable<PartitionReadRequest, PartitionResponse> partitionReadCallable() {
        return this.stub.partitionReadCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSessionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        private ListSessionsFixedSizeCollection(List<ListSessionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSessionsFixedSizeCollection createEmptyCollection() {
            return new ListSessionsFixedSizeCollection(null, 0);
        }

        protected ListSessionsFixedSizeCollection createCollection(List<ListSessionsPage> pages, int collectionSize) {
            return new ListSessionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSessionsPage
    extends AbstractPage<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage> {
        private ListSessionsPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            super(context, (Object)response);
        }

        private static ListSessionsPage createEmptyPage() {
            return new ListSessionsPage(null, null);
        }

        protected ListSessionsPage createPage(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ListSessionsResponse response) {
            return new ListSessionsPage(context, response);
        }

        public ApiFuture<ListSessionsPage> createPageAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSessionsPagedResponse
    extends AbstractPagedListResponse<ListSessionsRequest, ListSessionsResponse, Session, ListSessionsPage, ListSessionsFixedSizeCollection> {
        public static ApiFuture<ListSessionsPagedResponse> createAsync(PageContext<ListSessionsRequest, ListSessionsResponse, Session> context, ApiFuture<ListSessionsResponse> futureResponse) {
            ApiFuture<ListSessionsPage> futurePage = ListSessionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSessionsPage, ListSessionsPagedResponse>(){

                public ListSessionsPagedResponse apply(ListSessionsPage input) {
                    return new ListSessionsPagedResponse(input);
                }
            });
        }

        private ListSessionsPagedResponse(ListSessionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSessionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

