/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner;

import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerException;
import com.google.protobuf.Duration;
import com.google.protobuf.Message;
import com.google.protobuf.util.Durations;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import javax.annotation.Nullable;

public class AbortedException
extends SpannerException {
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());
    private static final boolean IS_RETRYABLE = false;

    AbortedException(SpannerException.DoNotConstructDirectly token, @Nullable String message, @Nullable Throwable cause) {
        super(token, ErrorCode.ABORTED, false, message, cause);
    }

    public long getRetryDelayInMillis() {
        RetryInfo retryInfo;
        Metadata trailers;
        if (this.getCause() != null && (trailers = Status.trailersFromThrowable((Throwable)this.getCause())) != null && trailers.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)trailers.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            return Durations.toMillis((Duration)retryInfo.getRetryDelay());
        }
        return -1L;
    }
}

