/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.shell.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.shell.v1.AddPublicKeyMetadata;
import com.google.cloud.shell.v1.AddPublicKeyRequest;
import com.google.cloud.shell.v1.AddPublicKeyResponse;
import com.google.cloud.shell.v1.AuthorizeEnvironmentMetadata;
import com.google.cloud.shell.v1.AuthorizeEnvironmentRequest;
import com.google.cloud.shell.v1.AuthorizeEnvironmentResponse;
import com.google.cloud.shell.v1.Environment;
import com.google.cloud.shell.v1.GetEnvironmentRequest;
import com.google.cloud.shell.v1.RemovePublicKeyMetadata;
import com.google.cloud.shell.v1.RemovePublicKeyRequest;
import com.google.cloud.shell.v1.RemovePublicKeyResponse;
import com.google.cloud.shell.v1.StartEnvironmentMetadata;
import com.google.cloud.shell.v1.StartEnvironmentRequest;
import com.google.cloud.shell.v1.StartEnvironmentResponse;
import com.google.cloud.shell.v1.stub.CloudShellServiceStub;
import com.google.cloud.shell.v1.stub.CloudShellServiceStubSettings;
import com.google.cloud.shell.v1.stub.HttpJsonCloudShellServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCloudShellServiceStub
extends CloudShellServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(StartEnvironmentResponse.getDescriptor()).add(RemovePublicKeyResponse.getDescriptor()).add(AuthorizeEnvironmentResponse.getDescriptor()).add(StartEnvironmentMetadata.getDescriptor()).add(RemovePublicKeyMetadata.getDescriptor()).add(AddPublicKeyResponse.getDescriptor()).add(AuthorizeEnvironmentMetadata.getDescriptor()).add(AddPublicKeyMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetEnvironmentRequest, Environment> getEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.shell.v1.CloudShellService/GetEnvironment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=users/*/environments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Environment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StartEnvironmentRequest, Operation> startEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.shell.v1.CloudShellService/StartEnvironment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=users/*/environments/*}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.shell.v1.CloudShellService/AuthorizeEnvironment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=users/*/environments/*}:authorize", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<AddPublicKeyRequest, Operation> addPublicKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.shell.v1.CloudShellService/AddPublicKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{environment=users/*/environments/*}:addPublicKey", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "environment", (Object)request.getEnvironment());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEnvironment().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RemovePublicKeyRequest, Operation> removePublicKeyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.shell.v1.CloudShellService/RemovePublicKey").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{environment=users/*/environments/*}:removePublicKey", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "environment", (Object)request.getEnvironment());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearEnvironment().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable;
    private final UnaryCallable<StartEnvironmentRequest, Operation> startEnvironmentCallable;
    private final OperationCallable<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationCallable;
    private final UnaryCallable<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentCallable;
    private final OperationCallable<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationCallable;
    private final UnaryCallable<AddPublicKeyRequest, Operation> addPublicKeyCallable;
    private final OperationCallable<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationCallable;
    private final UnaryCallable<RemovePublicKeyRequest, Operation> removePublicKeyCallable;
    private final OperationCallable<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCloudShellServiceStub create(CloudShellServiceStubSettings settings) throws IOException {
        return new HttpJsonCloudShellServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCloudShellServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCloudShellServiceStub(CloudShellServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCloudShellServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCloudShellServiceStub(CloudShellServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCloudShellServiceStub(CloudShellServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCloudShellServiceCallableFactory());
    }

    protected HttpJsonCloudShellServiceStub(CloudShellServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings getEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings startEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings authorizeEnvironmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(authorizeEnvironmentMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings addPublicKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(addPublicKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings removePublicKeyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(removePublicKeyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getEnvironmentCallable = callableFactory.createUnaryCallable(getEnvironmentTransportSettings, settings.getEnvironmentSettings(), clientContext);
        this.startEnvironmentCallable = callableFactory.createUnaryCallable(startEnvironmentTransportSettings, settings.startEnvironmentSettings(), clientContext);
        this.startEnvironmentOperationCallable = callableFactory.createOperationCallable(startEnvironmentTransportSettings, settings.startEnvironmentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.authorizeEnvironmentCallable = callableFactory.createUnaryCallable(authorizeEnvironmentTransportSettings, settings.authorizeEnvironmentSettings(), clientContext);
        this.authorizeEnvironmentOperationCallable = callableFactory.createOperationCallable(authorizeEnvironmentTransportSettings, settings.authorizeEnvironmentOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.addPublicKeyCallable = callableFactory.createUnaryCallable(addPublicKeyTransportSettings, settings.addPublicKeySettings(), clientContext);
        this.addPublicKeyOperationCallable = callableFactory.createOperationCallable(addPublicKeyTransportSettings, settings.addPublicKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.removePublicKeyCallable = callableFactory.createUnaryCallable(removePublicKeyTransportSettings, settings.removePublicKeySettings(), clientContext);
        this.removePublicKeyOperationCallable = callableFactory.createOperationCallable(removePublicKeyTransportSettings, settings.removePublicKeyOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getEnvironmentMethodDescriptor);
        methodDescriptors.add(startEnvironmentMethodDescriptor);
        methodDescriptors.add(authorizeEnvironmentMethodDescriptor);
        methodDescriptors.add(addPublicKeyMethodDescriptor);
        methodDescriptors.add(removePublicKeyMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetEnvironmentRequest, Environment> getEnvironmentCallable() {
        return this.getEnvironmentCallable;
    }

    @Override
    public UnaryCallable<StartEnvironmentRequest, Operation> startEnvironmentCallable() {
        return this.startEnvironmentCallable;
    }

    @Override
    public OperationCallable<StartEnvironmentRequest, StartEnvironmentResponse, StartEnvironmentMetadata> startEnvironmentOperationCallable() {
        return this.startEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<AuthorizeEnvironmentRequest, Operation> authorizeEnvironmentCallable() {
        return this.authorizeEnvironmentCallable;
    }

    @Override
    public OperationCallable<AuthorizeEnvironmentRequest, AuthorizeEnvironmentResponse, AuthorizeEnvironmentMetadata> authorizeEnvironmentOperationCallable() {
        return this.authorizeEnvironmentOperationCallable;
    }

    @Override
    public UnaryCallable<AddPublicKeyRequest, Operation> addPublicKeyCallable() {
        return this.addPublicKeyCallable;
    }

    @Override
    public OperationCallable<AddPublicKeyRequest, AddPublicKeyResponse, AddPublicKeyMetadata> addPublicKeyOperationCallable() {
        return this.addPublicKeyOperationCallable;
    }

    @Override
    public UnaryCallable<RemovePublicKeyRequest, Operation> removePublicKeyCallable() {
        return this.removePublicKeyCallable;
    }

    @Override
    public OperationCallable<RemovePublicKeyRequest, RemovePublicKeyResponse, RemovePublicKeyMetadata> removePublicKeyOperationCallable() {
        return this.removePublicKeyOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

