/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.servicedirectory.v1.CreateEndpointRequest;
import com.google.cloud.servicedirectory.v1.CreateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.CreateServiceRequest;
import com.google.cloud.servicedirectory.v1.DeleteEndpointRequest;
import com.google.cloud.servicedirectory.v1.DeleteNamespaceRequest;
import com.google.cloud.servicedirectory.v1.DeleteServiceRequest;
import com.google.cloud.servicedirectory.v1.Endpoint;
import com.google.cloud.servicedirectory.v1.GetEndpointRequest;
import com.google.cloud.servicedirectory.v1.GetNamespaceRequest;
import com.google.cloud.servicedirectory.v1.GetServiceRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsResponse;
import com.google.cloud.servicedirectory.v1.ListNamespacesRequest;
import com.google.cloud.servicedirectory.v1.ListNamespacesResponse;
import com.google.cloud.servicedirectory.v1.ListServicesRequest;
import com.google.cloud.servicedirectory.v1.ListServicesResponse;
import com.google.cloud.servicedirectory.v1.Namespace;
import com.google.cloud.servicedirectory.v1.RegistrationServiceClient;
import com.google.cloud.servicedirectory.v1.Service;
import com.google.cloud.servicedirectory.v1.UpdateEndpointRequest;
import com.google.cloud.servicedirectory.v1.UpdateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.UpdateServiceRequest;
import com.google.cloud.servicedirectory.v1.stub.GrpcRegistrationServiceCallableFactory;
import com.google.cloud.servicedirectory.v1.stub.RegistrationServiceStub;
import com.google.cloud.servicedirectory.v1.stub.RegistrationServiceStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRegistrationServiceStub
extends RegistrationServiceStub {
    private static final MethodDescriptor<CreateNamespaceRequest, Namespace> createNamespaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/CreateNamespace").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateNamespaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Namespace.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListNamespacesRequest, ListNamespacesResponse> listNamespacesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/ListNamespaces").setRequestMarshaller(ProtoUtils.marshaller((Message)ListNamespacesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListNamespacesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetNamespaceRequest, Namespace> getNamespaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/GetNamespace").setRequestMarshaller(ProtoUtils.marshaller((Message)GetNamespaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Namespace.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateNamespaceRequest, Namespace> updateNamespaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/UpdateNamespace").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateNamespaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Namespace.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteNamespaceRequest, Empty> deleteNamespaceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/DeleteNamespace").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteNamespaceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateServiceRequest, Service> createServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/CreateService").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateServiceRequest, Service> updateServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/UpdateService").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteServiceRequest, Empty> deleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/DeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateEndpointRequest, Endpoint> createEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/CreateEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListEndpointsRequest, ListEndpointsResponse> listEndpointsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/ListEndpoints").setRequestMarshaller(ProtoUtils.marshaller((Message)ListEndpointsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListEndpointsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetEndpointRequest, Endpoint> getEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/GetEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)GetEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateEndpointRequest, Endpoint> updateEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/UpdateEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Endpoint.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteEndpointRequest, Empty> deleteEndpointMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/DeleteEndpoint").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteEndpointRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.servicedirectory.v1.RegistrationService/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateNamespaceRequest, Namespace> createNamespaceCallable;
    private final UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> listNamespacesCallable;
    private final UnaryCallable<ListNamespacesRequest, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesPagedCallable;
    private final UnaryCallable<GetNamespaceRequest, Namespace> getNamespaceCallable;
    private final UnaryCallable<UpdateNamespaceRequest, Namespace> updateNamespaceCallable;
    private final UnaryCallable<DeleteNamespaceRequest, Empty> deleteNamespaceCallable;
    private final UnaryCallable<CreateServiceRequest, Service> createServiceCallable;
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, RegistrationServiceClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<UpdateServiceRequest, Service> updateServiceCallable;
    private final UnaryCallable<DeleteServiceRequest, Empty> deleteServiceCallable;
    private final UnaryCallable<CreateEndpointRequest, Endpoint> createEndpointCallable;
    private final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable;
    private final UnaryCallable<ListEndpointsRequest, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsPagedCallable;
    private final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable;
    private final UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable;
    private final UnaryCallable<DeleteEndpointRequest, Empty> deleteEndpointCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRegistrationServiceStub create(RegistrationServiceStubSettings settings) throws IOException {
        return new GrpcRegistrationServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRegistrationServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRegistrationServiceStub(RegistrationServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRegistrationServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRegistrationServiceStub(RegistrationServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRegistrationServiceStub(RegistrationServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRegistrationServiceCallableFactory());
    }

    protected GrpcRegistrationServiceStub(RegistrationServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createNamespaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createNamespaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listNamespacesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listNamespacesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getNamespaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getNamespaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateNamespaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateNamespaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("namespace.name", String.valueOf(request.getNamespace().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteNamespaceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteNamespaceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("service.name", String.valueOf(request.getService().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listEndpointsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listEndpointsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("endpoint.name", String.valueOf(request.getEndpoint().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteEndpointTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteEndpointMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createNamespaceCallable = callableFactory.createUnaryCallable(createNamespaceTransportSettings, settings.createNamespaceSettings(), clientContext);
        this.listNamespacesCallable = callableFactory.createUnaryCallable(listNamespacesTransportSettings, settings.listNamespacesSettings(), clientContext);
        this.listNamespacesPagedCallable = callableFactory.createPagedCallable(listNamespacesTransportSettings, settings.listNamespacesSettings(), clientContext);
        this.getNamespaceCallable = callableFactory.createUnaryCallable(getNamespaceTransportSettings, settings.getNamespaceSettings(), clientContext);
        this.updateNamespaceCallable = callableFactory.createUnaryCallable(updateNamespaceTransportSettings, settings.updateNamespaceSettings(), clientContext);
        this.deleteNamespaceCallable = callableFactory.createUnaryCallable(deleteNamespaceTransportSettings, settings.deleteNamespaceSettings(), clientContext);
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.updateServiceCallable = callableFactory.createUnaryCallable(updateServiceTransportSettings, settings.updateServiceSettings(), clientContext);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.createEndpointCallable = callableFactory.createUnaryCallable(createEndpointTransportSettings, settings.createEndpointSettings(), clientContext);
        this.listEndpointsCallable = callableFactory.createUnaryCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.listEndpointsPagedCallable = callableFactory.createPagedCallable(listEndpointsTransportSettings, settings.listEndpointsSettings(), clientContext);
        this.getEndpointCallable = callableFactory.createUnaryCallable(getEndpointTransportSettings, settings.getEndpointSettings(), clientContext);
        this.updateEndpointCallable = callableFactory.createUnaryCallable(updateEndpointTransportSettings, settings.updateEndpointSettings(), clientContext);
        this.deleteEndpointCallable = callableFactory.createUnaryCallable(deleteEndpointTransportSettings, settings.deleteEndpointSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateNamespaceRequest, Namespace> createNamespaceCallable() {
        return this.createNamespaceCallable;
    }

    @Override
    public UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> listNamespacesCallable() {
        return this.listNamespacesCallable;
    }

    @Override
    public UnaryCallable<ListNamespacesRequest, RegistrationServiceClient.ListNamespacesPagedResponse> listNamespacesPagedCallable() {
        return this.listNamespacesPagedCallable;
    }

    @Override
    public UnaryCallable<GetNamespaceRequest, Namespace> getNamespaceCallable() {
        return this.getNamespaceCallable;
    }

    @Override
    public UnaryCallable<UpdateNamespaceRequest, Namespace> updateNamespaceCallable() {
        return this.updateNamespaceCallable;
    }

    @Override
    public UnaryCallable<DeleteNamespaceRequest, Empty> deleteNamespaceCallable() {
        return this.deleteNamespaceCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Service> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, RegistrationServiceClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<UpdateServiceRequest, Service> updateServiceCallable() {
        return this.updateServiceCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Empty> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public UnaryCallable<CreateEndpointRequest, Endpoint> createEndpointCallable() {
        return this.createEndpointCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.listEndpointsCallable;
    }

    @Override
    public UnaryCallable<ListEndpointsRequest, RegistrationServiceClient.ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.listEndpointsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.getEndpointCallable;
    }

    @Override
    public UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable() {
        return this.updateEndpointCallable;
    }

    @Override
    public UnaryCallable<DeleteEndpointRequest, Empty> deleteEndpointCallable() {
        return this.deleteEndpointCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, RegistrationServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

