/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.servicedirectory.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.servicedirectory.v1.CreateEndpointRequest;
import com.google.cloud.servicedirectory.v1.CreateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.CreateServiceRequest;
import com.google.cloud.servicedirectory.v1.DeleteEndpointRequest;
import com.google.cloud.servicedirectory.v1.DeleteNamespaceRequest;
import com.google.cloud.servicedirectory.v1.DeleteServiceRequest;
import com.google.cloud.servicedirectory.v1.Endpoint;
import com.google.cloud.servicedirectory.v1.EndpointName;
import com.google.cloud.servicedirectory.v1.GetEndpointRequest;
import com.google.cloud.servicedirectory.v1.GetNamespaceRequest;
import com.google.cloud.servicedirectory.v1.GetServiceRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsRequest;
import com.google.cloud.servicedirectory.v1.ListEndpointsResponse;
import com.google.cloud.servicedirectory.v1.ListNamespacesRequest;
import com.google.cloud.servicedirectory.v1.ListNamespacesResponse;
import com.google.cloud.servicedirectory.v1.ListServicesRequest;
import com.google.cloud.servicedirectory.v1.ListServicesResponse;
import com.google.cloud.servicedirectory.v1.LocationName;
import com.google.cloud.servicedirectory.v1.Namespace;
import com.google.cloud.servicedirectory.v1.NamespaceName;
import com.google.cloud.servicedirectory.v1.RegistrationServiceSettings;
import com.google.cloud.servicedirectory.v1.Service;
import com.google.cloud.servicedirectory.v1.ServiceName;
import com.google.cloud.servicedirectory.v1.UpdateEndpointRequest;
import com.google.cloud.servicedirectory.v1.UpdateNamespaceRequest;
import com.google.cloud.servicedirectory.v1.UpdateServiceRequest;
import com.google.cloud.servicedirectory.v1.stub.RegistrationServiceStub;
import com.google.cloud.servicedirectory.v1.stub.RegistrationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegistrationServiceClient
implements BackgroundResource {
    private final RegistrationServiceSettings settings;
    private final RegistrationServiceStub stub;

    public static final RegistrationServiceClient create() throws IOException {
        return RegistrationServiceClient.create(RegistrationServiceSettings.newBuilder().build());
    }

    public static final RegistrationServiceClient create(RegistrationServiceSettings settings) throws IOException {
        return new RegistrationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegistrationServiceClient create(RegistrationServiceStub stub) {
        return new RegistrationServiceClient(stub);
    }

    protected RegistrationServiceClient(RegistrationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegistrationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegistrationServiceClient(RegistrationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegistrationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegistrationServiceStub getStub() {
        return this.stub;
    }

    public final Namespace createNamespace(LocationName parent, Namespace namespace, String namespaceId) {
        CreateNamespaceRequest request = CreateNamespaceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNamespace(namespace).setNamespaceId(namespaceId).build();
        return this.createNamespace(request);
    }

    public final Namespace createNamespace(String parent, Namespace namespace, String namespaceId) {
        CreateNamespaceRequest request = CreateNamespaceRequest.newBuilder().setParent(parent).setNamespace(namespace).setNamespaceId(namespaceId).build();
        return this.createNamespace(request);
    }

    public final Namespace createNamespace(CreateNamespaceRequest request) {
        return (Namespace)this.createNamespaceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNamespaceRequest, Namespace> createNamespaceCallable() {
        return this.stub.createNamespaceCallable();
    }

    public final ListNamespacesPagedResponse listNamespaces(LocationName parent) {
        ListNamespacesRequest request = ListNamespacesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNamespaces(request);
    }

    public final ListNamespacesPagedResponse listNamespaces(String parent) {
        ListNamespacesRequest request = ListNamespacesRequest.newBuilder().setParent(parent).build();
        return this.listNamespaces(request);
    }

    public final ListNamespacesPagedResponse listNamespaces(ListNamespacesRequest request) {
        return (ListNamespacesPagedResponse)((Object)this.listNamespacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNamespacesRequest, ListNamespacesPagedResponse> listNamespacesPagedCallable() {
        return this.stub.listNamespacesPagedCallable();
    }

    public final UnaryCallable<ListNamespacesRequest, ListNamespacesResponse> listNamespacesCallable() {
        return this.stub.listNamespacesCallable();
    }

    public final Namespace getNamespace(NamespaceName name) {
        GetNamespaceRequest request = GetNamespaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNamespace(request);
    }

    public final Namespace getNamespace(String name) {
        GetNamespaceRequest request = GetNamespaceRequest.newBuilder().setName(name).build();
        return this.getNamespace(request);
    }

    public final Namespace getNamespace(GetNamespaceRequest request) {
        return (Namespace)this.getNamespaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetNamespaceRequest, Namespace> getNamespaceCallable() {
        return this.stub.getNamespaceCallable();
    }

    public final Namespace updateNamespace(Namespace namespace, FieldMask updateMask) {
        UpdateNamespaceRequest request = UpdateNamespaceRequest.newBuilder().setNamespace(namespace).setUpdateMask(updateMask).build();
        return this.updateNamespace(request);
    }

    public final Namespace updateNamespace(UpdateNamespaceRequest request) {
        return (Namespace)this.updateNamespaceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNamespaceRequest, Namespace> updateNamespaceCallable() {
        return this.stub.updateNamespaceCallable();
    }

    public final void deleteNamespace(NamespaceName name) {
        DeleteNamespaceRequest request = DeleteNamespaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteNamespace(request);
    }

    public final void deleteNamespace(String name) {
        DeleteNamespaceRequest request = DeleteNamespaceRequest.newBuilder().setName(name).build();
        this.deleteNamespace(request);
    }

    public final void deleteNamespace(DeleteNamespaceRequest request) {
        this.deleteNamespaceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNamespaceRequest, Empty> deleteNamespaceCallable() {
        return this.stub.deleteNamespaceCallable();
    }

    public final Service createService(NamespaceName parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).setServiceId(serviceId).build();
        return this.createService(request);
    }

    public final Service createService(String parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent).setService(service).setServiceId(serviceId).build();
        return this.createService(request);
    }

    public final Service createService(CreateServiceRequest request) {
        return (Service)this.createServiceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateServiceRequest, Service> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final ListServicesPagedResponse listServices(NamespaceName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(String parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final Service getService(ServiceName name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getService(request);
    }

    public final Service getService(String name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name).build();
        return this.getService(request);
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final Service updateService(Service service, FieldMask updateMask) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).setUpdateMask(updateMask).build();
        return this.updateService(request);
    }

    public final Service updateService(UpdateServiceRequest request) {
        return (Service)this.updateServiceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateServiceRequest, Service> updateServiceCallable() {
        return this.stub.updateServiceCallable();
    }

    public final void deleteService(ServiceName name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteService(request);
    }

    public final void deleteService(String name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name).build();
        this.deleteService(request);
    }

    public final void deleteService(DeleteServiceRequest request) {
        this.deleteServiceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteServiceRequest, Empty> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final Endpoint createEndpoint(ServiceName parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpoint(request);
    }

    public final Endpoint createEndpoint(String parent, Endpoint endpoint, String endpointId) {
        CreateEndpointRequest request = CreateEndpointRequest.newBuilder().setParent(parent).setEndpoint(endpoint).setEndpointId(endpointId).build();
        return this.createEndpoint(request);
    }

    public final Endpoint createEndpoint(CreateEndpointRequest request) {
        return (Endpoint)this.createEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<CreateEndpointRequest, Endpoint> createEndpointCallable() {
        return this.stub.createEndpointCallable();
    }

    public final ListEndpointsPagedResponse listEndpoints(ServiceName parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(String parent) {
        ListEndpointsRequest request = ListEndpointsRequest.newBuilder().setParent(parent).build();
        return this.listEndpoints(request);
    }

    public final ListEndpointsPagedResponse listEndpoints(ListEndpointsRequest request) {
        return (ListEndpointsPagedResponse)((Object)this.listEndpointsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsPagedResponse> listEndpointsPagedCallable() {
        return this.stub.listEndpointsPagedCallable();
    }

    public final UnaryCallable<ListEndpointsRequest, ListEndpointsResponse> listEndpointsCallable() {
        return this.stub.listEndpointsCallable();
    }

    public final Endpoint getEndpoint(EndpointName name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(String name) {
        GetEndpointRequest request = GetEndpointRequest.newBuilder().setName(name).build();
        return this.getEndpoint(request);
    }

    public final Endpoint getEndpoint(GetEndpointRequest request) {
        return (Endpoint)this.getEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<GetEndpointRequest, Endpoint> getEndpointCallable() {
        return this.stub.getEndpointCallable();
    }

    public final Endpoint updateEndpoint(Endpoint endpoint, FieldMask updateMask) {
        UpdateEndpointRequest request = UpdateEndpointRequest.newBuilder().setEndpoint(endpoint).setUpdateMask(updateMask).build();
        return this.updateEndpoint(request);
    }

    public final Endpoint updateEndpoint(UpdateEndpointRequest request) {
        return (Endpoint)this.updateEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateEndpointRequest, Endpoint> updateEndpointCallable() {
        return this.stub.updateEndpointCallable();
    }

    public final void deleteEndpoint(EndpointName name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteEndpoint(request);
    }

    public final void deleteEndpoint(String name) {
        DeleteEndpointRequest request = DeleteEndpointRequest.newBuilder().setName(name).build();
        this.deleteEndpoint(request);
    }

    public final void deleteEndpoint(DeleteEndpointRequest request) {
        this.deleteEndpointCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteEndpointRequest, Empty> deleteEndpointCallable() {
        return this.stub.deleteEndpointCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListEndpointsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        private ListEndpointsFixedSizeCollection(List<ListEndpointsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEndpointsFixedSizeCollection createEmptyCollection() {
            return new ListEndpointsFixedSizeCollection(null, 0);
        }

        protected ListEndpointsFixedSizeCollection createCollection(List<ListEndpointsPage> pages, int collectionSize) {
            return new ListEndpointsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEndpointsPage
    extends AbstractPage<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage> {
        private ListEndpointsPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            super(context, (Object)response);
        }

        private static ListEndpointsPage createEmptyPage() {
            return new ListEndpointsPage(null, null);
        }

        protected ListEndpointsPage createPage(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ListEndpointsResponse response) {
            return new ListEndpointsPage(context, response);
        }

        public ApiFuture<ListEndpointsPage> createPageAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEndpointsPagedResponse
    extends AbstractPagedListResponse<ListEndpointsRequest, ListEndpointsResponse, Endpoint, ListEndpointsPage, ListEndpointsFixedSizeCollection> {
        public static ApiFuture<ListEndpointsPagedResponse> createAsync(PageContext<ListEndpointsRequest, ListEndpointsResponse, Endpoint> context, ApiFuture<ListEndpointsResponse> futureResponse) {
            ApiFuture<ListEndpointsPage> futurePage = ListEndpointsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListEndpointsPage, ListEndpointsPagedResponse>(){

                public ListEndpointsPagedResponse apply(ListEndpointsPage input) {
                    return new ListEndpointsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListEndpointsPagedResponse(ListEndpointsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEndpointsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListServicesPage, ListServicesPagedResponse>(){

                public ListServicesPagedResponse apply(ListServicesPage input) {
                    return new ListServicesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNamespacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNamespacesRequest, ListNamespacesResponse, Namespace, ListNamespacesPage, ListNamespacesFixedSizeCollection> {
        private ListNamespacesFixedSizeCollection(List<ListNamespacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNamespacesFixedSizeCollection createEmptyCollection() {
            return new ListNamespacesFixedSizeCollection(null, 0);
        }

        protected ListNamespacesFixedSizeCollection createCollection(List<ListNamespacesPage> pages, int collectionSize) {
            return new ListNamespacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNamespacesPage
    extends AbstractPage<ListNamespacesRequest, ListNamespacesResponse, Namespace, ListNamespacesPage> {
        private ListNamespacesPage(PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace> context, ListNamespacesResponse response) {
            super(context, (Object)response);
        }

        private static ListNamespacesPage createEmptyPage() {
            return new ListNamespacesPage(null, null);
        }

        protected ListNamespacesPage createPage(PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace> context, ListNamespacesResponse response) {
            return new ListNamespacesPage(context, response);
        }

        public ApiFuture<ListNamespacesPage> createPageAsync(PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace> context, ApiFuture<ListNamespacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNamespacesPagedResponse
    extends AbstractPagedListResponse<ListNamespacesRequest, ListNamespacesResponse, Namespace, ListNamespacesPage, ListNamespacesFixedSizeCollection> {
        public static ApiFuture<ListNamespacesPagedResponse> createAsync(PageContext<ListNamespacesRequest, ListNamespacesResponse, Namespace> context, ApiFuture<ListNamespacesResponse> futureResponse) {
            ApiFuture<ListNamespacesPage> futurePage = ListNamespacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNamespacesPage, ListNamespacesPagedResponse>(){

                public ListNamespacesPagedResponse apply(ListNamespacesPage input) {
                    return new ListNamespacesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNamespacesPagedResponse(ListNamespacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNamespacesFixedSizeCollection.createEmptyCollection());
        }
    }
}

