/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.api.servicemanagement.v1.stub;

import com.google.api.Service;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicemanagement.v1.CreateServiceConfigRequest;
import com.google.api.servicemanagement.v1.CreateServiceRequest;
import com.google.api.servicemanagement.v1.CreateServiceRolloutRequest;
import com.google.api.servicemanagement.v1.DeleteServiceRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportResponse;
import com.google.api.servicemanagement.v1.GetServiceConfigRequest;
import com.google.api.servicemanagement.v1.GetServiceRequest;
import com.google.api.servicemanagement.v1.GetServiceRolloutRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsResponse;
import com.google.api.servicemanagement.v1.ListServiceRolloutsRequest;
import com.google.api.servicemanagement.v1.ListServiceRolloutsResponse;
import com.google.api.servicemanagement.v1.ListServicesRequest;
import com.google.api.servicemanagement.v1.ListServicesResponse;
import com.google.api.servicemanagement.v1.ManagedService;
import com.google.api.servicemanagement.v1.OperationMetadata;
import com.google.api.servicemanagement.v1.Rollout;
import com.google.api.servicemanagement.v1.SubmitConfigSourceRequest;
import com.google.api.servicemanagement.v1.SubmitConfigSourceResponse;
import com.google.api.servicemanagement.v1.UndeleteServiceRequest;
import com.google.api.servicemanagement.v1.UndeleteServiceResponse;
import com.google.cloud.api.servicemanagement.v1.ServiceManagerClient;
import com.google.cloud.api.servicemanagement.v1.stub.GrpcServiceManagerStub;
import com.google.cloud.api.servicemanagement.v1.stub.HttpJsonServiceManagerStub;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ServiceManagerStubSettings
extends StubSettings<ServiceManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/service.management").add((Object)"https://www.googleapis.com/auth/service.management.readonly").build();
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse> listServicesSettings;
    private final UnaryCallSettings<GetServiceRequest, ManagedService> getServiceSettings;
    private final UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings;
    private final OperationCallSettings<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationSettings;
    private final UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings;
    private final OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
    private final UnaryCallSettings<UndeleteServiceRequest, Operation> undeleteServiceSettings;
    private final OperationCallSettings<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationSettings;
    private final PagedCallSettings<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsSettings;
    private final UnaryCallSettings<GetServiceConfigRequest, Service> getServiceConfigSettings;
    private final UnaryCallSettings<CreateServiceConfigRequest, Service> createServiceConfigSettings;
    private final UnaryCallSettings<SubmitConfigSourceRequest, Operation> submitConfigSourceSettings;
    private final OperationCallSettings<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationSettings;
    private final PagedCallSettings<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsSettings;
    private final UnaryCallSettings<GetServiceRolloutRequest, Rollout> getServiceRolloutSettings;
    private final UnaryCallSettings<CreateServiceRolloutRequest, Operation> createServiceRolloutSettings;
    private final OperationCallSettings<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationSettings;
    private final UnaryCallSettings<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, ManagedService> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, ManagedService>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ManagedService> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListServiceConfigsRequest, ListServiceConfigsResponse, Service> LIST_SERVICE_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceConfigsRequest, ListServiceConfigsResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceConfigsRequest injectToken(ListServiceConfigsRequest payload, String token) {
            return ListServiceConfigsRequest.newBuilder((ListServiceConfigsRequest)payload).setPageToken(token).build();
        }

        public ListServiceConfigsRequest injectPageSize(ListServiceConfigsRequest payload, int pageSize) {
            return ListServiceConfigsRequest.newBuilder((ListServiceConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServiceConfigsResponse payload) {
            return payload.getServiceConfigsList() == null ? ImmutableList.of() : payload.getServiceConfigsList();
        }
    };
    private static final PagedListDescriptor<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout> LIST_SERVICE_ROLLOUTS_PAGE_STR_DESC = new PagedListDescriptor<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout>(){

        public String emptyToken() {
            return "";
        }

        public ListServiceRolloutsRequest injectToken(ListServiceRolloutsRequest payload, String token) {
            return ListServiceRolloutsRequest.newBuilder((ListServiceRolloutsRequest)payload).setPageToken(token).build();
        }

        public ListServiceRolloutsRequest injectPageSize(ListServiceRolloutsRequest payload, int pageSize) {
            return ListServiceRolloutsRequest.newBuilder((ListServiceRolloutsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServiceRolloutsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServiceRolloutsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Rollout> extractResources(ListServiceRolloutsResponse payload) {
            return payload.getRolloutsList() == null ? ImmutableList.of() : payload.getRolloutsList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse>(){

        public ApiFuture<ServiceManagerClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceManagerClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, ManagedService>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse> LIST_SERVICE_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse>(){

        public ApiFuture<ServiceManagerClient.ListServiceConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> callable, ListServiceConfigsRequest request, ApiCallContext context, ApiFuture<ListServiceConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceManagerClient.ListServiceConfigsPagedResponse.createAsync((PageContext<ListServiceConfigsRequest, ListServiceConfigsResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse> LIST_SERVICE_ROLLOUTS_PAGE_STR_FACT = new PagedListResponseFactory<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse>(){

        public ApiFuture<ServiceManagerClient.ListServiceRolloutsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> callable, ListServiceRolloutsRequest request, ApiCallContext context, ApiFuture<ListServiceRolloutsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICE_ROLLOUTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServiceManagerClient.ListServiceRolloutsPagedResponse.createAsync((PageContext<ListServiceRolloutsRequest, ListServiceRolloutsResponse, Rollout>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public UnaryCallSettings<GetServiceRequest, ManagedService> getServiceSettings() {
        return this.getServiceSettings;
    }

    public UnaryCallSettings<CreateServiceRequest, Operation> createServiceSettings() {
        return this.createServiceSettings;
    }

    public OperationCallSettings<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationSettings() {
        return this.createServiceOperationSettings;
    }

    public UnaryCallSettings<DeleteServiceRequest, Operation> deleteServiceSettings() {
        return this.deleteServiceSettings;
    }

    public OperationCallSettings<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
        return this.deleteServiceOperationSettings;
    }

    public UnaryCallSettings<UndeleteServiceRequest, Operation> undeleteServiceSettings() {
        return this.undeleteServiceSettings;
    }

    public OperationCallSettings<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationSettings() {
        return this.undeleteServiceOperationSettings;
    }

    public PagedCallSettings<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsSettings() {
        return this.listServiceConfigsSettings;
    }

    public UnaryCallSettings<GetServiceConfigRequest, Service> getServiceConfigSettings() {
        return this.getServiceConfigSettings;
    }

    public UnaryCallSettings<CreateServiceConfigRequest, Service> createServiceConfigSettings() {
        return this.createServiceConfigSettings;
    }

    public UnaryCallSettings<SubmitConfigSourceRequest, Operation> submitConfigSourceSettings() {
        return this.submitConfigSourceSettings;
    }

    public OperationCallSettings<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationSettings() {
        return this.submitConfigSourceOperationSettings;
    }

    public PagedCallSettings<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsSettings() {
        return this.listServiceRolloutsSettings;
    }

    public UnaryCallSettings<GetServiceRolloutRequest, Rollout> getServiceRolloutSettings() {
        return this.getServiceRolloutSettings;
    }

    public UnaryCallSettings<CreateServiceRolloutRequest, Operation> createServiceRolloutSettings() {
        return this.createServiceRolloutSettings;
    }

    public OperationCallSettings<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationSettings() {
        return this.createServiceRolloutOperationSettings;
    }

    public UnaryCallSettings<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportSettings() {
        return this.generateConfigReportSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ServiceManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServiceManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServiceManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ServiceManagerStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "servicemanagement";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "servicemanagement.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "servicemanagement.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServiceManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServiceManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServiceManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServiceManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.getServiceSettings = settingsBuilder.getServiceSettings().build();
        this.createServiceSettings = settingsBuilder.createServiceSettings().build();
        this.createServiceOperationSettings = settingsBuilder.createServiceOperationSettings().build();
        this.deleteServiceSettings = settingsBuilder.deleteServiceSettings().build();
        this.deleteServiceOperationSettings = settingsBuilder.deleteServiceOperationSettings().build();
        this.undeleteServiceSettings = settingsBuilder.undeleteServiceSettings().build();
        this.undeleteServiceOperationSettings = settingsBuilder.undeleteServiceOperationSettings().build();
        this.listServiceConfigsSettings = settingsBuilder.listServiceConfigsSettings().build();
        this.getServiceConfigSettings = settingsBuilder.getServiceConfigSettings().build();
        this.createServiceConfigSettings = settingsBuilder.createServiceConfigSettings().build();
        this.submitConfigSourceSettings = settingsBuilder.submitConfigSourceSettings().build();
        this.submitConfigSourceOperationSettings = settingsBuilder.submitConfigSourceOperationSettings().build();
        this.listServiceRolloutsSettings = settingsBuilder.listServiceRolloutsSettings().build();
        this.getServiceRolloutSettings = settingsBuilder.getServiceRolloutSettings().build();
        this.createServiceRolloutSettings = settingsBuilder.createServiceRolloutSettings().build();
        this.createServiceRolloutOperationSettings = settingsBuilder.createServiceRolloutOperationSettings().build();
        this.generateConfigReportSettings = settingsBuilder.generateConfigReportSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServiceManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse> listServicesSettings;
        private final UnaryCallSettings.Builder<GetServiceRequest, ManagedService> getServiceSettings;
        private final UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings;
        private final OperationCallSettings.Builder<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationSettings;
        private final UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings;
        private final OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings;
        private final UnaryCallSettings.Builder<UndeleteServiceRequest, Operation> undeleteServiceSettings;
        private final OperationCallSettings.Builder<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationSettings;
        private final PagedCallSettings.Builder<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsSettings;
        private final UnaryCallSettings.Builder<GetServiceConfigRequest, Service> getServiceConfigSettings;
        private final UnaryCallSettings.Builder<CreateServiceConfigRequest, Service> createServiceConfigSettings;
        private final UnaryCallSettings.Builder<SubmitConfigSourceRequest, Operation> submitConfigSourceSettings;
        private final OperationCallSettings.Builder<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationSettings;
        private final PagedCallSettings.Builder<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsSettings;
        private final UnaryCallSettings.Builder<GetServiceRolloutRequest, Rollout> getServiceRolloutSettings;
        private final UnaryCallSettings.Builder<CreateServiceRolloutRequest, Operation> createServiceRolloutSettings;
        private final OperationCallSettings.Builder<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationSettings;
        private final UnaryCallSettings.Builder<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.getServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceOperationSettings = OperationCallSettings.newBuilder();
            this.deleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServiceOperationSettings = OperationCallSettings.newBuilder();
            this.undeleteServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.undeleteServiceOperationSettings = OperationCallSettings.newBuilder();
            this.listServiceConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_CONFIGS_PAGE_STR_FACT);
            this.getServiceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.submitConfigSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.submitConfigSourceOperationSettings = OperationCallSettings.newBuilder();
            this.listServiceRolloutsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICE_ROLLOUTS_PAGE_STR_FACT);
            this.getServiceRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createServiceRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.generateConfigReportSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.createServiceSettings, this.deleteServiceSettings, this.undeleteServiceSettings, this.listServiceConfigsSettings, this.getServiceConfigSettings, this.createServiceConfigSettings, this.submitConfigSourceSettings, this.listServiceRolloutsSettings, this.getServiceRolloutSettings, this.createServiceRolloutSettings, (Object[])new UnaryCallSettings.Builder[]{this.generateConfigReportSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ServiceManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.getServiceSettings = settings.getServiceSettings.toBuilder();
            this.createServiceSettings = settings.createServiceSettings.toBuilder();
            this.createServiceOperationSettings = settings.createServiceOperationSettings.toBuilder();
            this.deleteServiceSettings = settings.deleteServiceSettings.toBuilder();
            this.deleteServiceOperationSettings = settings.deleteServiceOperationSettings.toBuilder();
            this.undeleteServiceSettings = settings.undeleteServiceSettings.toBuilder();
            this.undeleteServiceOperationSettings = settings.undeleteServiceOperationSettings.toBuilder();
            this.listServiceConfigsSettings = settings.listServiceConfigsSettings.toBuilder();
            this.getServiceConfigSettings = settings.getServiceConfigSettings.toBuilder();
            this.createServiceConfigSettings = settings.createServiceConfigSettings.toBuilder();
            this.submitConfigSourceSettings = settings.submitConfigSourceSettings.toBuilder();
            this.submitConfigSourceOperationSettings = settings.submitConfigSourceOperationSettings.toBuilder();
            this.listServiceRolloutsSettings = settings.listServiceRolloutsSettings.toBuilder();
            this.getServiceRolloutSettings = settings.getServiceRolloutSettings.toBuilder();
            this.createServiceRolloutSettings = settings.createServiceRolloutSettings.toBuilder();
            this.createServiceRolloutOperationSettings = settings.createServiceRolloutOperationSettings.toBuilder();
            this.generateConfigReportSettings = settings.generateConfigReportSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.getServiceSettings, this.createServiceSettings, this.deleteServiceSettings, this.undeleteServiceSettings, this.listServiceConfigsSettings, this.getServiceConfigSettings, this.createServiceConfigSettings, this.submitConfigSourceSettings, this.listServiceRolloutsSettings, this.getServiceRolloutSettings, this.createServiceRolloutSettings, (Object[])new UnaryCallSettings.Builder[]{this.generateConfigReportSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServiceManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServiceManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServiceManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServiceManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServiceManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServiceManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.undeleteServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServiceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServiceConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.submitConfigSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.listServiceRolloutsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getServiceRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServiceRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.generateConfigReportSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.createServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ManagedService.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.undeleteServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(UndeleteServiceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.submitConfigSourceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(SubmitConfigSourceResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createServiceRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Rollout.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, ServiceManagerClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRequest, ManagedService> getServiceSettings() {
            return this.getServiceSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceRequest, Operation> createServiceSettings() {
            return this.createServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationSettings() {
            return this.createServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteServiceRequest, Operation> deleteServiceSettings() {
            return this.deleteServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationSettings() {
            return this.deleteServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<UndeleteServiceRequest, Operation> undeleteServiceSettings() {
            return this.undeleteServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationSettings() {
            return this.undeleteServiceOperationSettings;
        }

        public PagedCallSettings.Builder<ListServiceConfigsRequest, ListServiceConfigsResponse, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsSettings() {
            return this.listServiceConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetServiceConfigRequest, Service> getServiceConfigSettings() {
            return this.getServiceConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceConfigRequest, Service> createServiceConfigSettings() {
            return this.createServiceConfigSettings;
        }

        public UnaryCallSettings.Builder<SubmitConfigSourceRequest, Operation> submitConfigSourceSettings() {
            return this.submitConfigSourceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationSettings() {
            return this.submitConfigSourceOperationSettings;
        }

        public PagedCallSettings.Builder<ListServiceRolloutsRequest, ListServiceRolloutsResponse, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsSettings() {
            return this.listServiceRolloutsSettings;
        }

        public UnaryCallSettings.Builder<GetServiceRolloutRequest, Rollout> getServiceRolloutSettings() {
            return this.getServiceRolloutSettings;
        }

        public UnaryCallSettings.Builder<CreateServiceRolloutRequest, Operation> createServiceRolloutSettings() {
            return this.createServiceRolloutSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationSettings() {
            return this.createServiceRolloutOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportSettings() {
            return this.generateConfigReportSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ServiceManagerStubSettings.getDefaultEndpoint();
        }

        public ServiceManagerStubSettings build() throws IOException {
            return new ServiceManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)10000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

