/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.api.servicemanagement.v1.stub;

import com.google.api.Service;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.servicemanagement.v1.CreateServiceConfigRequest;
import com.google.api.servicemanagement.v1.CreateServiceRequest;
import com.google.api.servicemanagement.v1.CreateServiceRolloutRequest;
import com.google.api.servicemanagement.v1.DeleteServiceRequest;
import com.google.api.servicemanagement.v1.DisableServiceRequest;
import com.google.api.servicemanagement.v1.DisableServiceResponse;
import com.google.api.servicemanagement.v1.EnableServiceRequest;
import com.google.api.servicemanagement.v1.EnableServiceResponse;
import com.google.api.servicemanagement.v1.GenerateConfigReportRequest;
import com.google.api.servicemanagement.v1.GenerateConfigReportResponse;
import com.google.api.servicemanagement.v1.GetServiceConfigRequest;
import com.google.api.servicemanagement.v1.GetServiceRequest;
import com.google.api.servicemanagement.v1.GetServiceRolloutRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsRequest;
import com.google.api.servicemanagement.v1.ListServiceConfigsResponse;
import com.google.api.servicemanagement.v1.ListServiceRolloutsRequest;
import com.google.api.servicemanagement.v1.ListServiceRolloutsResponse;
import com.google.api.servicemanagement.v1.ListServicesRequest;
import com.google.api.servicemanagement.v1.ListServicesResponse;
import com.google.api.servicemanagement.v1.ManagedService;
import com.google.api.servicemanagement.v1.OperationMetadata;
import com.google.api.servicemanagement.v1.Rollout;
import com.google.api.servicemanagement.v1.SubmitConfigSourceRequest;
import com.google.api.servicemanagement.v1.SubmitConfigSourceResponse;
import com.google.api.servicemanagement.v1.UndeleteServiceRequest;
import com.google.api.servicemanagement.v1.UndeleteServiceResponse;
import com.google.cloud.api.servicemanagement.v1.ServiceManagerClient;
import com.google.cloud.api.servicemanagement.v1.stub.GrpcServiceManagerCallableFactory;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStub;
import com.google.cloud.api.servicemanagement.v1.stub.ServiceManagerStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcServiceManagerStub
extends ServiceManagerStub {
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceRequest, ManagedService> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ManagedService.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateServiceRequest, Operation> createServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateService").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/DeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UndeleteServiceRequest, Operation> undeleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/UndeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServiceConfigs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServiceConfigsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServiceConfigsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceConfigRequest, Service> getServiceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetServiceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateServiceConfigRequest, Service> createServiceConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateServiceConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).build();
    private static final MethodDescriptor<SubmitConfigSourceRequest, Operation> submitConfigSourceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/SubmitConfigSource").setRequestMarshaller(ProtoUtils.marshaller((Message)SubmitConfigSourceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/ListServiceRollouts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServiceRolloutsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServiceRolloutsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceRolloutRequest, Rollout> getServiceRolloutMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GetServiceRollout").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRolloutRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Rollout.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateServiceRolloutRequest, Operation> createServiceRolloutMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/CreateServiceRollout").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceRolloutRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/GenerateConfigReport").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateConfigReportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateConfigReportResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<EnableServiceRequest, Operation> enableServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/EnableService").setRequestMarshaller(ProtoUtils.marshaller((Message)EnableServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DisableServiceRequest, Operation> disableServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.api.servicemanagement.v1.ServiceManager/DisableService").setRequestMarshaller(ProtoUtils.marshaller((Message)DisableServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServiceManagerClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, ManagedService> getServiceCallable;
    private final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable;
    private final OperationCallable<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable;
    private final UnaryCallable<UndeleteServiceRequest, Operation> undeleteServiceCallable;
    private final OperationCallable<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationCallable;
    private final UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsCallable;
    private final UnaryCallable<ListServiceConfigsRequest, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsPagedCallable;
    private final UnaryCallable<GetServiceConfigRequest, Service> getServiceConfigCallable;
    private final UnaryCallable<CreateServiceConfigRequest, Service> createServiceConfigCallable;
    private final UnaryCallable<SubmitConfigSourceRequest, Operation> submitConfigSourceCallable;
    private final OperationCallable<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationCallable;
    private final UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsCallable;
    private final UnaryCallable<ListServiceRolloutsRequest, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsPagedCallable;
    private final UnaryCallable<GetServiceRolloutRequest, Rollout> getServiceRolloutCallable;
    private final UnaryCallable<CreateServiceRolloutRequest, Operation> createServiceRolloutCallable;
    private final OperationCallable<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationCallable;
    private final UnaryCallable<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportCallable;
    private final UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable;
    private final OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable;
    private final UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable;
    private final OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcServiceManagerStub create(ServiceManagerStubSettings settings) throws IOException {
        return new GrpcServiceManagerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServiceManagerStub create(ClientContext clientContext) throws IOException {
        return new GrpcServiceManagerStub(ServiceManagerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServiceManagerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServiceManagerStub(ServiceManagerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServiceManagerStub(ServiceManagerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServiceManagerCallableFactory());
    }

    protected GrpcServiceManagerStub(ServiceManagerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings createServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).build();
        GrpcCallSettings deleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings undeleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeleteServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings listServiceConfigsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServiceConfigsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings getServiceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceConfigMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"config_id", (Object)String.valueOf(request.getConfigId()));
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings createServiceConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceConfigMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings submitConfigSourceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(submitConfigSourceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings listServiceRolloutsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServiceRolloutsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings getServiceRolloutTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceRolloutMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"rollout_id", (Object)String.valueOf(request.getRolloutId()));
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings createServiceRolloutTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceRolloutMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings generateConfigReportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateConfigReportMethodDescriptor).build();
        GrpcCallSettings enableServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enableServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        GrpcCallSettings disableServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(disableServiceMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"service_name", (Object)String.valueOf(request.getServiceName()));
            return params.build();
        }).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.createServiceOperationCallable = callableFactory.createOperationCallable(createServiceTransportSettings, settings.createServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.undeleteServiceCallable = callableFactory.createUnaryCallable(undeleteServiceTransportSettings, settings.undeleteServiceSettings(), clientContext);
        this.undeleteServiceOperationCallable = callableFactory.createOperationCallable(undeleteServiceTransportSettings, settings.undeleteServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listServiceConfigsCallable = callableFactory.createUnaryCallable(listServiceConfigsTransportSettings, settings.listServiceConfigsSettings(), clientContext);
        this.listServiceConfigsPagedCallable = callableFactory.createPagedCallable(listServiceConfigsTransportSettings, settings.listServiceConfigsSettings(), clientContext);
        this.getServiceConfigCallable = callableFactory.createUnaryCallable(getServiceConfigTransportSettings, settings.getServiceConfigSettings(), clientContext);
        this.createServiceConfigCallable = callableFactory.createUnaryCallable(createServiceConfigTransportSettings, settings.createServiceConfigSettings(), clientContext);
        this.submitConfigSourceCallable = callableFactory.createUnaryCallable(submitConfigSourceTransportSettings, settings.submitConfigSourceSettings(), clientContext);
        this.submitConfigSourceOperationCallable = callableFactory.createOperationCallable(submitConfigSourceTransportSettings, settings.submitConfigSourceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listServiceRolloutsCallable = callableFactory.createUnaryCallable(listServiceRolloutsTransportSettings, settings.listServiceRolloutsSettings(), clientContext);
        this.listServiceRolloutsPagedCallable = callableFactory.createPagedCallable(listServiceRolloutsTransportSettings, settings.listServiceRolloutsSettings(), clientContext);
        this.getServiceRolloutCallable = callableFactory.createUnaryCallable(getServiceRolloutTransportSettings, settings.getServiceRolloutSettings(), clientContext);
        this.createServiceRolloutCallable = callableFactory.createUnaryCallable(createServiceRolloutTransportSettings, settings.createServiceRolloutSettings(), clientContext);
        this.createServiceRolloutOperationCallable = callableFactory.createOperationCallable(createServiceRolloutTransportSettings, settings.createServiceRolloutOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.generateConfigReportCallable = callableFactory.createUnaryCallable(generateConfigReportTransportSettings, settings.generateConfigReportSettings(), clientContext);
        this.enableServiceCallable = callableFactory.createUnaryCallable(enableServiceTransportSettings, settings.enableServiceSettings(), clientContext);
        this.enableServiceOperationCallable = callableFactory.createOperationCallable(enableServiceTransportSettings, settings.enableServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.disableServiceCallable = callableFactory.createUnaryCallable(disableServiceTransportSettings, settings.disableServiceSettings(), clientContext);
        this.disableServiceOperationCallable = callableFactory.createOperationCallable(disableServiceTransportSettings, settings.disableServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServiceManagerClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, ManagedService> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public OperationCallable<CreateServiceRequest, ManagedService, OperationMetadata> createServiceOperationCallable() {
        return this.createServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<UndeleteServiceRequest, Operation> undeleteServiceCallable() {
        return this.undeleteServiceCallable;
    }

    @Override
    public OperationCallable<UndeleteServiceRequest, UndeleteServiceResponse, OperationMetadata> undeleteServiceOperationCallable() {
        return this.undeleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<ListServiceConfigsRequest, ListServiceConfigsResponse> listServiceConfigsCallable() {
        return this.listServiceConfigsCallable;
    }

    @Override
    public UnaryCallable<ListServiceConfigsRequest, ServiceManagerClient.ListServiceConfigsPagedResponse> listServiceConfigsPagedCallable() {
        return this.listServiceConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceConfigRequest, Service> getServiceConfigCallable() {
        return this.getServiceConfigCallable;
    }

    @Override
    public UnaryCallable<CreateServiceConfigRequest, Service> createServiceConfigCallable() {
        return this.createServiceConfigCallable;
    }

    @Override
    public UnaryCallable<SubmitConfigSourceRequest, Operation> submitConfigSourceCallable() {
        return this.submitConfigSourceCallable;
    }

    @Override
    public OperationCallable<SubmitConfigSourceRequest, SubmitConfigSourceResponse, OperationMetadata> submitConfigSourceOperationCallable() {
        return this.submitConfigSourceOperationCallable;
    }

    @Override
    public UnaryCallable<ListServiceRolloutsRequest, ListServiceRolloutsResponse> listServiceRolloutsCallable() {
        return this.listServiceRolloutsCallable;
    }

    @Override
    public UnaryCallable<ListServiceRolloutsRequest, ServiceManagerClient.ListServiceRolloutsPagedResponse> listServiceRolloutsPagedCallable() {
        return this.listServiceRolloutsPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRolloutRequest, Rollout> getServiceRolloutCallable() {
        return this.getServiceRolloutCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRolloutRequest, Operation> createServiceRolloutCallable() {
        return this.createServiceRolloutCallable;
    }

    @Override
    public OperationCallable<CreateServiceRolloutRequest, Rollout, OperationMetadata> createServiceRolloutOperationCallable() {
        return this.createServiceRolloutOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateConfigReportRequest, GenerateConfigReportResponse> generateConfigReportCallable() {
        return this.generateConfigReportCallable;
    }

    @Override
    public UnaryCallable<EnableServiceRequest, Operation> enableServiceCallable() {
        return this.enableServiceCallable;
    }

    @Override
    public OperationCallable<EnableServiceRequest, EnableServiceResponse, OperationMetadata> enableServiceOperationCallable() {
        return this.enableServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DisableServiceRequest, Operation> disableServiceCallable() {
        return this.disableServiceCallable;
    }

    @Override
    public OperationCallable<DisableServiceRequest, DisableServiceResponse, OperationMetadata> disableServiceOperationCallable() {
        return this.disableServiceOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

