/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securityposture.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.securityposture.v1.CreatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.CreatePostureRequest;
import com.google.cloud.securityposture.v1.DeletePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.DeletePostureRequest;
import com.google.cloud.securityposture.v1.ExtractPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureDeploymentRequest;
import com.google.cloud.securityposture.v1.GetPostureRequest;
import com.google.cloud.securityposture.v1.GetPostureTemplateRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsRequest;
import com.google.cloud.securityposture.v1.ListPostureDeploymentsResponse;
import com.google.cloud.securityposture.v1.ListPostureRevisionsRequest;
import com.google.cloud.securityposture.v1.ListPostureRevisionsResponse;
import com.google.cloud.securityposture.v1.ListPostureTemplatesRequest;
import com.google.cloud.securityposture.v1.ListPostureTemplatesResponse;
import com.google.cloud.securityposture.v1.ListPosturesRequest;
import com.google.cloud.securityposture.v1.ListPosturesResponse;
import com.google.cloud.securityposture.v1.OperationMetadata;
import com.google.cloud.securityposture.v1.OrganizationName;
import com.google.cloud.securityposture.v1.Posture;
import com.google.cloud.securityposture.v1.PostureDeployment;
import com.google.cloud.securityposture.v1.PostureDeploymentName;
import com.google.cloud.securityposture.v1.PostureName;
import com.google.cloud.securityposture.v1.PostureTemplate;
import com.google.cloud.securityposture.v1.PostureTemplateName;
import com.google.cloud.securityposture.v1.SecurityPostureSettings;
import com.google.cloud.securityposture.v1.UpdatePostureDeploymentRequest;
import com.google.cloud.securityposture.v1.UpdatePostureRequest;
import com.google.cloud.securityposture.v1.stub.SecurityPostureStub;
import com.google.cloud.securityposture.v1.stub.SecurityPostureStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecurityPostureClient
implements BackgroundResource {
    private final SecurityPostureSettings settings;
    private final SecurityPostureStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SecurityPostureClient create() throws IOException {
        return SecurityPostureClient.create(SecurityPostureSettings.newBuilder().build());
    }

    public static final SecurityPostureClient create(SecurityPostureSettings settings) throws IOException {
        return new SecurityPostureClient(settings);
    }

    public static final SecurityPostureClient create(SecurityPostureStub stub) {
        return new SecurityPostureClient(stub);
    }

    protected SecurityPostureClient(SecurityPostureSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityPostureStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SecurityPostureClient(SecurityPostureStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SecurityPostureSettings getSettings() {
        return this.settings;
    }

    public SecurityPostureStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListPosturesPagedResponse listPostures(OrganizationName parent) {
        ListPosturesRequest request = ListPosturesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPostures(request);
    }

    public final ListPosturesPagedResponse listPostures(String parent) {
        ListPosturesRequest request = ListPosturesRequest.newBuilder().setParent(parent).build();
        return this.listPostures(request);
    }

    public final ListPosturesPagedResponse listPostures(ListPosturesRequest request) {
        return (ListPosturesPagedResponse)((Object)this.listPosturesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPosturesRequest, ListPosturesPagedResponse> listPosturesPagedCallable() {
        return this.stub.listPosturesPagedCallable();
    }

    public final UnaryCallable<ListPosturesRequest, ListPosturesResponse> listPosturesCallable() {
        return this.stub.listPosturesCallable();
    }

    public final ListPostureRevisionsPagedResponse listPostureRevisions(ListPostureRevisionsRequest request) {
        return (ListPostureRevisionsPagedResponse)((Object)this.listPostureRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPostureRevisionsRequest, ListPostureRevisionsPagedResponse> listPostureRevisionsPagedCallable() {
        return this.stub.listPostureRevisionsPagedCallable();
    }

    public final UnaryCallable<ListPostureRevisionsRequest, ListPostureRevisionsResponse> listPostureRevisionsCallable() {
        return this.stub.listPostureRevisionsCallable();
    }

    public final Posture getPosture(PostureName name) {
        GetPostureRequest request = GetPostureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPosture(request);
    }

    public final Posture getPosture(String name) {
        GetPostureRequest request = GetPostureRequest.newBuilder().setName(name).build();
        return this.getPosture(request);
    }

    public final Posture getPosture(GetPostureRequest request) {
        return (Posture)this.getPostureCallable().call((Object)request);
    }

    public final UnaryCallable<GetPostureRequest, Posture> getPostureCallable() {
        return this.stub.getPostureCallable();
    }

    public final OperationFuture<Posture, OperationMetadata> createPostureAsync(OrganizationName parent, Posture posture, String postureId) {
        CreatePostureRequest request = CreatePostureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPosture(posture).setPostureId(postureId).build();
        return this.createPostureAsync(request);
    }

    public final OperationFuture<Posture, OperationMetadata> createPostureAsync(String parent, Posture posture, String postureId) {
        CreatePostureRequest request = CreatePostureRequest.newBuilder().setParent(parent).setPosture(posture).setPostureId(postureId).build();
        return this.createPostureAsync(request);
    }

    public final OperationFuture<Posture, OperationMetadata> createPostureAsync(CreatePostureRequest request) {
        return this.createPostureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePostureRequest, Posture, OperationMetadata> createPostureOperationCallable() {
        return this.stub.createPostureOperationCallable();
    }

    public final UnaryCallable<CreatePostureRequest, Operation> createPostureCallable() {
        return this.stub.createPostureCallable();
    }

    public final OperationFuture<Posture, OperationMetadata> updatePostureAsync(Posture posture, FieldMask updateMask) {
        UpdatePostureRequest request = UpdatePostureRequest.newBuilder().setPosture(posture).setUpdateMask(updateMask).build();
        return this.updatePostureAsync(request);
    }

    public final OperationFuture<Posture, OperationMetadata> updatePostureAsync(UpdatePostureRequest request) {
        return this.updatePostureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePostureRequest, Posture, OperationMetadata> updatePostureOperationCallable() {
        return this.stub.updatePostureOperationCallable();
    }

    public final UnaryCallable<UpdatePostureRequest, Operation> updatePostureCallable() {
        return this.stub.updatePostureCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureAsync(PostureName name) {
        DeletePostureRequest request = DeletePostureRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePostureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureAsync(String name) {
        DeletePostureRequest request = DeletePostureRequest.newBuilder().setName(name).build();
        return this.deletePostureAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureAsync(DeletePostureRequest request) {
        return this.deletePostureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePostureRequest, Empty, OperationMetadata> deletePostureOperationCallable() {
        return this.stub.deletePostureOperationCallable();
    }

    public final UnaryCallable<DeletePostureRequest, Operation> deletePostureCallable() {
        return this.stub.deletePostureCallable();
    }

    public final OperationFuture<Posture, OperationMetadata> extractPostureAsync(OrganizationName parent, String postureId, String workload) {
        ExtractPostureRequest request = ExtractPostureRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPostureId(postureId).setWorkload(workload).build();
        return this.extractPostureAsync(request);
    }

    public final OperationFuture<Posture, OperationMetadata> extractPostureAsync(String parent, String postureId, String workload) {
        ExtractPostureRequest request = ExtractPostureRequest.newBuilder().setParent(parent).setPostureId(postureId).setWorkload(workload).build();
        return this.extractPostureAsync(request);
    }

    public final OperationFuture<Posture, OperationMetadata> extractPostureAsync(ExtractPostureRequest request) {
        return this.extractPostureOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExtractPostureRequest, Posture, OperationMetadata> extractPostureOperationCallable() {
        return this.stub.extractPostureOperationCallable();
    }

    public final UnaryCallable<ExtractPostureRequest, Operation> extractPostureCallable() {
        return this.stub.extractPostureCallable();
    }

    public final ListPostureDeploymentsPagedResponse listPostureDeployments(OrganizationName parent) {
        ListPostureDeploymentsRequest request = ListPostureDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPostureDeployments(request);
    }

    public final ListPostureDeploymentsPagedResponse listPostureDeployments(String parent) {
        ListPostureDeploymentsRequest request = ListPostureDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listPostureDeployments(request);
    }

    public final ListPostureDeploymentsPagedResponse listPostureDeployments(ListPostureDeploymentsRequest request) {
        return (ListPostureDeploymentsPagedResponse)((Object)this.listPostureDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPostureDeploymentsRequest, ListPostureDeploymentsPagedResponse> listPostureDeploymentsPagedCallable() {
        return this.stub.listPostureDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse> listPostureDeploymentsCallable() {
        return this.stub.listPostureDeploymentsCallable();
    }

    public final PostureDeployment getPostureDeployment(PostureDeploymentName name) {
        GetPostureDeploymentRequest request = GetPostureDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPostureDeployment(request);
    }

    public final PostureDeployment getPostureDeployment(String name) {
        GetPostureDeploymentRequest request = GetPostureDeploymentRequest.newBuilder().setName(name).build();
        return this.getPostureDeployment(request);
    }

    public final PostureDeployment getPostureDeployment(GetPostureDeploymentRequest request) {
        return (PostureDeployment)this.getPostureDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetPostureDeploymentRequest, PostureDeployment> getPostureDeploymentCallable() {
        return this.stub.getPostureDeploymentCallable();
    }

    public final OperationFuture<PostureDeployment, OperationMetadata> createPostureDeploymentAsync(OrganizationName parent, PostureDeployment postureDeployment, String postureDeploymentId) {
        CreatePostureDeploymentRequest request = CreatePostureDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPostureDeployment(postureDeployment).setPostureDeploymentId(postureDeploymentId).build();
        return this.createPostureDeploymentAsync(request);
    }

    public final OperationFuture<PostureDeployment, OperationMetadata> createPostureDeploymentAsync(String parent, PostureDeployment postureDeployment, String postureDeploymentId) {
        CreatePostureDeploymentRequest request = CreatePostureDeploymentRequest.newBuilder().setParent(parent).setPostureDeployment(postureDeployment).setPostureDeploymentId(postureDeploymentId).build();
        return this.createPostureDeploymentAsync(request);
    }

    public final OperationFuture<PostureDeployment, OperationMetadata> createPostureDeploymentAsync(CreatePostureDeploymentRequest request) {
        return this.createPostureDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePostureDeploymentRequest, PostureDeployment, OperationMetadata> createPostureDeploymentOperationCallable() {
        return this.stub.createPostureDeploymentOperationCallable();
    }

    public final UnaryCallable<CreatePostureDeploymentRequest, Operation> createPostureDeploymentCallable() {
        return this.stub.createPostureDeploymentCallable();
    }

    public final OperationFuture<PostureDeployment, OperationMetadata> updatePostureDeploymentAsync(PostureDeployment postureDeployment, FieldMask updateMask) {
        UpdatePostureDeploymentRequest request = UpdatePostureDeploymentRequest.newBuilder().setPostureDeployment(postureDeployment).setUpdateMask(updateMask).build();
        return this.updatePostureDeploymentAsync(request);
    }

    public final OperationFuture<PostureDeployment, OperationMetadata> updatePostureDeploymentAsync(UpdatePostureDeploymentRequest request) {
        return this.updatePostureDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePostureDeploymentRequest, PostureDeployment, OperationMetadata> updatePostureDeploymentOperationCallable() {
        return this.stub.updatePostureDeploymentOperationCallable();
    }

    public final UnaryCallable<UpdatePostureDeploymentRequest, Operation> updatePostureDeploymentCallable() {
        return this.stub.updatePostureDeploymentCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureDeploymentAsync(PostureDeploymentName name) {
        DeletePostureDeploymentRequest request = DeletePostureDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deletePostureDeploymentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureDeploymentAsync(String name) {
        DeletePostureDeploymentRequest request = DeletePostureDeploymentRequest.newBuilder().setName(name).build();
        return this.deletePostureDeploymentAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deletePostureDeploymentAsync(DeletePostureDeploymentRequest request) {
        return this.deletePostureDeploymentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePostureDeploymentRequest, Empty, OperationMetadata> deletePostureDeploymentOperationCallable() {
        return this.stub.deletePostureDeploymentOperationCallable();
    }

    public final UnaryCallable<DeletePostureDeploymentRequest, Operation> deletePostureDeploymentCallable() {
        return this.stub.deletePostureDeploymentCallable();
    }

    public final ListPostureTemplatesPagedResponse listPostureTemplates(OrganizationName parent) {
        ListPostureTemplatesRequest request = ListPostureTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPostureTemplates(request);
    }

    public final ListPostureTemplatesPagedResponse listPostureTemplates(String parent) {
        ListPostureTemplatesRequest request = ListPostureTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listPostureTemplates(request);
    }

    public final ListPostureTemplatesPagedResponse listPostureTemplates(ListPostureTemplatesRequest request) {
        return (ListPostureTemplatesPagedResponse)((Object)this.listPostureTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPostureTemplatesRequest, ListPostureTemplatesPagedResponse> listPostureTemplatesPagedCallable() {
        return this.stub.listPostureTemplatesPagedCallable();
    }

    public final UnaryCallable<ListPostureTemplatesRequest, ListPostureTemplatesResponse> listPostureTemplatesCallable() {
        return this.stub.listPostureTemplatesCallable();
    }

    public final PostureTemplate getPostureTemplate(PostureTemplateName name) {
        GetPostureTemplateRequest request = GetPostureTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPostureTemplate(request);
    }

    public final PostureTemplate getPostureTemplate(String name) {
        GetPostureTemplateRequest request = GetPostureTemplateRequest.newBuilder().setName(name).build();
        return this.getPostureTemplate(request);
    }

    public final PostureTemplate getPostureTemplate(GetPostureTemplateRequest request) {
        return (PostureTemplate)this.getPostureTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetPostureTemplateRequest, PostureTemplate> getPostureTemplateCallable() {
        return this.stub.getPostureTemplateCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPostureTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate, ListPostureTemplatesPage, ListPostureTemplatesFixedSizeCollection> {
        private ListPostureTemplatesFixedSizeCollection(List<ListPostureTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPostureTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListPostureTemplatesFixedSizeCollection(null, 0);
        }

        protected ListPostureTemplatesFixedSizeCollection createCollection(List<ListPostureTemplatesPage> pages, int collectionSize) {
            return new ListPostureTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPostureTemplatesPage
    extends AbstractPage<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate, ListPostureTemplatesPage> {
        private ListPostureTemplatesPage(PageContext<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate> context, ListPostureTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListPostureTemplatesPage createEmptyPage() {
            return new ListPostureTemplatesPage(null, null);
        }

        protected ListPostureTemplatesPage createPage(PageContext<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate> context, ListPostureTemplatesResponse response) {
            return new ListPostureTemplatesPage(context, response);
        }

        public ApiFuture<ListPostureTemplatesPage> createPageAsync(PageContext<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate> context, ApiFuture<ListPostureTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPostureTemplatesPagedResponse
    extends AbstractPagedListResponse<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate, ListPostureTemplatesPage, ListPostureTemplatesFixedSizeCollection> {
        public static ApiFuture<ListPostureTemplatesPagedResponse> createAsync(PageContext<ListPostureTemplatesRequest, ListPostureTemplatesResponse, PostureTemplate> context, ApiFuture<ListPostureTemplatesResponse> futureResponse) {
            ApiFuture<ListPostureTemplatesPage> futurePage = ListPostureTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPostureTemplatesPagedResponse((ListPostureTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPostureTemplatesPagedResponse(ListPostureTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPostureTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPostureDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment, ListPostureDeploymentsPage, ListPostureDeploymentsFixedSizeCollection> {
        private ListPostureDeploymentsFixedSizeCollection(List<ListPostureDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPostureDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListPostureDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListPostureDeploymentsFixedSizeCollection createCollection(List<ListPostureDeploymentsPage> pages, int collectionSize) {
            return new ListPostureDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPostureDeploymentsPage
    extends AbstractPage<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment, ListPostureDeploymentsPage> {
        private ListPostureDeploymentsPage(PageContext<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment> context, ListPostureDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListPostureDeploymentsPage createEmptyPage() {
            return new ListPostureDeploymentsPage(null, null);
        }

        protected ListPostureDeploymentsPage createPage(PageContext<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment> context, ListPostureDeploymentsResponse response) {
            return new ListPostureDeploymentsPage(context, response);
        }

        public ApiFuture<ListPostureDeploymentsPage> createPageAsync(PageContext<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment> context, ApiFuture<ListPostureDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPostureDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment, ListPostureDeploymentsPage, ListPostureDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListPostureDeploymentsPagedResponse> createAsync(PageContext<ListPostureDeploymentsRequest, ListPostureDeploymentsResponse, PostureDeployment> context, ApiFuture<ListPostureDeploymentsResponse> futureResponse) {
            ApiFuture<ListPostureDeploymentsPage> futurePage = ListPostureDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPostureDeploymentsPagedResponse((ListPostureDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPostureDeploymentsPagedResponse(ListPostureDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPostureDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPostureRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture, ListPostureRevisionsPage, ListPostureRevisionsFixedSizeCollection> {
        private ListPostureRevisionsFixedSizeCollection(List<ListPostureRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPostureRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListPostureRevisionsFixedSizeCollection(null, 0);
        }

        protected ListPostureRevisionsFixedSizeCollection createCollection(List<ListPostureRevisionsPage> pages, int collectionSize) {
            return new ListPostureRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPostureRevisionsPage
    extends AbstractPage<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture, ListPostureRevisionsPage> {
        private ListPostureRevisionsPage(PageContext<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture> context, ListPostureRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListPostureRevisionsPage createEmptyPage() {
            return new ListPostureRevisionsPage(null, null);
        }

        protected ListPostureRevisionsPage createPage(PageContext<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture> context, ListPostureRevisionsResponse response) {
            return new ListPostureRevisionsPage(context, response);
        }

        public ApiFuture<ListPostureRevisionsPage> createPageAsync(PageContext<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture> context, ApiFuture<ListPostureRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPostureRevisionsPagedResponse
    extends AbstractPagedListResponse<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture, ListPostureRevisionsPage, ListPostureRevisionsFixedSizeCollection> {
        public static ApiFuture<ListPostureRevisionsPagedResponse> createAsync(PageContext<ListPostureRevisionsRequest, ListPostureRevisionsResponse, Posture> context, ApiFuture<ListPostureRevisionsResponse> futureResponse) {
            ApiFuture<ListPostureRevisionsPage> futurePage = ListPostureRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPostureRevisionsPagedResponse((ListPostureRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPostureRevisionsPagedResponse(ListPostureRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPostureRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPosturesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPosturesRequest, ListPosturesResponse, Posture, ListPosturesPage, ListPosturesFixedSizeCollection> {
        private ListPosturesFixedSizeCollection(List<ListPosturesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPosturesFixedSizeCollection createEmptyCollection() {
            return new ListPosturesFixedSizeCollection(null, 0);
        }

        protected ListPosturesFixedSizeCollection createCollection(List<ListPosturesPage> pages, int collectionSize) {
            return new ListPosturesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPosturesPage
    extends AbstractPage<ListPosturesRequest, ListPosturesResponse, Posture, ListPosturesPage> {
        private ListPosturesPage(PageContext<ListPosturesRequest, ListPosturesResponse, Posture> context, ListPosturesResponse response) {
            super(context, (Object)response);
        }

        private static ListPosturesPage createEmptyPage() {
            return new ListPosturesPage(null, null);
        }

        protected ListPosturesPage createPage(PageContext<ListPosturesRequest, ListPosturesResponse, Posture> context, ListPosturesResponse response) {
            return new ListPosturesPage(context, response);
        }

        public ApiFuture<ListPosturesPage> createPageAsync(PageContext<ListPosturesRequest, ListPosturesResponse, Posture> context, ApiFuture<ListPosturesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPosturesPagedResponse
    extends AbstractPagedListResponse<ListPosturesRequest, ListPosturesResponse, Posture, ListPosturesPage, ListPosturesFixedSizeCollection> {
        public static ApiFuture<ListPosturesPagedResponse> createAsync(PageContext<ListPosturesRequest, ListPosturesResponse, Posture> context, ApiFuture<ListPosturesResponse> futureResponse) {
            ApiFuture<ListPosturesPage> futurePage = ListPosturesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPosturesPagedResponse((ListPosturesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPosturesPagedResponse(ListPosturesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPosturesFixedSizeCollection.createEmptyCollection());
        }
    }
}

