/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securitycenter.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.securitycenter.v1.CreateFindingRequest;
import com.google.cloud.securitycenter.v1.CreateNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.CreateSourceRequest;
import com.google.cloud.securitycenter.v1.DeleteNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.Finding;
import com.google.cloud.securitycenter.v1.FindingName;
import com.google.cloud.securitycenter.v1.GetNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.GetOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1.GetSourceRequest;
import com.google.cloud.securitycenter.v1.GroupAssetsRequest;
import com.google.cloud.securitycenter.v1.GroupAssetsResponse;
import com.google.cloud.securitycenter.v1.GroupFindingsRequest;
import com.google.cloud.securitycenter.v1.GroupFindingsResponse;
import com.google.cloud.securitycenter.v1.GroupResult;
import com.google.cloud.securitycenter.v1.ListAssetsRequest;
import com.google.cloud.securitycenter.v1.ListAssetsResponse;
import com.google.cloud.securitycenter.v1.ListFindingsRequest;
import com.google.cloud.securitycenter.v1.ListFindingsResponse;
import com.google.cloud.securitycenter.v1.ListNotificationConfigsRequest;
import com.google.cloud.securitycenter.v1.ListNotificationConfigsResponse;
import com.google.cloud.securitycenter.v1.ListSourcesRequest;
import com.google.cloud.securitycenter.v1.ListSourcesResponse;
import com.google.cloud.securitycenter.v1.NotificationConfig;
import com.google.cloud.securitycenter.v1.NotificationConfigName;
import com.google.cloud.securitycenter.v1.OrganizationName;
import com.google.cloud.securitycenter.v1.OrganizationSettings;
import com.google.cloud.securitycenter.v1.OrganizationSettingsName;
import com.google.cloud.securitycenter.v1.RunAssetDiscoveryRequest;
import com.google.cloud.securitycenter.v1.RunAssetDiscoveryResponse;
import com.google.cloud.securitycenter.v1.SecurityCenterSettings;
import com.google.cloud.securitycenter.v1.SecurityMarks;
import com.google.cloud.securitycenter.v1.SetFindingStateRequest;
import com.google.cloud.securitycenter.v1.Source;
import com.google.cloud.securitycenter.v1.SourceName;
import com.google.cloud.securitycenter.v1.UpdateFindingRequest;
import com.google.cloud.securitycenter.v1.UpdateNotificationConfigRequest;
import com.google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest;
import com.google.cloud.securitycenter.v1.UpdateSecurityMarksRequest;
import com.google.cloud.securitycenter.v1.UpdateSourceRequest;
import com.google.cloud.securitycenter.v1.stub.SecurityCenterStub;
import com.google.cloud.securitycenter.v1.stub.SecurityCenterStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecurityCenterClient
implements BackgroundResource {
    private final SecurityCenterSettings settings;
    private final SecurityCenterStub stub;
    private final OperationsClient operationsClient;

    public static final SecurityCenterClient create() throws IOException {
        return SecurityCenterClient.create(SecurityCenterSettings.newBuilder().build());
    }

    public static final SecurityCenterClient create(SecurityCenterSettings settings) throws IOException {
        return new SecurityCenterClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SecurityCenterClient create(SecurityCenterStub stub) {
        return new SecurityCenterClient(stub);
    }

    protected SecurityCenterClient(SecurityCenterSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityCenterStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SecurityCenterClient(SecurityCenterStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final SecurityCenterSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityCenterStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Source createSource(OrganizationName parent, Source source) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSource(source).build();
        return this.createSource(request);
    }

    public final Source createSource(String parent, Source source) {
        CreateSourceRequest request = CreateSourceRequest.newBuilder().setParent(parent).setSource(source).build();
        return this.createSource(request);
    }

    public final Source createSource(CreateSourceRequest request) {
        return (Source)this.createSourceCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSourceRequest, Source> createSourceCallable() {
        return this.stub.createSourceCallable();
    }

    public final Finding createFinding(SourceName parent, String findingId, Finding finding) {
        CreateFindingRequest request = CreateFindingRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFindingId(findingId).setFinding(finding).build();
        return this.createFinding(request);
    }

    public final Finding createFinding(String parent, String findingId, Finding finding) {
        CreateFindingRequest request = CreateFindingRequest.newBuilder().setParent(parent).setFindingId(findingId).setFinding(finding).build();
        return this.createFinding(request);
    }

    public final Finding createFinding(CreateFindingRequest request) {
        return (Finding)this.createFindingCallable().call((Object)request);
    }

    public final UnaryCallable<CreateFindingRequest, Finding> createFindingCallable() {
        return this.stub.createFindingCallable();
    }

    public final NotificationConfig createNotificationConfig(OrganizationName parent, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(String parent, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(OrganizationName parent, String configId, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setConfigId(configId).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(String parent, String configId, NotificationConfig notificationConfig) {
        CreateNotificationConfigRequest request = CreateNotificationConfigRequest.newBuilder().setParent(parent).setConfigId(configId).setNotificationConfig(notificationConfig).build();
        return this.createNotificationConfig(request);
    }

    public final NotificationConfig createNotificationConfig(CreateNotificationConfigRequest request) {
        return (NotificationConfig)this.createNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateNotificationConfigRequest, NotificationConfig> createNotificationConfigCallable() {
        return this.stub.createNotificationConfigCallable();
    }

    public final void deleteNotificationConfig(NotificationConfigName name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteNotificationConfig(request);
    }

    public final void deleteNotificationConfig(String name) {
        DeleteNotificationConfigRequest request = DeleteNotificationConfigRequest.newBuilder().setName(name).build();
        this.deleteNotificationConfig(request);
    }

    public final void deleteNotificationConfig(DeleteNotificationConfigRequest request) {
        this.deleteNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteNotificationConfigRequest, Empty> deleteNotificationConfigCallable() {
        return this.stub.deleteNotificationConfigCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final NotificationConfig getNotificationConfig(NotificationConfigName name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNotificationConfig(request);
    }

    public final NotificationConfig getNotificationConfig(String name) {
        GetNotificationConfigRequest request = GetNotificationConfigRequest.newBuilder().setName(name).build();
        return this.getNotificationConfig(request);
    }

    public final NotificationConfig getNotificationConfig(GetNotificationConfigRequest request) {
        return (NotificationConfig)this.getNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetNotificationConfigRequest, NotificationConfig> getNotificationConfigCallable() {
        return this.stub.getNotificationConfigCallable();
    }

    public final OrganizationSettings getOrganizationSettings(OrganizationSettingsName name) {
        GetOrganizationSettingsRequest request = GetOrganizationSettingsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrganizationSettings(request);
    }

    public final OrganizationSettings getOrganizationSettings(String name) {
        GetOrganizationSettingsRequest request = GetOrganizationSettingsRequest.newBuilder().setName(name).build();
        return this.getOrganizationSettings(request);
    }

    public final OrganizationSettings getOrganizationSettings(GetOrganizationSettingsRequest request) {
        return (OrganizationSettings)this.getOrganizationSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrganizationSettingsRequest, OrganizationSettings> getOrganizationSettingsCallable() {
        return this.stub.getOrganizationSettingsCallable();
    }

    public final Source getSource(SourceName name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSource(request);
    }

    public final Source getSource(String name) {
        GetSourceRequest request = GetSourceRequest.newBuilder().setName(name).build();
        return this.getSource(request);
    }

    public final Source getSource(GetSourceRequest request) {
        return (Source)this.getSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetSourceRequest, Source> getSourceCallable() {
        return this.stub.getSourceCallable();
    }

    public final GroupAssetsPagedResponse groupAssets(GroupAssetsRequest request) {
        return (GroupAssetsPagedResponse)((Object)this.groupAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GroupAssetsRequest, GroupAssetsPagedResponse> groupAssetsPagedCallable() {
        return this.stub.groupAssetsPagedCallable();
    }

    public final UnaryCallable<GroupAssetsRequest, GroupAssetsResponse> groupAssetsCallable() {
        return this.stub.groupAssetsCallable();
    }

    public final GroupFindingsPagedResponse groupFindings(SourceName parent, String groupBy) {
        GroupFindingsRequest request = GroupFindingsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGroupBy(groupBy).build();
        return this.groupFindings(request);
    }

    public final GroupFindingsPagedResponse groupFindings(String parent, String groupBy) {
        GroupFindingsRequest request = GroupFindingsRequest.newBuilder().setParent(parent).setGroupBy(groupBy).build();
        return this.groupFindings(request);
    }

    public final GroupFindingsPagedResponse groupFindings(GroupFindingsRequest request) {
        return (GroupFindingsPagedResponse)((Object)this.groupFindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<GroupFindingsRequest, GroupFindingsPagedResponse> groupFindingsPagedCallable() {
        return this.stub.groupFindingsPagedCallable();
    }

    public final UnaryCallable<GroupFindingsRequest, GroupFindingsResponse> groupFindingsCallable() {
        return this.stub.groupFindingsCallable();
    }

    public final ListAssetsPagedResponse listAssets(ListAssetsRequest request) {
        return (ListAssetsPagedResponse)((Object)this.listAssetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsPagedResponse> listAssetsPagedCallable() {
        return this.stub.listAssetsPagedCallable();
    }

    public final UnaryCallable<ListAssetsRequest, ListAssetsResponse> listAssetsCallable() {
        return this.stub.listAssetsCallable();
    }

    public final ListFindingsPagedResponse listFindings(ListFindingsRequest request) {
        return (ListFindingsPagedResponse)((Object)this.listFindingsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsPagedResponse> listFindingsPagedCallable() {
        return this.stub.listFindingsPagedCallable();
    }

    public final UnaryCallable<ListFindingsRequest, ListFindingsResponse> listFindingsCallable() {
        return this.stub.listFindingsCallable();
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(OrganizationName parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(String parent) {
        ListNotificationConfigsRequest request = ListNotificationConfigsRequest.newBuilder().setParent(parent).build();
        return this.listNotificationConfigs(request);
    }

    public final ListNotificationConfigsPagedResponse listNotificationConfigs(ListNotificationConfigsRequest request) {
        return (ListNotificationConfigsPagedResponse)((Object)this.listNotificationConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsPagedResponse> listNotificationConfigsPagedCallable() {
        return this.stub.listNotificationConfigsPagedCallable();
    }

    public final UnaryCallable<ListNotificationConfigsRequest, ListNotificationConfigsResponse> listNotificationConfigsCallable() {
        return this.stub.listNotificationConfigsCallable();
    }

    public final ListSourcesPagedResponse listSources(OrganizationName parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(String parent) {
        ListSourcesRequest request = ListSourcesRequest.newBuilder().setParent(parent).build();
        return this.listSources(request);
    }

    public final ListSourcesPagedResponse listSources(ListSourcesRequest request) {
        return (ListSourcesPagedResponse)((Object)this.listSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesPagedResponse> listSourcesPagedCallable() {
        return this.stub.listSourcesPagedCallable();
    }

    public final UnaryCallable<ListSourcesRequest, ListSourcesResponse> listSourcesCallable() {
        return this.stub.listSourcesCallable();
    }

    public final OperationFuture<RunAssetDiscoveryResponse, Empty> runAssetDiscoveryAsync(OrganizationName parent) {
        RunAssetDiscoveryRequest request = RunAssetDiscoveryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.runAssetDiscoveryAsync(request);
    }

    public final OperationFuture<RunAssetDiscoveryResponse, Empty> runAssetDiscoveryAsync(String parent) {
        RunAssetDiscoveryRequest request = RunAssetDiscoveryRequest.newBuilder().setParent(parent).build();
        return this.runAssetDiscoveryAsync(request);
    }

    public final OperationFuture<RunAssetDiscoveryResponse, Empty> runAssetDiscoveryAsync(RunAssetDiscoveryRequest request) {
        return this.runAssetDiscoveryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunAssetDiscoveryRequest, RunAssetDiscoveryResponse, Empty> runAssetDiscoveryOperationCallable() {
        return this.stub.runAssetDiscoveryOperationCallable();
    }

    public final UnaryCallable<RunAssetDiscoveryRequest, Operation> runAssetDiscoveryCallable() {
        return this.stub.runAssetDiscoveryCallable();
    }

    public final Finding setFindingState(FindingName name, Finding.State state, Timestamp startTime) {
        SetFindingStateRequest request = SetFindingStateRequest.newBuilder().setName(name == null ? null : name.toString()).setState(state).setStartTime(startTime).build();
        return this.setFindingState(request);
    }

    public final Finding setFindingState(String name, Finding.State state, Timestamp startTime) {
        SetFindingStateRequest request = SetFindingStateRequest.newBuilder().setName(name).setState(state).setStartTime(startTime).build();
        return this.setFindingState(request);
    }

    public final Finding setFindingState(SetFindingStateRequest request) {
        return (Finding)this.setFindingStateCallable().call((Object)request);
    }

    public final UnaryCallable<SetFindingStateRequest, Finding> setFindingStateCallable() {
        return this.stub.setFindingStateCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final Finding updateFinding(Finding finding) {
        UpdateFindingRequest request = UpdateFindingRequest.newBuilder().setFinding(finding).build();
        return this.updateFinding(request);
    }

    public final Finding updateFinding(UpdateFindingRequest request) {
        return (Finding)this.updateFindingCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateFindingRequest, Finding> updateFindingCallable() {
        return this.stub.updateFindingCallable();
    }

    public final NotificationConfig updateNotificationConfig(NotificationConfig notificationConfig) {
        UpdateNotificationConfigRequest request = UpdateNotificationConfigRequest.newBuilder().setNotificationConfig(notificationConfig).build();
        return this.updateNotificationConfig(request);
    }

    public final NotificationConfig updateNotificationConfig(NotificationConfig notificationConfig, FieldMask updateMask) {
        UpdateNotificationConfigRequest request = UpdateNotificationConfigRequest.newBuilder().setNotificationConfig(notificationConfig).setUpdateMask(updateMask).build();
        return this.updateNotificationConfig(request);
    }

    public final NotificationConfig updateNotificationConfig(UpdateNotificationConfigRequest request) {
        return (NotificationConfig)this.updateNotificationConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateNotificationConfigRequest, NotificationConfig> updateNotificationConfigCallable() {
        return this.stub.updateNotificationConfigCallable();
    }

    public final OrganizationSettings updateOrganizationSettings(OrganizationSettings organizationSettings) {
        UpdateOrganizationSettingsRequest request = UpdateOrganizationSettingsRequest.newBuilder().setOrganizationSettings(organizationSettings).build();
        return this.updateOrganizationSettings(request);
    }

    public final OrganizationSettings updateOrganizationSettings(UpdateOrganizationSettingsRequest request) {
        return (OrganizationSettings)this.updateOrganizationSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateOrganizationSettingsRequest, OrganizationSettings> updateOrganizationSettingsCallable() {
        return this.stub.updateOrganizationSettingsCallable();
    }

    public final Source updateSource(Source source) {
        UpdateSourceRequest request = UpdateSourceRequest.newBuilder().setSource(source).build();
        return this.updateSource(request);
    }

    public final Source updateSource(UpdateSourceRequest request) {
        return (Source)this.updateSourceCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSourceRequest, Source> updateSourceCallable() {
        return this.stub.updateSourceCallable();
    }

    public final SecurityMarks updateSecurityMarks(SecurityMarks securityMarks) {
        UpdateSecurityMarksRequest request = UpdateSecurityMarksRequest.newBuilder().setSecurityMarks(securityMarks).build();
        return this.updateSecurityMarks(request);
    }

    public final SecurityMarks updateSecurityMarks(UpdateSecurityMarksRequest request) {
        return (SecurityMarks)this.updateSecurityMarksCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSecurityMarksRequest, SecurityMarks> updateSecurityMarksCallable() {
        return this.stub.updateSecurityMarksCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        private ListSourcesFixedSizeCollection(List<ListSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSourcesFixedSizeCollection createEmptyCollection() {
            return new ListSourcesFixedSizeCollection(null, 0);
        }

        protected ListSourcesFixedSizeCollection createCollection(List<ListSourcesPage> pages, int collectionSize) {
            return new ListSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSourcesPage
    extends AbstractPage<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage> {
        private ListSourcesPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListSourcesPage createEmptyPage() {
            return new ListSourcesPage(null, null);
        }

        protected ListSourcesPage createPage(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ListSourcesResponse response) {
            return new ListSourcesPage(context, response);
        }

        public ApiFuture<ListSourcesPage> createPageAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSourcesPagedResponse
    extends AbstractPagedListResponse<ListSourcesRequest, ListSourcesResponse, Source, ListSourcesPage, ListSourcesFixedSizeCollection> {
        public static ApiFuture<ListSourcesPagedResponse> createAsync(PageContext<ListSourcesRequest, ListSourcesResponse, Source> context, ApiFuture<ListSourcesResponse> futureResponse) {
            ApiFuture<ListSourcesPage> futurePage = ListSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListSourcesPage, ListSourcesPagedResponse>(){

                public ListSourcesPagedResponse apply(ListSourcesPage input) {
                    return new ListSourcesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListSourcesPagedResponse(ListSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListNotificationConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        private ListNotificationConfigsFixedSizeCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListNotificationConfigsFixedSizeCollection createEmptyCollection() {
            return new ListNotificationConfigsFixedSizeCollection(null, 0);
        }

        protected ListNotificationConfigsFixedSizeCollection createCollection(List<ListNotificationConfigsPage> pages, int collectionSize) {
            return new ListNotificationConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListNotificationConfigsPage
    extends AbstractPage<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage> {
        private ListNotificationConfigsPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListNotificationConfigsPage createEmptyPage() {
            return new ListNotificationConfigsPage(null, null);
        }

        protected ListNotificationConfigsPage createPage(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ListNotificationConfigsResponse response) {
            return new ListNotificationConfigsPage(context, response);
        }

        public ApiFuture<ListNotificationConfigsPage> createPageAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListNotificationConfigsPagedResponse
    extends AbstractPagedListResponse<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig, ListNotificationConfigsPage, ListNotificationConfigsFixedSizeCollection> {
        public static ApiFuture<ListNotificationConfigsPagedResponse> createAsync(PageContext<ListNotificationConfigsRequest, ListNotificationConfigsResponse, NotificationConfig> context, ApiFuture<ListNotificationConfigsResponse> futureResponse) {
            ApiFuture<ListNotificationConfigsPage> futurePage = ListNotificationConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListNotificationConfigsPage, ListNotificationConfigsPagedResponse>(){

                public ListNotificationConfigsPagedResponse apply(ListNotificationConfigsPage input) {
                    return new ListNotificationConfigsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListNotificationConfigsPagedResponse(ListNotificationConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListNotificationConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage, ListFindingsFixedSizeCollection> {
        private ListFindingsFixedSizeCollection(List<ListFindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFindingsFixedSizeCollection createEmptyCollection() {
            return new ListFindingsFixedSizeCollection(null, 0);
        }

        protected ListFindingsFixedSizeCollection createCollection(List<ListFindingsPage> pages, int collectionSize) {
            return new ListFindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFindingsPage
    extends AbstractPage<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage> {
        private ListFindingsPage(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ListFindingsResponse response) {
            super(context, (Object)response);
        }

        private static ListFindingsPage createEmptyPage() {
            return new ListFindingsPage(null, null);
        }

        protected ListFindingsPage createPage(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ListFindingsResponse response) {
            return new ListFindingsPage(context, response);
        }

        public ApiFuture<ListFindingsPage> createPageAsync(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ApiFuture<ListFindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFindingsPagedResponse
    extends AbstractPagedListResponse<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult, ListFindingsPage, ListFindingsFixedSizeCollection> {
        public static ApiFuture<ListFindingsPagedResponse> createAsync(PageContext<ListFindingsRequest, ListFindingsResponse, ListFindingsResponse.ListFindingsResult> context, ApiFuture<ListFindingsResponse> futureResponse) {
            ApiFuture<ListFindingsPage> futurePage = ListFindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFindingsPage, ListFindingsPagedResponse>(){

                public ListFindingsPagedResponse apply(ListFindingsPage input) {
                    return new ListFindingsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFindingsPagedResponse(ListFindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult, ListAssetsPage, ListAssetsFixedSizeCollection> {
        private ListAssetsFixedSizeCollection(List<ListAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssetsFixedSizeCollection createEmptyCollection() {
            return new ListAssetsFixedSizeCollection(null, 0);
        }

        protected ListAssetsFixedSizeCollection createCollection(List<ListAssetsPage> pages, int collectionSize) {
            return new ListAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssetsPage
    extends AbstractPage<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult, ListAssetsPage> {
        private ListAssetsPage(PageContext<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult> context, ListAssetsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssetsPage createEmptyPage() {
            return new ListAssetsPage(null, null);
        }

        protected ListAssetsPage createPage(PageContext<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult> context, ListAssetsResponse response) {
            return new ListAssetsPage(context, response);
        }

        public ApiFuture<ListAssetsPage> createPageAsync(PageContext<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult> context, ApiFuture<ListAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssetsPagedResponse
    extends AbstractPagedListResponse<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult, ListAssetsPage, ListAssetsFixedSizeCollection> {
        public static ApiFuture<ListAssetsPagedResponse> createAsync(PageContext<ListAssetsRequest, ListAssetsResponse, ListAssetsResponse.ListAssetsResult> context, ApiFuture<ListAssetsResponse> futureResponse) {
            ApiFuture<ListAssetsPage> futurePage = ListAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAssetsPage, ListAssetsPagedResponse>(){

                public ListAssetsPagedResponse apply(ListAssetsPage input) {
                    return new ListAssetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAssetsPagedResponse(ListAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GroupFindingsFixedSizeCollection
    extends AbstractFixedSizeCollection<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage, GroupFindingsFixedSizeCollection> {
        private GroupFindingsFixedSizeCollection(List<GroupFindingsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GroupFindingsFixedSizeCollection createEmptyCollection() {
            return new GroupFindingsFixedSizeCollection(null, 0);
        }

        protected GroupFindingsFixedSizeCollection createCollection(List<GroupFindingsPage> pages, int collectionSize) {
            return new GroupFindingsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GroupFindingsPage
    extends AbstractPage<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage> {
        private GroupFindingsPage(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, GroupFindingsResponse response) {
            super(context, (Object)response);
        }

        private static GroupFindingsPage createEmptyPage() {
            return new GroupFindingsPage(null, null);
        }

        protected GroupFindingsPage createPage(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, GroupFindingsResponse response) {
            return new GroupFindingsPage(context, response);
        }

        public ApiFuture<GroupFindingsPage> createPageAsync(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, ApiFuture<GroupFindingsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GroupFindingsPagedResponse
    extends AbstractPagedListResponse<GroupFindingsRequest, GroupFindingsResponse, GroupResult, GroupFindingsPage, GroupFindingsFixedSizeCollection> {
        public static ApiFuture<GroupFindingsPagedResponse> createAsync(PageContext<GroupFindingsRequest, GroupFindingsResponse, GroupResult> context, ApiFuture<GroupFindingsResponse> futureResponse) {
            ApiFuture<GroupFindingsPage> futurePage = GroupFindingsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<GroupFindingsPage, GroupFindingsPagedResponse>(){

                public GroupFindingsPagedResponse apply(GroupFindingsPage input) {
                    return new GroupFindingsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private GroupFindingsPagedResponse(GroupFindingsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GroupFindingsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class GroupAssetsFixedSizeCollection
    extends AbstractFixedSizeCollection<GroupAssetsRequest, GroupAssetsResponse, GroupResult, GroupAssetsPage, GroupAssetsFixedSizeCollection> {
        private GroupAssetsFixedSizeCollection(List<GroupAssetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static GroupAssetsFixedSizeCollection createEmptyCollection() {
            return new GroupAssetsFixedSizeCollection(null, 0);
        }

        protected GroupAssetsFixedSizeCollection createCollection(List<GroupAssetsPage> pages, int collectionSize) {
            return new GroupAssetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class GroupAssetsPage
    extends AbstractPage<GroupAssetsRequest, GroupAssetsResponse, GroupResult, GroupAssetsPage> {
        private GroupAssetsPage(PageContext<GroupAssetsRequest, GroupAssetsResponse, GroupResult> context, GroupAssetsResponse response) {
            super(context, (Object)response);
        }

        private static GroupAssetsPage createEmptyPage() {
            return new GroupAssetsPage(null, null);
        }

        protected GroupAssetsPage createPage(PageContext<GroupAssetsRequest, GroupAssetsResponse, GroupResult> context, GroupAssetsResponse response) {
            return new GroupAssetsPage(context, response);
        }

        public ApiFuture<GroupAssetsPage> createPageAsync(PageContext<GroupAssetsRequest, GroupAssetsResponse, GroupResult> context, ApiFuture<GroupAssetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class GroupAssetsPagedResponse
    extends AbstractPagedListResponse<GroupAssetsRequest, GroupAssetsResponse, GroupResult, GroupAssetsPage, GroupAssetsFixedSizeCollection> {
        public static ApiFuture<GroupAssetsPagedResponse> createAsync(PageContext<GroupAssetsRequest, GroupAssetsResponse, GroupResult> context, ApiFuture<GroupAssetsResponse> futureResponse) {
            ApiFuture<GroupAssetsPage> futurePage = GroupAssetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<GroupAssetsPage, GroupAssetsPagedResponse>(){

                public GroupAssetsPagedResponse apply(GroupAssetsPage input) {
                    return new GroupAssetsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private GroupAssetsPagedResponse(GroupAssetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)GroupAssetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

