/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.security.privateca.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.security.privateca.v1.ActivateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.CaPool;
import com.google.cloud.security.privateca.v1.CaPoolName;
import com.google.cloud.security.privateca.v1.Certificate;
import com.google.cloud.security.privateca.v1.CertificateAuthority;
import com.google.cloud.security.privateca.v1.CertificateAuthorityName;
import com.google.cloud.security.privateca.v1.CertificateAuthorityServiceSettings;
import com.google.cloud.security.privateca.v1.CertificateName;
import com.google.cloud.security.privateca.v1.CertificateRevocationList;
import com.google.cloud.security.privateca.v1.CertificateRevocationListName;
import com.google.cloud.security.privateca.v1.CertificateTemplate;
import com.google.cloud.security.privateca.v1.CertificateTemplateName;
import com.google.cloud.security.privateca.v1.CreateCaPoolRequest;
import com.google.cloud.security.privateca.v1.CreateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.CreateCertificateRequest;
import com.google.cloud.security.privateca.v1.CreateCertificateTemplateRequest;
import com.google.cloud.security.privateca.v1.DeleteCaPoolRequest;
import com.google.cloud.security.privateca.v1.DeleteCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.DeleteCertificateTemplateRequest;
import com.google.cloud.security.privateca.v1.DisableCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.EnableCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.FetchCaCertsRequest;
import com.google.cloud.security.privateca.v1.FetchCaCertsResponse;
import com.google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrRequest;
import com.google.cloud.security.privateca.v1.FetchCertificateAuthorityCsrResponse;
import com.google.cloud.security.privateca.v1.GetCaPoolRequest;
import com.google.cloud.security.privateca.v1.GetCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.GetCertificateRequest;
import com.google.cloud.security.privateca.v1.GetCertificateRevocationListRequest;
import com.google.cloud.security.privateca.v1.GetCertificateTemplateRequest;
import com.google.cloud.security.privateca.v1.ListCaPoolsRequest;
import com.google.cloud.security.privateca.v1.ListCaPoolsResponse;
import com.google.cloud.security.privateca.v1.ListCertificateAuthoritiesRequest;
import com.google.cloud.security.privateca.v1.ListCertificateAuthoritiesResponse;
import com.google.cloud.security.privateca.v1.ListCertificateRevocationListsRequest;
import com.google.cloud.security.privateca.v1.ListCertificateRevocationListsResponse;
import com.google.cloud.security.privateca.v1.ListCertificateTemplatesRequest;
import com.google.cloud.security.privateca.v1.ListCertificateTemplatesResponse;
import com.google.cloud.security.privateca.v1.ListCertificatesRequest;
import com.google.cloud.security.privateca.v1.ListCertificatesResponse;
import com.google.cloud.security.privateca.v1.LocationName;
import com.google.cloud.security.privateca.v1.OperationMetadata;
import com.google.cloud.security.privateca.v1.RevokeCertificateRequest;
import com.google.cloud.security.privateca.v1.UndeleteCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.UpdateCaPoolRequest;
import com.google.cloud.security.privateca.v1.UpdateCertificateAuthorityRequest;
import com.google.cloud.security.privateca.v1.UpdateCertificateRequest;
import com.google.cloud.security.privateca.v1.UpdateCertificateRevocationListRequest;
import com.google.cloud.security.privateca.v1.UpdateCertificateTemplateRequest;
import com.google.cloud.security.privateca.v1.stub.CertificateAuthorityServiceStub;
import com.google.cloud.security.privateca.v1.stub.CertificateAuthorityServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CertificateAuthorityServiceClient
implements BackgroundResource {
    private final CertificateAuthorityServiceSettings settings;
    private final CertificateAuthorityServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CertificateAuthorityServiceClient create() throws IOException {
        return CertificateAuthorityServiceClient.create(CertificateAuthorityServiceSettings.newBuilder().build());
    }

    public static final CertificateAuthorityServiceClient create(CertificateAuthorityServiceSettings settings) throws IOException {
        return new CertificateAuthorityServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CertificateAuthorityServiceClient create(CertificateAuthorityServiceStub stub) {
        return new CertificateAuthorityServiceClient(stub);
    }

    protected CertificateAuthorityServiceClient(CertificateAuthorityServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CertificateAuthorityServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CertificateAuthorityServiceClient(CertificateAuthorityServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CertificateAuthorityServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CertificateAuthorityServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Certificate createCertificate(CaPoolName parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificate(request);
    }

    public final Certificate createCertificate(String parent, Certificate certificate, String certificateId) {
        CreateCertificateRequest request = CreateCertificateRequest.newBuilder().setParent(parent).setCertificate(certificate).setCertificateId(certificateId).build();
        return this.createCertificate(request);
    }

    public final Certificate createCertificate(CreateCertificateRequest request) {
        return (Certificate)this.createCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCertificateRequest, Certificate> createCertificateCallable() {
        return this.stub.createCertificateCallable();
    }

    public final Certificate getCertificate(CertificateName name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(String name) {
        GetCertificateRequest request = GetCertificateRequest.newBuilder().setName(name).build();
        return this.getCertificate(request);
    }

    public final Certificate getCertificate(GetCertificateRequest request) {
        return (Certificate)this.getCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateRequest, Certificate> getCertificateCallable() {
        return this.stub.getCertificateCallable();
    }

    public final ListCertificatesPagedResponse listCertificates(CaPoolName parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(String parent) {
        ListCertificatesRequest request = ListCertificatesRequest.newBuilder().setParent(parent).build();
        return this.listCertificates(request);
    }

    public final ListCertificatesPagedResponse listCertificates(ListCertificatesRequest request) {
        return (ListCertificatesPagedResponse)((Object)this.listCertificatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesPagedResponse> listCertificatesPagedCallable() {
        return this.stub.listCertificatesPagedCallable();
    }

    public final UnaryCallable<ListCertificatesRequest, ListCertificatesResponse> listCertificatesCallable() {
        return this.stub.listCertificatesCallable();
    }

    public final Certificate revokeCertificate(CertificateName name) {
        RevokeCertificateRequest request = RevokeCertificateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.revokeCertificate(request);
    }

    public final Certificate revokeCertificate(String name) {
        RevokeCertificateRequest request = RevokeCertificateRequest.newBuilder().setName(name).build();
        return this.revokeCertificate(request);
    }

    public final Certificate revokeCertificate(RevokeCertificateRequest request) {
        return (Certificate)this.revokeCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<RevokeCertificateRequest, Certificate> revokeCertificateCallable() {
        return this.stub.revokeCertificateCallable();
    }

    public final Certificate updateCertificate(Certificate certificate, FieldMask updateMask) {
        UpdateCertificateRequest request = UpdateCertificateRequest.newBuilder().setCertificate(certificate).setUpdateMask(updateMask).build();
        return this.updateCertificate(request);
    }

    public final Certificate updateCertificate(UpdateCertificateRequest request) {
        return (Certificate)this.updateCertificateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCertificateRequest, Certificate> updateCertificateCallable() {
        return this.stub.updateCertificateCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(CertificateAuthorityName name) {
        ActivateCertificateAuthorityRequest request = ActivateCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.activateCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(String name) {
        ActivateCertificateAuthorityRequest request = ActivateCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.activateCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> activateCertificateAuthorityAsync(ActivateCertificateAuthorityRequest request) {
        return this.activateCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ActivateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> activateCertificateAuthorityOperationCallable() {
        return this.stub.activateCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<ActivateCertificateAuthorityRequest, Operation> activateCertificateAuthorityCallable() {
        return this.stub.activateCertificateAuthorityCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(CaPoolName parent, CertificateAuthority certificateAuthority, String certificateAuthorityId) {
        CreateCertificateAuthorityRequest request = CreateCertificateAuthorityRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateAuthority(certificateAuthority).setCertificateAuthorityId(certificateAuthorityId).build();
        return this.createCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(String parent, CertificateAuthority certificateAuthority, String certificateAuthorityId) {
        CreateCertificateAuthorityRequest request = CreateCertificateAuthorityRequest.newBuilder().setParent(parent).setCertificateAuthority(certificateAuthority).setCertificateAuthorityId(certificateAuthorityId).build();
        return this.createCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> createCertificateAuthorityAsync(CreateCertificateAuthorityRequest request) {
        return this.createCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> createCertificateAuthorityOperationCallable() {
        return this.stub.createCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<CreateCertificateAuthorityRequest, Operation> createCertificateAuthorityCallable() {
        return this.stub.createCertificateAuthorityCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(CertificateAuthorityName name) {
        DisableCertificateAuthorityRequest request = DisableCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.disableCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(String name) {
        DisableCertificateAuthorityRequest request = DisableCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.disableCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> disableCertificateAuthorityAsync(DisableCertificateAuthorityRequest request) {
        return this.disableCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DisableCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> disableCertificateAuthorityOperationCallable() {
        return this.stub.disableCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<DisableCertificateAuthorityRequest, Operation> disableCertificateAuthorityCallable() {
        return this.stub.disableCertificateAuthorityCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(CertificateAuthorityName name) {
        EnableCertificateAuthorityRequest request = EnableCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.enableCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(String name) {
        EnableCertificateAuthorityRequest request = EnableCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.enableCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> enableCertificateAuthorityAsync(EnableCertificateAuthorityRequest request) {
        return this.enableCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<EnableCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> enableCertificateAuthorityOperationCallable() {
        return this.stub.enableCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<EnableCertificateAuthorityRequest, Operation> enableCertificateAuthorityCallable() {
        return this.stub.enableCertificateAuthorityCallable();
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(CertificateAuthorityName name) {
        FetchCertificateAuthorityCsrRequest request = FetchCertificateAuthorityCsrRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.fetchCertificateAuthorityCsr(request);
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(String name) {
        FetchCertificateAuthorityCsrRequest request = FetchCertificateAuthorityCsrRequest.newBuilder().setName(name).build();
        return this.fetchCertificateAuthorityCsr(request);
    }

    public final FetchCertificateAuthorityCsrResponse fetchCertificateAuthorityCsr(FetchCertificateAuthorityCsrRequest request) {
        return (FetchCertificateAuthorityCsrResponse)this.fetchCertificateAuthorityCsrCallable().call((Object)request);
    }

    public final UnaryCallable<FetchCertificateAuthorityCsrRequest, FetchCertificateAuthorityCsrResponse> fetchCertificateAuthorityCsrCallable() {
        return this.stub.fetchCertificateAuthorityCsrCallable();
    }

    public final CertificateAuthority getCertificateAuthority(CertificateAuthorityName name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(String name) {
        GetCertificateAuthorityRequest request = GetCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.getCertificateAuthority(request);
    }

    public final CertificateAuthority getCertificateAuthority(GetCertificateAuthorityRequest request) {
        return (CertificateAuthority)this.getCertificateAuthorityCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateAuthorityRequest, CertificateAuthority> getCertificateAuthorityCallable() {
        return this.stub.getCertificateAuthorityCallable();
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(CaPoolName parent) {
        ListCertificateAuthoritiesRequest request = ListCertificateAuthoritiesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateAuthorities(request);
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(String parent) {
        ListCertificateAuthoritiesRequest request = ListCertificateAuthoritiesRequest.newBuilder().setParent(parent).build();
        return this.listCertificateAuthorities(request);
    }

    public final ListCertificateAuthoritiesPagedResponse listCertificateAuthorities(ListCertificateAuthoritiesRequest request) {
        return (ListCertificateAuthoritiesPagedResponse)((Object)this.listCertificateAuthoritiesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesPagedResponse> listCertificateAuthoritiesPagedCallable() {
        return this.stub.listCertificateAuthoritiesPagedCallable();
    }

    public final UnaryCallable<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse> listCertificateAuthoritiesCallable() {
        return this.stub.listCertificateAuthoritiesCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> undeleteCertificateAuthorityAsync(CertificateAuthorityName name) {
        UndeleteCertificateAuthorityRequest request = UndeleteCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.undeleteCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> undeleteCertificateAuthorityAsync(String name) {
        UndeleteCertificateAuthorityRequest request = UndeleteCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.undeleteCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> undeleteCertificateAuthorityAsync(UndeleteCertificateAuthorityRequest request) {
        return this.undeleteCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UndeleteCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> undeleteCertificateAuthorityOperationCallable() {
        return this.stub.undeleteCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<UndeleteCertificateAuthorityRequest, Operation> undeleteCertificateAuthorityCallable() {
        return this.stub.undeleteCertificateAuthorityCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> deleteCertificateAuthorityAsync(CertificateAuthorityName name) {
        DeleteCertificateAuthorityRequest request = DeleteCertificateAuthorityRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> deleteCertificateAuthorityAsync(String name) {
        DeleteCertificateAuthorityRequest request = DeleteCertificateAuthorityRequest.newBuilder().setName(name).build();
        return this.deleteCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> deleteCertificateAuthorityAsync(DeleteCertificateAuthorityRequest request) {
        return this.deleteCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> deleteCertificateAuthorityOperationCallable() {
        return this.stub.deleteCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateAuthorityRequest, Operation> deleteCertificateAuthorityCallable() {
        return this.stub.deleteCertificateAuthorityCallable();
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> updateCertificateAuthorityAsync(CertificateAuthority certificateAuthority, FieldMask updateMask) {
        UpdateCertificateAuthorityRequest request = UpdateCertificateAuthorityRequest.newBuilder().setCertificateAuthority(certificateAuthority).setUpdateMask(updateMask).build();
        return this.updateCertificateAuthorityAsync(request);
    }

    public final OperationFuture<CertificateAuthority, OperationMetadata> updateCertificateAuthorityAsync(UpdateCertificateAuthorityRequest request) {
        return this.updateCertificateAuthorityOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateAuthorityRequest, CertificateAuthority, OperationMetadata> updateCertificateAuthorityOperationCallable() {
        return this.stub.updateCertificateAuthorityOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateAuthorityRequest, Operation> updateCertificateAuthorityCallable() {
        return this.stub.updateCertificateAuthorityCallable();
    }

    public final OperationFuture<CaPool, OperationMetadata> createCaPoolAsync(LocationName parent, CaPool caPool, String caPoolId) {
        CreateCaPoolRequest request = CreateCaPoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCaPool(caPool).setCaPoolId(caPoolId).build();
        return this.createCaPoolAsync(request);
    }

    public final OperationFuture<CaPool, OperationMetadata> createCaPoolAsync(String parent, CaPool caPool, String caPoolId) {
        CreateCaPoolRequest request = CreateCaPoolRequest.newBuilder().setParent(parent).setCaPool(caPool).setCaPoolId(caPoolId).build();
        return this.createCaPoolAsync(request);
    }

    public final OperationFuture<CaPool, OperationMetadata> createCaPoolAsync(CreateCaPoolRequest request) {
        return this.createCaPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCaPoolRequest, CaPool, OperationMetadata> createCaPoolOperationCallable() {
        return this.stub.createCaPoolOperationCallable();
    }

    public final UnaryCallable<CreateCaPoolRequest, Operation> createCaPoolCallable() {
        return this.stub.createCaPoolCallable();
    }

    public final OperationFuture<CaPool, OperationMetadata> updateCaPoolAsync(CaPool caPool, FieldMask updateMask) {
        UpdateCaPoolRequest request = UpdateCaPoolRequest.newBuilder().setCaPool(caPool).setUpdateMask(updateMask).build();
        return this.updateCaPoolAsync(request);
    }

    public final OperationFuture<CaPool, OperationMetadata> updateCaPoolAsync(UpdateCaPoolRequest request) {
        return this.updateCaPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCaPoolRequest, CaPool, OperationMetadata> updateCaPoolOperationCallable() {
        return this.stub.updateCaPoolOperationCallable();
    }

    public final UnaryCallable<UpdateCaPoolRequest, Operation> updateCaPoolCallable() {
        return this.stub.updateCaPoolCallable();
    }

    public final CaPool getCaPool(CaPoolName name) {
        GetCaPoolRequest request = GetCaPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCaPool(request);
    }

    public final CaPool getCaPool(String name) {
        GetCaPoolRequest request = GetCaPoolRequest.newBuilder().setName(name).build();
        return this.getCaPool(request);
    }

    public final CaPool getCaPool(GetCaPoolRequest request) {
        return (CaPool)this.getCaPoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetCaPoolRequest, CaPool> getCaPoolCallable() {
        return this.stub.getCaPoolCallable();
    }

    public final ListCaPoolsPagedResponse listCaPools(LocationName parent) {
        ListCaPoolsRequest request = ListCaPoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCaPools(request);
    }

    public final ListCaPoolsPagedResponse listCaPools(String parent) {
        ListCaPoolsRequest request = ListCaPoolsRequest.newBuilder().setParent(parent).build();
        return this.listCaPools(request);
    }

    public final ListCaPoolsPagedResponse listCaPools(ListCaPoolsRequest request) {
        return (ListCaPoolsPagedResponse)((Object)this.listCaPoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCaPoolsRequest, ListCaPoolsPagedResponse> listCaPoolsPagedCallable() {
        return this.stub.listCaPoolsPagedCallable();
    }

    public final UnaryCallable<ListCaPoolsRequest, ListCaPoolsResponse> listCaPoolsCallable() {
        return this.stub.listCaPoolsCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCaPoolAsync(CaPoolName name) {
        DeleteCaPoolRequest request = DeleteCaPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCaPoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCaPoolAsync(String name) {
        DeleteCaPoolRequest request = DeleteCaPoolRequest.newBuilder().setName(name).build();
        return this.deleteCaPoolAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCaPoolAsync(DeleteCaPoolRequest request) {
        return this.deleteCaPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCaPoolRequest, Empty, OperationMetadata> deleteCaPoolOperationCallable() {
        return this.stub.deleteCaPoolOperationCallable();
    }

    public final UnaryCallable<DeleteCaPoolRequest, Operation> deleteCaPoolCallable() {
        return this.stub.deleteCaPoolCallable();
    }

    public final FetchCaCertsResponse fetchCaCerts(CaPoolName caPool) {
        FetchCaCertsRequest request = FetchCaCertsRequest.newBuilder().setCaPool(caPool == null ? null : caPool.toString()).build();
        return this.fetchCaCerts(request);
    }

    public final FetchCaCertsResponse fetchCaCerts(String caPool) {
        FetchCaCertsRequest request = FetchCaCertsRequest.newBuilder().setCaPool(caPool).build();
        return this.fetchCaCerts(request);
    }

    public final FetchCaCertsResponse fetchCaCerts(FetchCaCertsRequest request) {
        return (FetchCaCertsResponse)this.fetchCaCertsCallable().call((Object)request);
    }

    public final UnaryCallable<FetchCaCertsRequest, FetchCaCertsResponse> fetchCaCertsCallable() {
        return this.stub.fetchCaCertsCallable();
    }

    public final CertificateRevocationList getCertificateRevocationList(CertificateRevocationListName name) {
        GetCertificateRevocationListRequest request = GetCertificateRevocationListRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateRevocationList(request);
    }

    public final CertificateRevocationList getCertificateRevocationList(String name) {
        GetCertificateRevocationListRequest request = GetCertificateRevocationListRequest.newBuilder().setName(name).build();
        return this.getCertificateRevocationList(request);
    }

    public final CertificateRevocationList getCertificateRevocationList(GetCertificateRevocationListRequest request) {
        return (CertificateRevocationList)this.getCertificateRevocationListCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateRevocationListRequest, CertificateRevocationList> getCertificateRevocationListCallable() {
        return this.stub.getCertificateRevocationListCallable();
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(CertificateAuthorityName parent) {
        ListCertificateRevocationListsRequest request = ListCertificateRevocationListsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateRevocationLists(request);
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(String parent) {
        ListCertificateRevocationListsRequest request = ListCertificateRevocationListsRequest.newBuilder().setParent(parent).build();
        return this.listCertificateRevocationLists(request);
    }

    public final ListCertificateRevocationListsPagedResponse listCertificateRevocationLists(ListCertificateRevocationListsRequest request) {
        return (ListCertificateRevocationListsPagedResponse)((Object)this.listCertificateRevocationListsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateRevocationListsRequest, ListCertificateRevocationListsPagedResponse> listCertificateRevocationListsPagedCallable() {
        return this.stub.listCertificateRevocationListsPagedCallable();
    }

    public final UnaryCallable<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse> listCertificateRevocationListsCallable() {
        return this.stub.listCertificateRevocationListsCallable();
    }

    public final OperationFuture<CertificateRevocationList, OperationMetadata> updateCertificateRevocationListAsync(CertificateRevocationList certificateRevocationList, FieldMask updateMask) {
        UpdateCertificateRevocationListRequest request = UpdateCertificateRevocationListRequest.newBuilder().setCertificateRevocationList(certificateRevocationList).setUpdateMask(updateMask).build();
        return this.updateCertificateRevocationListAsync(request);
    }

    public final OperationFuture<CertificateRevocationList, OperationMetadata> updateCertificateRevocationListAsync(UpdateCertificateRevocationListRequest request) {
        return this.updateCertificateRevocationListOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateRevocationListRequest, CertificateRevocationList, OperationMetadata> updateCertificateRevocationListOperationCallable() {
        return this.stub.updateCertificateRevocationListOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateRevocationListRequest, Operation> updateCertificateRevocationListCallable() {
        return this.stub.updateCertificateRevocationListCallable();
    }

    public final OperationFuture<CertificateTemplate, OperationMetadata> createCertificateTemplateAsync(LocationName parent, CertificateTemplate certificateTemplate, String certificateTemplateId) {
        CreateCertificateTemplateRequest request = CreateCertificateTemplateRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCertificateTemplate(certificateTemplate).setCertificateTemplateId(certificateTemplateId).build();
        return this.createCertificateTemplateAsync(request);
    }

    public final OperationFuture<CertificateTemplate, OperationMetadata> createCertificateTemplateAsync(String parent, CertificateTemplate certificateTemplate, String certificateTemplateId) {
        CreateCertificateTemplateRequest request = CreateCertificateTemplateRequest.newBuilder().setParent(parent).setCertificateTemplate(certificateTemplate).setCertificateTemplateId(certificateTemplateId).build();
        return this.createCertificateTemplateAsync(request);
    }

    public final OperationFuture<CertificateTemplate, OperationMetadata> createCertificateTemplateAsync(CreateCertificateTemplateRequest request) {
        return this.createCertificateTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCertificateTemplateRequest, CertificateTemplate, OperationMetadata> createCertificateTemplateOperationCallable() {
        return this.stub.createCertificateTemplateOperationCallable();
    }

    public final UnaryCallable<CreateCertificateTemplateRequest, Operation> createCertificateTemplateCallable() {
        return this.stub.createCertificateTemplateCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateTemplateAsync(CertificateTemplateName name) {
        DeleteCertificateTemplateRequest request = DeleteCertificateTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCertificateTemplateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateTemplateAsync(String name) {
        DeleteCertificateTemplateRequest request = DeleteCertificateTemplateRequest.newBuilder().setName(name).build();
        return this.deleteCertificateTemplateAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCertificateTemplateAsync(DeleteCertificateTemplateRequest request) {
        return this.deleteCertificateTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCertificateTemplateRequest, Empty, OperationMetadata> deleteCertificateTemplateOperationCallable() {
        return this.stub.deleteCertificateTemplateOperationCallable();
    }

    public final UnaryCallable<DeleteCertificateTemplateRequest, Operation> deleteCertificateTemplateCallable() {
        return this.stub.deleteCertificateTemplateCallable();
    }

    public final CertificateTemplate getCertificateTemplate(CertificateTemplateName name) {
        GetCertificateTemplateRequest request = GetCertificateTemplateRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCertificateTemplate(request);
    }

    public final CertificateTemplate getCertificateTemplate(String name) {
        GetCertificateTemplateRequest request = GetCertificateTemplateRequest.newBuilder().setName(name).build();
        return this.getCertificateTemplate(request);
    }

    public final CertificateTemplate getCertificateTemplate(GetCertificateTemplateRequest request) {
        return (CertificateTemplate)this.getCertificateTemplateCallable().call((Object)request);
    }

    public final UnaryCallable<GetCertificateTemplateRequest, CertificateTemplate> getCertificateTemplateCallable() {
        return this.stub.getCertificateTemplateCallable();
    }

    public final ListCertificateTemplatesPagedResponse listCertificateTemplates(LocationName parent) {
        ListCertificateTemplatesRequest request = ListCertificateTemplatesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCertificateTemplates(request);
    }

    public final ListCertificateTemplatesPagedResponse listCertificateTemplates(String parent) {
        ListCertificateTemplatesRequest request = ListCertificateTemplatesRequest.newBuilder().setParent(parent).build();
        return this.listCertificateTemplates(request);
    }

    public final ListCertificateTemplatesPagedResponse listCertificateTemplates(ListCertificateTemplatesRequest request) {
        return (ListCertificateTemplatesPagedResponse)((Object)this.listCertificateTemplatesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCertificateTemplatesRequest, ListCertificateTemplatesPagedResponse> listCertificateTemplatesPagedCallable() {
        return this.stub.listCertificateTemplatesPagedCallable();
    }

    public final UnaryCallable<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse> listCertificateTemplatesCallable() {
        return this.stub.listCertificateTemplatesCallable();
    }

    public final OperationFuture<CertificateTemplate, OperationMetadata> updateCertificateTemplateAsync(CertificateTemplate certificateTemplate, FieldMask updateMask) {
        UpdateCertificateTemplateRequest request = UpdateCertificateTemplateRequest.newBuilder().setCertificateTemplate(certificateTemplate).setUpdateMask(updateMask).build();
        return this.updateCertificateTemplateAsync(request);
    }

    public final OperationFuture<CertificateTemplate, OperationMetadata> updateCertificateTemplateAsync(UpdateCertificateTemplateRequest request) {
        return this.updateCertificateTemplateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCertificateTemplateRequest, CertificateTemplate, OperationMetadata> updateCertificateTemplateOperationCallable() {
        return this.stub.updateCertificateTemplateOperationCallable();
    }

    public final UnaryCallable<UpdateCertificateTemplateRequest, Operation> updateCertificateTemplateCallable() {
        return this.stub.updateCertificateTemplateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCertificateTemplatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate, ListCertificateTemplatesPage, ListCertificateTemplatesFixedSizeCollection> {
        private ListCertificateTemplatesFixedSizeCollection(List<ListCertificateTemplatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateTemplatesFixedSizeCollection createEmptyCollection() {
            return new ListCertificateTemplatesFixedSizeCollection(null, 0);
        }

        protected ListCertificateTemplatesFixedSizeCollection createCollection(List<ListCertificateTemplatesPage> pages, int collectionSize) {
            return new ListCertificateTemplatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateTemplatesPage
    extends AbstractPage<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate, ListCertificateTemplatesPage> {
        private ListCertificateTemplatesPage(PageContext<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate> context, ListCertificateTemplatesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateTemplatesPage createEmptyPage() {
            return new ListCertificateTemplatesPage(null, null);
        }

        protected ListCertificateTemplatesPage createPage(PageContext<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate> context, ListCertificateTemplatesResponse response) {
            return new ListCertificateTemplatesPage(context, response);
        }

        public ApiFuture<ListCertificateTemplatesPage> createPageAsync(PageContext<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate> context, ApiFuture<ListCertificateTemplatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateTemplatesPagedResponse
    extends AbstractPagedListResponse<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate, ListCertificateTemplatesPage, ListCertificateTemplatesFixedSizeCollection> {
        public static ApiFuture<ListCertificateTemplatesPagedResponse> createAsync(PageContext<ListCertificateTemplatesRequest, ListCertificateTemplatesResponse, CertificateTemplate> context, ApiFuture<ListCertificateTemplatesResponse> futureResponse) {
            ApiFuture<ListCertificateTemplatesPage> futurePage = ListCertificateTemplatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateTemplatesPagedResponse((ListCertificateTemplatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateTemplatesPagedResponse(ListCertificateTemplatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateTemplatesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateRevocationListsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage, ListCertificateRevocationListsFixedSizeCollection> {
        private ListCertificateRevocationListsFixedSizeCollection(List<ListCertificateRevocationListsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateRevocationListsFixedSizeCollection createEmptyCollection() {
            return new ListCertificateRevocationListsFixedSizeCollection(null, 0);
        }

        protected ListCertificateRevocationListsFixedSizeCollection createCollection(List<ListCertificateRevocationListsPage> pages, int collectionSize) {
            return new ListCertificateRevocationListsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateRevocationListsPage
    extends AbstractPage<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage> {
        private ListCertificateRevocationListsPage(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ListCertificateRevocationListsResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateRevocationListsPage createEmptyPage() {
            return new ListCertificateRevocationListsPage(null, null);
        }

        protected ListCertificateRevocationListsPage createPage(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ListCertificateRevocationListsResponse response) {
            return new ListCertificateRevocationListsPage(context, response);
        }

        public ApiFuture<ListCertificateRevocationListsPage> createPageAsync(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ApiFuture<ListCertificateRevocationListsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateRevocationListsPagedResponse
    extends AbstractPagedListResponse<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList, ListCertificateRevocationListsPage, ListCertificateRevocationListsFixedSizeCollection> {
        public static ApiFuture<ListCertificateRevocationListsPagedResponse> createAsync(PageContext<ListCertificateRevocationListsRequest, ListCertificateRevocationListsResponse, CertificateRevocationList> context, ApiFuture<ListCertificateRevocationListsResponse> futureResponse) {
            ApiFuture<ListCertificateRevocationListsPage> futurePage = ListCertificateRevocationListsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateRevocationListsPagedResponse((ListCertificateRevocationListsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateRevocationListsPagedResponse(ListCertificateRevocationListsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateRevocationListsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCaPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCaPoolsRequest, ListCaPoolsResponse, CaPool, ListCaPoolsPage, ListCaPoolsFixedSizeCollection> {
        private ListCaPoolsFixedSizeCollection(List<ListCaPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCaPoolsFixedSizeCollection createEmptyCollection() {
            return new ListCaPoolsFixedSizeCollection(null, 0);
        }

        protected ListCaPoolsFixedSizeCollection createCollection(List<ListCaPoolsPage> pages, int collectionSize) {
            return new ListCaPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCaPoolsPage
    extends AbstractPage<ListCaPoolsRequest, ListCaPoolsResponse, CaPool, ListCaPoolsPage> {
        private ListCaPoolsPage(PageContext<ListCaPoolsRequest, ListCaPoolsResponse, CaPool> context, ListCaPoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListCaPoolsPage createEmptyPage() {
            return new ListCaPoolsPage(null, null);
        }

        protected ListCaPoolsPage createPage(PageContext<ListCaPoolsRequest, ListCaPoolsResponse, CaPool> context, ListCaPoolsResponse response) {
            return new ListCaPoolsPage(context, response);
        }

        public ApiFuture<ListCaPoolsPage> createPageAsync(PageContext<ListCaPoolsRequest, ListCaPoolsResponse, CaPool> context, ApiFuture<ListCaPoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCaPoolsPagedResponse
    extends AbstractPagedListResponse<ListCaPoolsRequest, ListCaPoolsResponse, CaPool, ListCaPoolsPage, ListCaPoolsFixedSizeCollection> {
        public static ApiFuture<ListCaPoolsPagedResponse> createAsync(PageContext<ListCaPoolsRequest, ListCaPoolsResponse, CaPool> context, ApiFuture<ListCaPoolsResponse> futureResponse) {
            ApiFuture<ListCaPoolsPage> futurePage = ListCaPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCaPoolsPagedResponse((ListCaPoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCaPoolsPagedResponse(ListCaPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCaPoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificateAuthoritiesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage, ListCertificateAuthoritiesFixedSizeCollection> {
        private ListCertificateAuthoritiesFixedSizeCollection(List<ListCertificateAuthoritiesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificateAuthoritiesFixedSizeCollection createEmptyCollection() {
            return new ListCertificateAuthoritiesFixedSizeCollection(null, 0);
        }

        protected ListCertificateAuthoritiesFixedSizeCollection createCollection(List<ListCertificateAuthoritiesPage> pages, int collectionSize) {
            return new ListCertificateAuthoritiesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificateAuthoritiesPage
    extends AbstractPage<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage> {
        private ListCertificateAuthoritiesPage(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ListCertificateAuthoritiesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificateAuthoritiesPage createEmptyPage() {
            return new ListCertificateAuthoritiesPage(null, null);
        }

        protected ListCertificateAuthoritiesPage createPage(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ListCertificateAuthoritiesResponse response) {
            return new ListCertificateAuthoritiesPage(context, response);
        }

        public ApiFuture<ListCertificateAuthoritiesPage> createPageAsync(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ApiFuture<ListCertificateAuthoritiesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificateAuthoritiesPagedResponse
    extends AbstractPagedListResponse<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority, ListCertificateAuthoritiesPage, ListCertificateAuthoritiesFixedSizeCollection> {
        public static ApiFuture<ListCertificateAuthoritiesPagedResponse> createAsync(PageContext<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse, CertificateAuthority> context, ApiFuture<ListCertificateAuthoritiesResponse> futureResponse) {
            ApiFuture<ListCertificateAuthoritiesPage> futurePage = ListCertificateAuthoritiesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificateAuthoritiesPagedResponse((ListCertificateAuthoritiesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificateAuthoritiesPagedResponse(ListCertificateAuthoritiesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificateAuthoritiesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCertificatesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        private ListCertificatesFixedSizeCollection(List<ListCertificatesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCertificatesFixedSizeCollection createEmptyCollection() {
            return new ListCertificatesFixedSizeCollection(null, 0);
        }

        protected ListCertificatesFixedSizeCollection createCollection(List<ListCertificatesPage> pages, int collectionSize) {
            return new ListCertificatesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCertificatesPage
    extends AbstractPage<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage> {
        private ListCertificatesPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            super(context, (Object)response);
        }

        private static ListCertificatesPage createEmptyPage() {
            return new ListCertificatesPage(null, null);
        }

        protected ListCertificatesPage createPage(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ListCertificatesResponse response) {
            return new ListCertificatesPage(context, response);
        }

        public ApiFuture<ListCertificatesPage> createPageAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCertificatesPagedResponse
    extends AbstractPagedListResponse<ListCertificatesRequest, ListCertificatesResponse, Certificate, ListCertificatesPage, ListCertificatesFixedSizeCollection> {
        public static ApiFuture<ListCertificatesPagedResponse> createAsync(PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate> context, ApiFuture<ListCertificatesResponse> futureResponse) {
            ApiFuture<ListCertificatesPage> futurePage = ListCertificatesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCertificatesPagedResponse((ListCertificatesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCertificatesPagedResponse(ListCertificatesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCertificatesFixedSizeCollection.createEmptyCollection());
        }
    }
}

