/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.securesourcemanager.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.cloud.securesourcemanager.v1.CreateInstanceRequest;
import com.google.cloud.securesourcemanager.v1.CreateRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.DeleteInstanceRequest;
import com.google.cloud.securesourcemanager.v1.DeleteRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.GetInstanceRequest;
import com.google.cloud.securesourcemanager.v1.GetRepositoryRequest;
import com.google.cloud.securesourcemanager.v1.Instance;
import com.google.cloud.securesourcemanager.v1.InstanceName;
import com.google.cloud.securesourcemanager.v1.ListInstancesRequest;
import com.google.cloud.securesourcemanager.v1.ListInstancesResponse;
import com.google.cloud.securesourcemanager.v1.ListRepositoriesRequest;
import com.google.cloud.securesourcemanager.v1.ListRepositoriesResponse;
import com.google.cloud.securesourcemanager.v1.LocationName;
import com.google.cloud.securesourcemanager.v1.OperationMetadata;
import com.google.cloud.securesourcemanager.v1.Repository;
import com.google.cloud.securesourcemanager.v1.RepositoryName;
import com.google.cloud.securesourcemanager.v1.SecureSourceManagerSettings;
import com.google.cloud.securesourcemanager.v1.stub.SecureSourceManagerStub;
import com.google.cloud.securesourcemanager.v1.stub.SecureSourceManagerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecureSourceManagerClient
implements BackgroundResource {
    private final SecureSourceManagerSettings settings;
    private final SecureSourceManagerStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final SecureSourceManagerClient create() throws IOException {
        return SecureSourceManagerClient.create(SecureSourceManagerSettings.newBuilder().build());
    }

    public static final SecureSourceManagerClient create(SecureSourceManagerSettings settings) throws IOException {
        return new SecureSourceManagerClient(settings);
    }

    public static final SecureSourceManagerClient create(SecureSourceManagerStub stub) {
        return new SecureSourceManagerClient(stub);
    }

    protected SecureSourceManagerClient(SecureSourceManagerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecureSourceManagerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SecureSourceManagerClient(SecureSourceManagerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SecureSourceManagerSettings getSettings() {
        return this.settings;
    }

    public SecureSourceManagerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstancesPagedResponse listInstances(LocationName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(LocationName parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(String parent, Instance instance, String instanceId) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstance(instance).setInstanceId(instanceId).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, OperationMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        return this.deleteInstanceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteInstanceAsync(DeleteInstanceRequest request) {
        return this.deleteInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.stub.deleteInstanceOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final ListRepositoriesPagedResponse listRepositories(LocationName parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(String parent) {
        ListRepositoriesRequest request = ListRepositoriesRequest.newBuilder().setParent(parent).build();
        return this.listRepositories(request);
    }

    public final ListRepositoriesPagedResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesPagedResponse)((Object)this.listRepositoriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesPagedResponse> listRepositoriesPagedCallable() {
        return this.stub.listRepositoriesPagedCallable();
    }

    public final UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> listRepositoriesCallable() {
        return this.stub.listRepositoriesCallable();
    }

    public final Repository getRepository(RepositoryName name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(String name) {
        GetRepositoryRequest request = GetRepositoryRequest.newBuilder().setName(name).build();
        return this.getRepository(request);
    }

    public final Repository getRepository(GetRepositoryRequest request) {
        return (Repository)this.getRepositoryCallable().call((Object)request);
    }

    public final UnaryCallable<GetRepositoryRequest, Repository> getRepositoryCallable() {
        return this.stub.getRepositoryCallable();
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(LocationName parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(String parent, Repository repository, String repositoryId) {
        CreateRepositoryRequest request = CreateRepositoryRequest.newBuilder().setParent(parent).setRepository(repository).setRepositoryId(repositoryId).build();
        return this.createRepositoryAsync(request);
    }

    public final OperationFuture<Repository, OperationMetadata> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationCallable() {
        return this.stub.createRepositoryOperationCallable();
    }

    public final UnaryCallable<CreateRepositoryRequest, Operation> createRepositoryCallable() {
        return this.stub.createRepositoryCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(RepositoryName name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(String name) {
        DeleteRepositoryRequest request = DeleteRepositoryRequest.newBuilder().setName(name).build();
        return this.deleteRepositoryAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationCallable() {
        return this.stub.deleteRepositoryOperationCallable();
    }

    public final UnaryCallable<DeleteRepositoryRequest, Operation> deleteRepositoryCallable() {
        return this.stub.deleteRepositoryCallable();
    }

    public final Policy getIamPolicyRepo(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicyRepo(request);
    }

    public final Policy getIamPolicyRepo(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicyRepo(request);
    }

    public final Policy getIamPolicyRepo(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyRepoCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyRepoCallable() {
        return this.stub.getIamPolicyRepoCallable();
    }

    public final Policy setIamPolicyRepo(ResourceName resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.setIamPolicyRepo(request);
    }

    public final Policy setIamPolicyRepo(String resource) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.setIamPolicyRepo(request);
    }

    public final Policy setIamPolicyRepo(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyRepoCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyRepoCallable() {
        return this.stub.setIamPolicyRepoCallable();
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(ResourceName resource) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.testIamPermissionsRepo(request);
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(String resource) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).build();
        return this.testIamPermissionsRepo(request);
    }

    public final TestIamPermissionsResponse testIamPermissionsRepo(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsRepoCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsRepoCallable() {
        return this.stub.testIamPermissionsRepoCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRepositoriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        private ListRepositoriesFixedSizeCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRepositoriesFixedSizeCollection createEmptyCollection() {
            return new ListRepositoriesFixedSizeCollection(null, 0);
        }

        protected ListRepositoriesFixedSizeCollection createCollection(List<ListRepositoriesPage> pages, int collectionSize) {
            return new ListRepositoriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRepositoriesPage
    extends AbstractPage<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage> {
        private ListRepositoriesPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            super(context, (Object)response);
        }

        private static ListRepositoriesPage createEmptyPage() {
            return new ListRepositoriesPage(null, null);
        }

        protected ListRepositoriesPage createPage(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ListRepositoriesResponse response) {
            return new ListRepositoriesPage(context, response);
        }

        public ApiFuture<ListRepositoriesPage> createPageAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRepositoriesPagedResponse
    extends AbstractPagedListResponse<ListRepositoriesRequest, ListRepositoriesResponse, Repository, ListRepositoriesPage, ListRepositoriesFixedSizeCollection> {
        public static ApiFuture<ListRepositoriesPagedResponse> createAsync(PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository> context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            ApiFuture<ListRepositoriesPage> futurePage = ListRepositoriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRepositoriesPagedResponse((ListRepositoriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRepositoriesPagedResponse(ListRepositoriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRepositoriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }
}

