/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.GetTaskRequest;
import com.google.cloud.run.v2.ListTasksRequest;
import com.google.cloud.run.v2.ListTasksResponse;
import com.google.cloud.run.v2.Task;
import com.google.cloud.run.v2.TasksClient;
import com.google.cloud.run.v2.stub.HttpJsonTasksCallableFactory;
import com.google.cloud.run.v2.stub.TasksStub;
import com.google.cloud.run.v2.stub.TasksStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonTasksStub
extends TasksStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Tasks/GetTask").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*/executions/*/tasks/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Task.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Tasks/ListTasks").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*/jobs/*/executions/*}/tasks", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTasksResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, TasksClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonTasksStub create(TasksStubSettings settings) throws IOException {
        return new HttpJsonTasksStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonTasksStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonTasksStub(TasksStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonTasksStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonTasksStub(TasksStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonTasksStub(TasksStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonTasksCallableFactory());
    }

    protected HttpJsonTasksStub(TasksStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getTaskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listTasksTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getTaskMethodDescriptor);
        methodDescriptors.add(listTasksMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, TasksClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

