/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.run.v2.CreateServiceRequest;
import com.google.cloud.run.v2.DeleteServiceRequest;
import com.google.cloud.run.v2.GetServiceRequest;
import com.google.cloud.run.v2.ListServicesRequest;
import com.google.cloud.run.v2.ListServicesResponse;
import com.google.cloud.run.v2.Service;
import com.google.cloud.run.v2.ServicesClient;
import com.google.cloud.run.v2.UpdateServiceRequest;
import com.google.cloud.run.v2.stub.GrpcServicesCallableFactory;
import com.google.cloud.run.v2.stub.ServicesStub;
import com.google.cloud.run.v2.stub.ServicesStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcServicesStub
extends ServicesStub {
    private static final MethodDescriptor<CreateServiceRequest, Operation> createServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/CreateService").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateServiceRequest, Operation> updateServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/UpdateService").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/DeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller((Message)SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Policy.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.run.v2.Services/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)TestIamPermissionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable;
    private final OperationCallable<CreateServiceRequest, Service, Service> createServiceOperationCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, ServicesClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable;
    private final OperationCallable<UpdateServiceRequest, Service, Service> updateServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Service, Service> deleteServiceOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;
    private static final PathTemplate CREATE_SERVICE_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate GET_SERVICE_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate LIST_SERVICES_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}");
    private static final PathTemplate UPDATE_SERVICE_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");
    private static final PathTemplate DELETE_SERVICE_0_PATH_TEMPLATE = PathTemplate.create((String)"projects/*/locations/{location=*}/**");

    public static final GrpcServicesStub create(ServicesStubSettings settings) throws IOException {
        return new GrpcServicesStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcServicesStub create(ClientContext clientContext) throws IOException {
        return new GrpcServicesStub(ServicesStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcServicesStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcServicesStub(ServicesStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcServicesStub(ServicesStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcServicesCallableFactory());
    }

    protected GrpcServicesStub(ServicesStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", CREATE_SERVICE_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", GET_SERVICE_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getParent(), "location", LIST_SERVICES_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings updateServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            if (request.getService() != null) {
                builder.add(request.getService().getName(), "location", UPDATE_SERVICE_0_PATH_TEMPLATE);
            }
            return builder.build();
        }).build();
        GrpcCallSettings deleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add(request.getName(), "location", DELETE_SERVICE_0_PATH_TEMPLATE);
            return builder.build();
        }).build();
        GrpcCallSettings getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.createServiceOperationCallable = callableFactory.createOperationCallable(createServiceTransportSettings, settings.createServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.updateServiceCallable = callableFactory.createUnaryCallable(updateServiceTransportSettings, settings.updateServiceSettings(), clientContext);
        this.updateServiceOperationCallable = callableFactory.createOperationCallable(updateServiceTransportSettings, settings.updateServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public OperationCallable<CreateServiceRequest, Service, Service> createServiceOperationCallable() {
        return this.createServiceOperationCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ServicesClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.updateServiceCallable;
    }

    @Override
    public OperationCallable<UpdateServiceRequest, Service, Service> updateServiceOperationCallable() {
        return this.updateServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Service, Service> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

