/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.CreateJobRequest;
import com.google.cloud.run.v2.DeleteJobRequest;
import com.google.cloud.run.v2.Execution;
import com.google.cloud.run.v2.GetJobRequest;
import com.google.cloud.run.v2.Job;
import com.google.cloud.run.v2.JobsClient;
import com.google.cloud.run.v2.ListJobsRequest;
import com.google.cloud.run.v2.ListJobsResponse;
import com.google.cloud.run.v2.RunJobRequest;
import com.google.cloud.run.v2.UpdateJobRequest;
import com.google.cloud.run.v2.stub.HttpJsonJobsCallableFactory;
import com.google.cloud.run.v2.stub.JobsStub;
import com.google.cloud.run.v2.stub.JobsStubSettings;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonJobsStub
extends JobsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Execution.getDescriptor()).add(Job.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateJobRequest, Operation> createJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/CreateJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "jobId", (Object)request.getJobId());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/GetJob").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Job.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/ListJobs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{parent=projects/*/locations/*}/jobs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListJobsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateJobRequest, Operation> updateJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/UpdateJob").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{job.name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "job.name", (Object)request.getJob().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("job", (Message)request.getJob(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteJobRequest, Operation> deleteJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/DeleteJob").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<RunJobRequest, Operation> runJobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/RunJob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{name=projects/*/locations/*/jobs/*}:run", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/jobs/*}:getIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "options", (Object)request.getOptions());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/jobs/*}:setIamPolicy", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.run.v2.Jobs/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2/{resource=projects/*/locations/*/jobs/*}:testIamPermissions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", (Object)request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearResource().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateJobRequest, Operation> createJobCallable;
    private final OperationCallable<CreateJobRequest, Job, Job> createJobOperationCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, JobsClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<UpdateJobRequest, Operation> updateJobCallable;
    private final OperationCallable<UpdateJobRequest, Job, Job> updateJobOperationCallable;
    private final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable;
    private final OperationCallable<DeleteJobRequest, Job, Job> deleteJobOperationCallable;
    private final UnaryCallable<RunJobRequest, Operation> runJobCallable;
    private final OperationCallable<RunJobRequest, Execution, Execution> runJobOperationCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonJobsStub create(JobsStubSettings settings) throws IOException {
        return new HttpJsonJobsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonJobsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonJobsStub(JobsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonJobsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonJobsStub(JobsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonJobsStub(JobsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonJobsCallableFactory());
    }

    protected HttpJsonJobsStub(JobsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listJobsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings runJobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(runJobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.createJobOperationCallable = callableFactory.createOperationCallable(createJobTransportSettings, settings.createJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.updateJobOperationCallable = callableFactory.createOperationCallable(updateJobTransportSettings, settings.updateJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.deleteJobOperationCallable = callableFactory.createOperationCallable(deleteJobTransportSettings, settings.deleteJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.runJobCallable = callableFactory.createUnaryCallable(runJobTransportSettings, settings.runJobSettings(), clientContext);
        this.runJobOperationCallable = callableFactory.createOperationCallable(runJobTransportSettings, settings.runJobOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createJobMethodDescriptor);
        methodDescriptors.add(getJobMethodDescriptor);
        methodDescriptors.add(listJobsMethodDescriptor);
        methodDescriptors.add(updateJobMethodDescriptor);
        methodDescriptors.add(deleteJobMethodDescriptor);
        methodDescriptors.add(runJobMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Operation> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public OperationCallable<CreateJobRequest, Job, Job> createJobOperationCallable() {
        return this.createJobOperationCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, JobsClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Operation> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public OperationCallable<UpdateJobRequest, Job, Job> updateJobOperationCallable() {
        return this.updateJobOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public OperationCallable<DeleteJobRequest, Job, Job> deleteJobOperationCallable() {
        return this.deleteJobOperationCallable;
    }

    @Override
    public UnaryCallable<RunJobRequest, Operation> runJobCallable() {
        return this.runJobCallable;
    }

    @Override
    public OperationCallable<RunJobRequest, Execution, Execution> runJobOperationCallable() {
        return this.runJobOperationCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

