/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.GetTaskRequest;
import com.google.cloud.run.v2.ListTasksRequest;
import com.google.cloud.run.v2.ListTasksResponse;
import com.google.cloud.run.v2.Task;
import com.google.cloud.run.v2.TasksClient;
import com.google.cloud.run.v2.stub.GrpcTasksStub;
import com.google.cloud.run.v2.stub.HttpJsonTasksStub;
import com.google.cloud.run.v2.stub.TasksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class TasksStubSettings
extends StubSettings<TasksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetTaskRequest, Task> getTaskSettings;
    private final PagedCallSettings<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse> listTasksSettings;
    private static final PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task> LIST_TASKS_PAGE_STR_DESC = new PagedListDescriptor<ListTasksRequest, ListTasksResponse, Task>(){

        public String emptyToken() {
            return "";
        }

        public ListTasksRequest injectToken(ListTasksRequest payload, String token) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageToken(token).build();
        }

        public ListTasksRequest injectPageSize(ListTasksRequest payload, int pageSize) {
            return ListTasksRequest.newBuilder((ListTasksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTasksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTasksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Task> extractResources(ListTasksResponse payload) {
            return payload.getTasksList() == null ? ImmutableList.of() : payload.getTasksList();
        }
    };
    private static final PagedListResponseFactory<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse> LIST_TASKS_PAGE_STR_FACT = new PagedListResponseFactory<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse>(){

        public ApiFuture<TasksClient.ListTasksPagedResponse> getFuturePagedResponse(UnaryCallable<ListTasksRequest, ListTasksResponse> callable, ListTasksRequest request, ApiCallContext context, ApiFuture<ListTasksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TASKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return TasksClient.ListTasksPagedResponse.createAsync((PageContext<ListTasksRequest, ListTasksResponse, Task>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTaskRequest, Task> getTaskSettings() {
        return this.getTaskSettings;
    }

    public PagedCallSettings<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse> listTasksSettings() {
        return this.listTasksSettings;
    }

    public TasksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTasksStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonTasksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "run";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "run.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "run.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TasksStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TasksStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TasksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return TasksStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TasksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTaskSettings = settingsBuilder.getTaskSettings().build();
        this.listTasksSettings = settingsBuilder.listTasksSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TasksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings;
        private final PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse> listTasksSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTaskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTasksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TASKS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTaskSettings, this.listTasksSettings);
            Builder.initDefaults(this);
        }

        protected Builder(TasksStubSettings settings) {
            super((StubSettings)settings);
            this.getTaskSettings = settings.getTaskSettings.toBuilder();
            this.listTasksSettings = settings.listTasksSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTaskSettings, this.listTasksSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TasksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)TasksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TasksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TasksStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TasksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)TasksStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)TasksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)TasksStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TasksStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(TasksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTaskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTasksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTaskRequest, Task> getTaskSettings() {
            return this.getTaskSettings;
        }

        public PagedCallSettings.Builder<ListTasksRequest, ListTasksResponse, TasksClient.ListTasksPagedResponse> listTasksSettings() {
            return this.listTasksSettings;
        }

        public TasksStubSettings build() throws IOException {
            return new TasksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

