/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.run.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.run.v2.DeleteRevisionRequest;
import com.google.cloud.run.v2.GetRevisionRequest;
import com.google.cloud.run.v2.ListRevisionsRequest;
import com.google.cloud.run.v2.ListRevisionsResponse;
import com.google.cloud.run.v2.Revision;
import com.google.cloud.run.v2.RevisionName;
import com.google.cloud.run.v2.RevisionsSettings;
import com.google.cloud.run.v2.ServiceName;
import com.google.cloud.run.v2.stub.RevisionsStub;
import com.google.cloud.run.v2.stub.RevisionsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RevisionsClient
implements BackgroundResource {
    private final RevisionsSettings settings;
    private final RevisionsStub stub;
    private final OperationsClient operationsClient;

    public static final RevisionsClient create() throws IOException {
        return RevisionsClient.create(RevisionsSettings.newBuilder().build());
    }

    public static final RevisionsClient create(RevisionsSettings settings) throws IOException {
        return new RevisionsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RevisionsClient create(RevisionsStub stub) {
        return new RevisionsClient(stub);
    }

    protected RevisionsClient(RevisionsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RevisionsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RevisionsClient(RevisionsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final RevisionsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RevisionsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Revision getRevision(RevisionName name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(String name) {
        GetRevisionRequest request = GetRevisionRequest.newBuilder().setName(name).build();
        return this.getRevision(request);
    }

    public final Revision getRevision(GetRevisionRequest request) {
        return (Revision)this.getRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<GetRevisionRequest, Revision> getRevisionCallable() {
        return this.stub.getRevisionCallable();
    }

    public final ListRevisionsPagedResponse listRevisions(ServiceName parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(String parent) {
        ListRevisionsRequest request = ListRevisionsRequest.newBuilder().setParent(parent).build();
        return this.listRevisions(request);
    }

    public final ListRevisionsPagedResponse listRevisions(ListRevisionsRequest request) {
        return (ListRevisionsPagedResponse)((Object)this.listRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsPagedResponse> listRevisionsPagedCallable() {
        return this.stub.listRevisionsPagedCallable();
    }

    public final UnaryCallable<ListRevisionsRequest, ListRevisionsResponse> listRevisionsCallable() {
        return this.stub.listRevisionsCallable();
    }

    public final OperationFuture<Revision, Revision> deleteRevisionAsync(RevisionName name) {
        DeleteRevisionRequest request = DeleteRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRevisionAsync(request);
    }

    public final OperationFuture<Revision, Revision> deleteRevisionAsync(String name) {
        DeleteRevisionRequest request = DeleteRevisionRequest.newBuilder().setName(name).build();
        return this.deleteRevisionAsync(request);
    }

    public final OperationFuture<Revision, Revision> deleteRevisionAsync(DeleteRevisionRequest request) {
        return this.deleteRevisionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRevisionRequest, Revision, Revision> deleteRevisionOperationCallable() {
        return this.stub.deleteRevisionOperationCallable();
    }

    public final UnaryCallable<DeleteRevisionRequest, Operation> deleteRevisionCallable() {
        return this.stub.deleteRevisionCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        private ListRevisionsFixedSizeCollection(List<ListRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListRevisionsFixedSizeCollection(null, 0);
        }

        protected ListRevisionsFixedSizeCollection createCollection(List<ListRevisionsPage> pages, int collectionSize) {
            return new ListRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRevisionsPage
    extends AbstractPage<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage> {
        private ListRevisionsPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListRevisionsPage createEmptyPage() {
            return new ListRevisionsPage(null, null);
        }

        protected ListRevisionsPage createPage(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ListRevisionsResponse response) {
            return new ListRevisionsPage(context, response);
        }

        public ApiFuture<ListRevisionsPage> createPageAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRevisionsPagedResponse
    extends AbstractPagedListResponse<ListRevisionsRequest, ListRevisionsResponse, Revision, ListRevisionsPage, ListRevisionsFixedSizeCollection> {
        public static ApiFuture<ListRevisionsPagedResponse> createAsync(PageContext<ListRevisionsRequest, ListRevisionsResponse, Revision> context, ApiFuture<ListRevisionsResponse> futureResponse) {
            ApiFuture<ListRevisionsPage> futurePage = ListRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRevisionsPagedResponse((ListRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRevisionsPagedResponse(ListRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

