/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.CompleteQueryRequest;
import com.google.cloud.retail.v2beta.CompleteQueryResponse;
import com.google.cloud.retail.v2beta.ImportCompletionDataRequest;
import com.google.cloud.retail.v2beta.ImportCompletionDataResponse;
import com.google.cloud.retail.v2beta.ImportMetadata;
import com.google.cloud.retail.v2beta.stub.CompletionServiceStub;
import com.google.cloud.retail.v2beta.stub.CompletionServiceStubSettings;
import com.google.cloud.retail.v2beta.stub.HttpJsonCompletionServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonCompletionServiceStub
extends CompletionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ImportMetadata.getDescriptor()).add(ImportCompletionDataResponse.getDescriptor()).build();
    private static final ApiMethodDescriptor<CompleteQueryRequest, CompleteQueryResponse> completeQueryMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.CompletionService/CompleteQuery").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{catalog=projects/*/locations/*/catalogs/*}:completeQuery", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "catalog", (Object)request.getCatalog());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dataset", (Object)request.getDataset());
        serializer.putQueryParam(fields, "deviceType", (Object)request.getDeviceType());
        serializer.putQueryParam(fields, "enableAttributeSuggestions", (Object)request.getEnableAttributeSuggestions());
        serializer.putQueryParam(fields, "entity", (Object)request.getEntity());
        serializer.putQueryParam(fields, "languageCodes", (Object)request.getLanguageCodesList());
        serializer.putQueryParam(fields, "maxSuggestions", (Object)request.getMaxSuggestions());
        serializer.putQueryParam(fields, "query", (Object)request.getQuery());
        serializer.putQueryParam(fields, "visitorId", (Object)request.getVisitorId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CompleteQueryResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ImportCompletionDataRequest, Operation> importCompletionDataMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.retail.v2beta.CompletionService/ImportCompletionData").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*/catalogs/*}/completionData:import", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable;
    private final UnaryCallable<ImportCompletionDataRequest, Operation> importCompletionDataCallable;
    private final OperationCallable<ImportCompletionDataRequest, ImportCompletionDataResponse, ImportMetadata> importCompletionDataOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCompletionServiceStub create(CompletionServiceStubSettings settings) throws IOException {
        return new HttpJsonCompletionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCompletionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCompletionServiceStub(CompletionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCompletionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCompletionServiceStub(CompletionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCompletionServiceCallableFactory());
    }

    protected HttpJsonCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*/catalogs/*/branches/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*/catalogs/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*/operations/*}").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*/catalogs/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*}/operations").build()).addAdditionalBindings(HttpRule.newBuilder().setGet("/v2beta/{name=projects/*}/operations").build()).build()).build());
        HttpJsonCallSettings completeQueryTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(completeQueryMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        HttpJsonCallSettings importCompletionDataTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(importCompletionDataMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.completeQueryCallable = callableFactory.createUnaryCallable(completeQueryTransportSettings, settings.completeQuerySettings(), clientContext);
        this.importCompletionDataCallable = callableFactory.createUnaryCallable(importCompletionDataTransportSettings, settings.importCompletionDataSettings(), clientContext);
        this.importCompletionDataOperationCallable = callableFactory.createOperationCallable(importCompletionDataTransportSettings, settings.importCompletionDataOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(completeQueryMethodDescriptor);
        methodDescriptors.add(importCompletionDataMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.completeQueryCallable;
    }

    @Override
    public UnaryCallable<ImportCompletionDataRequest, Operation> importCompletionDataCallable() {
        return this.importCompletionDataCallable;
    }

    @Override
    public OperationCallable<ImportCompletionDataRequest, ImportCompletionDataResponse, ImportMetadata> importCompletionDataOperationCallable() {
        return this.importCompletionDataOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

