/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.CatalogName;
import com.google.cloud.retail.v2alpha.CreateModelMetadata;
import com.google.cloud.retail.v2alpha.CreateModelRequest;
import com.google.cloud.retail.v2alpha.DeleteModelRequest;
import com.google.cloud.retail.v2alpha.ListModelsRequest;
import com.google.cloud.retail.v2alpha.ListModelsResponse;
import com.google.cloud.retail.v2alpha.Model;
import com.google.cloud.retail.v2alpha.ModelName;
import com.google.cloud.retail.v2alpha.ModelServiceSettings;
import com.google.cloud.retail.v2alpha.PauseModelRequest;
import com.google.cloud.retail.v2alpha.ResumeModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelMetadata;
import com.google.cloud.retail.v2alpha.TuneModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelResponse;
import com.google.cloud.retail.v2alpha.UpdateModelRequest;
import com.google.cloud.retail.v2alpha.stub.ModelServiceStub;
import com.google.cloud.retail.v2alpha.stub.ModelServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ModelServiceClient
implements BackgroundResource {
    private final ModelServiceSettings settings;
    private final ModelServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final ModelServiceClient create() throws IOException {
        return ModelServiceClient.create(ModelServiceSettings.newBuilder().build());
    }

    public static final ModelServiceClient create(ModelServiceSettings settings) throws IOException {
        return new ModelServiceClient(settings);
    }

    public static final ModelServiceClient create(ModelServiceStub stub) {
        return new ModelServiceClient(stub);
    }

    protected ModelServiceClient(ModelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ModelServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected ModelServiceClient(ModelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final ModelServiceSettings getSettings() {
        return this.settings;
    }

    public ModelServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(CatalogName parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(String parent, Model model) {
        CreateModelRequest request = CreateModelRequest.newBuilder().setParent(parent).setModel(model).build();
        return this.createModelAsync(request);
    }

    public final OperationFuture<Model, CreateModelMetadata> createModelAsync(CreateModelRequest request) {
        return this.createModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateModelRequest, Model, CreateModelMetadata> createModelOperationCallable() {
        return this.stub.createModelOperationCallable();
    }

    public final UnaryCallable<CreateModelRequest, Operation> createModelCallable() {
        return this.stub.createModelCallable();
    }

    public final Model pauseModel(ModelName name) {
        PauseModelRequest request = PauseModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.pauseModel(request);
    }

    public final Model pauseModel(String name) {
        PauseModelRequest request = PauseModelRequest.newBuilder().setName(name).build();
        return this.pauseModel(request);
    }

    public final Model pauseModel(PauseModelRequest request) {
        return (Model)this.pauseModelCallable().call((Object)request);
    }

    public final UnaryCallable<PauseModelRequest, Model> pauseModelCallable() {
        return this.stub.pauseModelCallable();
    }

    public final Model resumeModel(String name) {
        ResumeModelRequest request = ResumeModelRequest.newBuilder().setName(name).build();
        return this.resumeModel(request);
    }

    public final Model resumeModel(ResumeModelRequest request) {
        return (Model)this.resumeModelCallable().call((Object)request);
    }

    public final UnaryCallable<ResumeModelRequest, Model> resumeModelCallable() {
        return this.stub.resumeModelCallable();
    }

    public final void deleteModel(ModelName name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteModel(request);
    }

    public final void deleteModel(String name) {
        DeleteModelRequest request = DeleteModelRequest.newBuilder().setName(name).build();
        this.deleteModel(request);
    }

    public final void deleteModel(DeleteModelRequest request) {
        this.deleteModelCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteModelRequest, Empty> deleteModelCallable() {
        return this.stub.deleteModelCallable();
    }

    public final ListModelsPagedResponse listModels(CatalogName parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(String parent) {
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(parent).build();
        return this.listModels(request);
    }

    public final ListModelsPagedResponse listModels(ListModelsRequest request) {
        return (ListModelsPagedResponse)((Object)this.listModelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListModelsRequest, ListModelsPagedResponse> listModelsPagedCallable() {
        return this.stub.listModelsPagedCallable();
    }

    public final UnaryCallable<ListModelsRequest, ListModelsResponse> listModelsCallable() {
        return this.stub.listModelsCallable();
    }

    public final Model updateModel(Model model, FieldMask updateMask) {
        UpdateModelRequest request = UpdateModelRequest.newBuilder().setModel(model).setUpdateMask(updateMask).build();
        return this.updateModel(request);
    }

    public final Model updateModel(UpdateModelRequest request) {
        return (Model)this.updateModelCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateModelRequest, Model> updateModelCallable() {
        return this.stub.updateModelCallable();
    }

    public final OperationFuture<TuneModelResponse, TuneModelMetadata> tuneModelAsync(ModelName name) {
        TuneModelRequest request = TuneModelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.tuneModelAsync(request);
    }

    public final OperationFuture<TuneModelResponse, TuneModelMetadata> tuneModelAsync(String name) {
        TuneModelRequest request = TuneModelRequest.newBuilder().setName(name).build();
        return this.tuneModelAsync(request);
    }

    public final OperationFuture<TuneModelResponse, TuneModelMetadata> tuneModelAsync(TuneModelRequest request) {
        return this.tuneModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationCallable() {
        return this.stub.tuneModelOperationCallable();
    }

    public final UnaryCallable<TuneModelRequest, Operation> tuneModelCallable() {
        return this.stub.tuneModelCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListModelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        private ListModelsFixedSizeCollection(List<ListModelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListModelsFixedSizeCollection createEmptyCollection() {
            return new ListModelsFixedSizeCollection(null, 0);
        }

        protected ListModelsFixedSizeCollection createCollection(List<ListModelsPage> pages, int collectionSize) {
            return new ListModelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListModelsPage
    extends AbstractPage<ListModelsRequest, ListModelsResponse, Model, ListModelsPage> {
        private ListModelsPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            super(context, (Object)response);
        }

        private static ListModelsPage createEmptyPage() {
            return new ListModelsPage(null, null);
        }

        protected ListModelsPage createPage(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ListModelsResponse response) {
            return new ListModelsPage(context, response);
        }

        public ApiFuture<ListModelsPage> createPageAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListModelsPagedResponse
    extends AbstractPagedListResponse<ListModelsRequest, ListModelsResponse, Model, ListModelsPage, ListModelsFixedSizeCollection> {
        public static ApiFuture<ListModelsPagedResponse> createAsync(PageContext<ListModelsRequest, ListModelsResponse, Model> context, ApiFuture<ListModelsResponse> futureResponse) {
            ApiFuture<ListModelsPage> futurePage = ListModelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListModelsPagedResponse((ListModelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListModelsPagedResponse(ListModelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListModelsFixedSizeCollection.createEmptyCollection());
        }
    }
}

