/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2beta.CompleteQueryRequest;
import com.google.cloud.retail.v2beta.CompleteQueryResponse;
import com.google.cloud.retail.v2beta.ImportCompletionDataRequest;
import com.google.cloud.retail.v2beta.ImportCompletionDataResponse;
import com.google.cloud.retail.v2beta.ImportMetadata;
import com.google.cloud.retail.v2beta.stub.CompletionServiceStub;
import com.google.cloud.retail.v2beta.stub.CompletionServiceStubSettings;
import com.google.cloud.retail.v2beta.stub.GrpcCompletionServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcCompletionServiceStub
extends CompletionServiceStub {
    private static final MethodDescriptor<CompleteQueryRequest, CompleteQueryResponse> completeQueryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.CompletionService/CompleteQuery").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteQueryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)CompleteQueryResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportCompletionDataRequest, Operation> importCompletionDataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2beta.CompletionService/ImportCompletionData").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportCompletionDataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable;
    private final UnaryCallable<ImportCompletionDataRequest, Operation> importCompletionDataCallable;
    private final OperationCallable<ImportCompletionDataRequest, ImportCompletionDataResponse, ImportMetadata> importCompletionDataOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcCompletionServiceStub create(CompletionServiceStubSettings settings) throws IOException {
        return new GrpcCompletionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcCompletionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcCompletionServiceStub(CompletionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcCompletionServiceCallableFactory());
    }

    protected GrpcCompletionServiceStub(CompletionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings completeQueryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeQueryMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("catalog", String.valueOf(request.getCatalog()));
            return builder.build();
        }).build();
        GrpcCallSettings importCompletionDataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importCompletionDataMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.completeQueryCallable = callableFactory.createUnaryCallable(completeQueryTransportSettings, settings.completeQuerySettings(), clientContext);
        this.importCompletionDataCallable = callableFactory.createUnaryCallable(importCompletionDataTransportSettings, settings.importCompletionDataSettings(), clientContext);
        this.importCompletionDataOperationCallable = callableFactory.createOperationCallable(importCompletionDataTransportSettings, settings.importCompletionDataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CompleteQueryRequest, CompleteQueryResponse> completeQueryCallable() {
        return this.completeQueryCallable;
    }

    @Override
    public UnaryCallable<ImportCompletionDataRequest, Operation> importCompletionDataCallable() {
        return this.importCompletionDataCallable;
    }

    @Override
    public OperationCallable<ImportCompletionDataRequest, ImportCompletionDataResponse, ImportMetadata> importCompletionDataOperationCallable() {
        return this.importCompletionDataOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

