/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.CreateModelMetadata;
import com.google.cloud.retail.v2alpha.CreateModelRequest;
import com.google.cloud.retail.v2alpha.DeleteModelRequest;
import com.google.cloud.retail.v2alpha.GetModelRequest;
import com.google.cloud.retail.v2alpha.ListModelsRequest;
import com.google.cloud.retail.v2alpha.ListModelsResponse;
import com.google.cloud.retail.v2alpha.Model;
import com.google.cloud.retail.v2alpha.ModelServiceClient;
import com.google.cloud.retail.v2alpha.PauseModelRequest;
import com.google.cloud.retail.v2alpha.ResumeModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelMetadata;
import com.google.cloud.retail.v2alpha.TuneModelRequest;
import com.google.cloud.retail.v2alpha.TuneModelResponse;
import com.google.cloud.retail.v2alpha.UpdateModelRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcModelServiceStub;
import com.google.cloud.retail.v2alpha.stub.HttpJsonModelServiceStub;
import com.google.cloud.retail.v2alpha.stub.ModelServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ModelServiceStubSettings
extends StubSettings<ModelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateModelRequest, Operation> createModelSettings;
    private final OperationCallSettings<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings;
    private final UnaryCallSettings<GetModelRequest, Model> getModelSettings;
    private final UnaryCallSettings<PauseModelRequest, Model> pauseModelSettings;
    private final UnaryCallSettings<ResumeModelRequest, Model> resumeModelSettings;
    private final UnaryCallSettings<DeleteModelRequest, Empty> deleteModelSettings;
    private final PagedCallSettings<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings;
    private final UnaryCallSettings<UpdateModelRequest, Model> updateModelSettings;
    private final UnaryCallSettings<TuneModelRequest, Operation> tuneModelSettings;
    private final OperationCallSettings<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationSettings;
    private static final PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model> LIST_MODELS_PAGE_STR_DESC = new PagedListDescriptor<ListModelsRequest, ListModelsResponse, Model>(){

        public String emptyToken() {
            return "";
        }

        public ListModelsRequest injectToken(ListModelsRequest payload, String token) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageToken(token).build();
        }

        public ListModelsRequest injectPageSize(ListModelsRequest payload, int pageSize) {
            return ListModelsRequest.newBuilder((ListModelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListModelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListModelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Model> extractResources(ListModelsResponse payload) {
            return payload.getModelsList();
        }
    };
    private static final PagedListResponseFactory<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> LIST_MODELS_PAGE_STR_FACT = new PagedListResponseFactory<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse>(){

        public ApiFuture<ModelServiceClient.ListModelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListModelsRequest, ListModelsResponse> callable, ListModelsRequest request, ApiCallContext context, ApiFuture<ListModelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MODELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ModelServiceClient.ListModelsPagedResponse.createAsync((PageContext<ListModelsRequest, ListModelsResponse, Model>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateModelRequest, Operation> createModelSettings() {
        return this.createModelSettings;
    }

    public OperationCallSettings<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings() {
        return this.createModelOperationSettings;
    }

    public UnaryCallSettings<GetModelRequest, Model> getModelSettings() {
        return this.getModelSettings;
    }

    public UnaryCallSettings<PauseModelRequest, Model> pauseModelSettings() {
        return this.pauseModelSettings;
    }

    public UnaryCallSettings<ResumeModelRequest, Model> resumeModelSettings() {
        return this.resumeModelSettings;
    }

    public UnaryCallSettings<DeleteModelRequest, Empty> deleteModelSettings() {
        return this.deleteModelSettings;
    }

    public PagedCallSettings<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings() {
        return this.listModelsSettings;
    }

    public UnaryCallSettings<UpdateModelRequest, Model> updateModelSettings() {
        return this.updateModelSettings;
    }

    public UnaryCallSettings<TuneModelRequest, Operation> tuneModelSettings() {
        return this.tuneModelSettings;
    }

    public OperationCallSettings<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationSettings() {
        return this.tuneModelOperationSettings;
    }

    public ModelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcModelServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonModelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ModelServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ModelServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ModelServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ModelServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ModelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createModelSettings = settingsBuilder.createModelSettings().build();
        this.createModelOperationSettings = settingsBuilder.createModelOperationSettings().build();
        this.getModelSettings = settingsBuilder.getModelSettings().build();
        this.pauseModelSettings = settingsBuilder.pauseModelSettings().build();
        this.resumeModelSettings = settingsBuilder.resumeModelSettings().build();
        this.deleteModelSettings = settingsBuilder.deleteModelSettings().build();
        this.listModelsSettings = settingsBuilder.listModelsSettings().build();
        this.updateModelSettings = settingsBuilder.updateModelSettings().build();
        this.tuneModelSettings = settingsBuilder.tuneModelSettings().build();
        this.tuneModelOperationSettings = settingsBuilder.tuneModelOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ModelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings;
        private final OperationCallSettings.Builder<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings;
        private final UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings;
        private final UnaryCallSettings.Builder<PauseModelRequest, Model> pauseModelSettings;
        private final UnaryCallSettings.Builder<ResumeModelRequest, Model> resumeModelSettings;
        private final UnaryCallSettings.Builder<DeleteModelRequest, Empty> deleteModelSettings;
        private final PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings;
        private final UnaryCallSettings.Builder<UpdateModelRequest, Model> updateModelSettings;
        private final UnaryCallSettings.Builder<TuneModelRequest, Operation> tuneModelSettings;
        private final OperationCallSettings.Builder<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createModelOperationSettings = OperationCallSettings.newBuilder();
            this.getModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.pauseModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listModelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MODELS_PAGE_STR_FACT);
            this.updateModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.tuneModelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.tuneModelOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createModelSettings, this.getModelSettings, this.pauseModelSettings, this.resumeModelSettings, this.deleteModelSettings, this.listModelsSettings, this.updateModelSettings, this.tuneModelSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ModelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createModelSettings = settings.createModelSettings.toBuilder();
            this.createModelOperationSettings = settings.createModelOperationSettings.toBuilder();
            this.getModelSettings = settings.getModelSettings.toBuilder();
            this.pauseModelSettings = settings.pauseModelSettings.toBuilder();
            this.resumeModelSettings = settings.resumeModelSettings.toBuilder();
            this.deleteModelSettings = settings.deleteModelSettings.toBuilder();
            this.listModelsSettings = settings.listModelsSettings.toBuilder();
            this.updateModelSettings = settings.updateModelSettings.toBuilder();
            this.tuneModelSettings = settings.tuneModelSettings.toBuilder();
            this.tuneModelOperationSettings = settings.tuneModelOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createModelSettings, this.getModelSettings, this.pauseModelSettings, this.resumeModelSettings, this.deleteModelSettings, this.listModelsSettings, this.updateModelSettings, this.tuneModelSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ModelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ModelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ModelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ModelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ModelServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ModelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ModelServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ModelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.getModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.pauseModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.resumeModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.deleteModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.listModelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.updateModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.tuneModelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params"));
            builder.createModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Model.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateModelMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.tuneModelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_4_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_4_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TuneModelResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(TuneModelMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateModelRequest, Operation> createModelSettings() {
            return this.createModelSettings;
        }

        public OperationCallSettings.Builder<CreateModelRequest, Model, CreateModelMetadata> createModelOperationSettings() {
            return this.createModelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetModelRequest, Model> getModelSettings() {
            return this.getModelSettings;
        }

        public UnaryCallSettings.Builder<PauseModelRequest, Model> pauseModelSettings() {
            return this.pauseModelSettings;
        }

        public UnaryCallSettings.Builder<ResumeModelRequest, Model> resumeModelSettings() {
            return this.resumeModelSettings;
        }

        public UnaryCallSettings.Builder<DeleteModelRequest, Empty> deleteModelSettings() {
            return this.deleteModelSettings;
        }

        public PagedCallSettings.Builder<ListModelsRequest, ListModelsResponse, ModelServiceClient.ListModelsPagedResponse> listModelsSettings() {
            return this.listModelsSettings;
        }

        public UnaryCallSettings.Builder<UpdateModelRequest, Model> updateModelSettings() {
            return this.updateModelSettings;
        }

        public UnaryCallSettings.Builder<TuneModelRequest, Operation> tuneModelSettings() {
            return this.tuneModelSettings;
        }

        public OperationCallSettings.Builder<TuneModelRequest, TuneModelResponse, TuneModelMetadata> tuneModelOperationSettings() {
            return this.tuneModelOperationSettings;
        }

        public ModelServiceStubSettings build() throws IOException {
            return new ModelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_4_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

