/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.retail.v2alpha.AcceptTermsRequest;
import com.google.cloud.retail.v2alpha.AlertConfig;
import com.google.cloud.retail.v2alpha.EnrollSolutionMetadata;
import com.google.cloud.retail.v2alpha.EnrollSolutionRequest;
import com.google.cloud.retail.v2alpha.EnrollSolutionResponse;
import com.google.cloud.retail.v2alpha.GetAlertConfigRequest;
import com.google.cloud.retail.v2alpha.GetLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.GetProjectRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsRequest;
import com.google.cloud.retail.v2alpha.ListEnrolledSolutionsResponse;
import com.google.cloud.retail.v2alpha.LoggingConfig;
import com.google.cloud.retail.v2alpha.Project;
import com.google.cloud.retail.v2alpha.UpdateAlertConfigRequest;
import com.google.cloud.retail.v2alpha.UpdateLoggingConfigRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcProjectServiceStub;
import com.google.cloud.retail.v2alpha.stub.HttpJsonProjectServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProjectServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ProjectServiceStubSettings
extends StubSettings<ProjectServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetProjectRequest, Project> getProjectSettings;
    private final UnaryCallSettings<AcceptTermsRequest, Project> acceptTermsSettings;
    private final UnaryCallSettings<EnrollSolutionRequest, Operation> enrollSolutionSettings;
    private final OperationCallSettings<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationSettings;
    private final UnaryCallSettings<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsSettings;
    private final UnaryCallSettings<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigSettings;
    private final UnaryCallSettings<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigSettings;
    private final UnaryCallSettings<GetAlertConfigRequest, AlertConfig> getAlertConfigSettings;
    private final UnaryCallSettings<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigSettings;

    public UnaryCallSettings<GetProjectRequest, Project> getProjectSettings() {
        return this.getProjectSettings;
    }

    public UnaryCallSettings<AcceptTermsRequest, Project> acceptTermsSettings() {
        return this.acceptTermsSettings;
    }

    public UnaryCallSettings<EnrollSolutionRequest, Operation> enrollSolutionSettings() {
        return this.enrollSolutionSettings;
    }

    public OperationCallSettings<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationSettings() {
        return this.enrollSolutionOperationSettings;
    }

    public UnaryCallSettings<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsSettings() {
        return this.listEnrolledSolutionsSettings;
    }

    public UnaryCallSettings<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigSettings() {
        return this.getLoggingConfigSettings;
    }

    public UnaryCallSettings<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigSettings() {
        return this.updateLoggingConfigSettings;
    }

    public UnaryCallSettings<GetAlertConfigRequest, AlertConfig> getAlertConfigSettings() {
        return this.getAlertConfigSettings;
    }

    public UnaryCallSettings<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigSettings() {
        return this.updateAlertConfigSettings;
    }

    public ProjectServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcProjectServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProjectServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProjectServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ProjectServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProjectServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getProjectSettings = settingsBuilder.getProjectSettings().build();
        this.acceptTermsSettings = settingsBuilder.acceptTermsSettings().build();
        this.enrollSolutionSettings = settingsBuilder.enrollSolutionSettings().build();
        this.enrollSolutionOperationSettings = settingsBuilder.enrollSolutionOperationSettings().build();
        this.listEnrolledSolutionsSettings = settingsBuilder.listEnrolledSolutionsSettings().build();
        this.getLoggingConfigSettings = settingsBuilder.getLoggingConfigSettings().build();
        this.updateLoggingConfigSettings = settingsBuilder.updateLoggingConfigSettings().build();
        this.getAlertConfigSettings = settingsBuilder.getAlertConfigSettings().build();
        this.updateAlertConfigSettings = settingsBuilder.updateAlertConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProjectServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetProjectRequest, Project> getProjectSettings;
        private final UnaryCallSettings.Builder<AcceptTermsRequest, Project> acceptTermsSettings;
        private final UnaryCallSettings.Builder<EnrollSolutionRequest, Operation> enrollSolutionSettings;
        private final OperationCallSettings.Builder<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationSettings;
        private final UnaryCallSettings.Builder<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsSettings;
        private final UnaryCallSettings.Builder<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigSettings;
        private final UnaryCallSettings.Builder<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigSettings;
        private final UnaryCallSettings.Builder<GetAlertConfigRequest, AlertConfig> getAlertConfigSettings;
        private final UnaryCallSettings.Builder<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.acceptTermsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enrollSolutionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enrollSolutionOperationSettings = OperationCallSettings.newBuilder();
            this.listEnrolledSolutionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getLoggingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLoggingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAlertConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAlertConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProjectSettings, this.acceptTermsSettings, this.enrollSolutionSettings, this.listEnrolledSolutionsSettings, this.getLoggingConfigSettings, this.updateLoggingConfigSettings, this.getAlertConfigSettings, this.updateAlertConfigSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ProjectServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getProjectSettings = settings.getProjectSettings.toBuilder();
            this.acceptTermsSettings = settings.acceptTermsSettings.toBuilder();
            this.enrollSolutionSettings = settings.enrollSolutionSettings.toBuilder();
            this.enrollSolutionOperationSettings = settings.enrollSolutionOperationSettings.toBuilder();
            this.listEnrolledSolutionsSettings = settings.listEnrolledSolutionsSettings.toBuilder();
            this.getLoggingConfigSettings = settings.getLoggingConfigSettings.toBuilder();
            this.updateLoggingConfigSettings = settings.updateLoggingConfigSettings.toBuilder();
            this.getAlertConfigSettings = settings.getAlertConfigSettings.toBuilder();
            this.updateAlertConfigSettings = settings.updateAlertConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getProjectSettings, this.acceptTermsSettings, this.enrollSolutionSettings, this.listEnrolledSolutionsSettings, this.getLoggingConfigSettings, this.updateLoggingConfigSettings, this.getAlertConfigSettings, this.updateAlertConfigSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProjectServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProjectServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProjectServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ProjectServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ProjectServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ProjectServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.acceptTermsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.enrollSolutionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.listEnrolledSolutionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.getLoggingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.updateLoggingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.getAlertConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.updateAlertConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.enrollSolutionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EnrollSolutionResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(EnrollSolutionMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetProjectRequest, Project> getProjectSettings() {
            return this.getProjectSettings;
        }

        public UnaryCallSettings.Builder<AcceptTermsRequest, Project> acceptTermsSettings() {
            return this.acceptTermsSettings;
        }

        public UnaryCallSettings.Builder<EnrollSolutionRequest, Operation> enrollSolutionSettings() {
            return this.enrollSolutionSettings;
        }

        public OperationCallSettings.Builder<EnrollSolutionRequest, EnrollSolutionResponse, EnrollSolutionMetadata> enrollSolutionOperationSettings() {
            return this.enrollSolutionOperationSettings;
        }

        public UnaryCallSettings.Builder<ListEnrolledSolutionsRequest, ListEnrolledSolutionsResponse> listEnrolledSolutionsSettings() {
            return this.listEnrolledSolutionsSettings;
        }

        public UnaryCallSettings.Builder<GetLoggingConfigRequest, LoggingConfig> getLoggingConfigSettings() {
            return this.getLoggingConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateLoggingConfigRequest, LoggingConfig> updateLoggingConfigSettings() {
            return this.updateLoggingConfigSettings;
        }

        public UnaryCallSettings.Builder<GetAlertConfigRequest, AlertConfig> getAlertConfigSettings() {
            return this.getAlertConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateAlertConfigRequest, AlertConfig> updateAlertConfigSettings() {
            return this.updateAlertConfigSettings;
        }

        public ProjectServiceStubSettings build() throws IOException {
            return new ProjectServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

