/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AnalyticsServiceSettings;
import com.google.cloud.retail.v2alpha.ExportAnalyticsMetricsRequest;
import com.google.cloud.retail.v2alpha.ExportAnalyticsMetricsResponse;
import com.google.cloud.retail.v2alpha.ExportMetadata;
import com.google.cloud.retail.v2alpha.stub.AnalyticsServiceStub;
import com.google.cloud.retail.v2alpha.stub.AnalyticsServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AnalyticsServiceClient
implements BackgroundResource {
    private final AnalyticsServiceSettings settings;
    private final AnalyticsServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final AnalyticsServiceClient create() throws IOException {
        return AnalyticsServiceClient.create(AnalyticsServiceSettings.newBuilder().build());
    }

    public static final AnalyticsServiceClient create(AnalyticsServiceSettings settings) throws IOException {
        return new AnalyticsServiceClient(settings);
    }

    public static final AnalyticsServiceClient create(AnalyticsServiceStub stub) {
        return new AnalyticsServiceClient(stub);
    }

    protected AnalyticsServiceClient(AnalyticsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AnalyticsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected AnalyticsServiceClient(AnalyticsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final AnalyticsServiceSettings getSettings() {
        return this.settings;
    }

    public AnalyticsServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<ExportAnalyticsMetricsResponse, ExportMetadata> exportAnalyticsMetricsAsync(ExportAnalyticsMetricsRequest request) {
        return this.exportAnalyticsMetricsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAnalyticsMetricsRequest, ExportAnalyticsMetricsResponse, ExportMetadata> exportAnalyticsMetricsOperationCallable() {
        return this.stub.exportAnalyticsMetricsOperationCallable();
    }

    public final UnaryCallable<ExportAnalyticsMetricsRequest, Operation> exportAnalyticsMetricsCallable() {
        return this.stub.exportAnalyticsMetricsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

