/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AddControlRequest;
import com.google.cloud.retail.v2alpha.CreateServingConfigRequest;
import com.google.cloud.retail.v2alpha.DeleteServingConfigRequest;
import com.google.cloud.retail.v2alpha.GetServingConfigRequest;
import com.google.cloud.retail.v2alpha.ListServingConfigsRequest;
import com.google.cloud.retail.v2alpha.ListServingConfigsResponse;
import com.google.cloud.retail.v2alpha.RemoveControlRequest;
import com.google.cloud.retail.v2alpha.ServingConfig;
import com.google.cloud.retail.v2alpha.ServingConfigServiceClient;
import com.google.cloud.retail.v2alpha.UpdateServingConfigRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcServingConfigServiceStub;
import com.google.cloud.retail.v2alpha.stub.HttpJsonServingConfigServiceStub;
import com.google.cloud.retail.v2alpha.stub.ServingConfigServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ServingConfigServiceStubSettings
extends StubSettings<ServingConfigServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateServingConfigRequest, ServingConfig> createServingConfigSettings;
    private final UnaryCallSettings<DeleteServingConfigRequest, Empty> deleteServingConfigSettings;
    private final UnaryCallSettings<UpdateServingConfigRequest, ServingConfig> updateServingConfigSettings;
    private final UnaryCallSettings<GetServingConfigRequest, ServingConfig> getServingConfigSettings;
    private final PagedCallSettings<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsSettings;
    private final UnaryCallSettings<AddControlRequest, ServingConfig> addControlSettings;
    private final UnaryCallSettings<RemoveControlRequest, ServingConfig> removeControlSettings;
    private static final PagedListDescriptor<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig> LIST_SERVING_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListServingConfigsRequest injectToken(ListServingConfigsRequest payload, String token) {
            return ListServingConfigsRequest.newBuilder((ListServingConfigsRequest)payload).setPageToken(token).build();
        }

        public ListServingConfigsRequest injectPageSize(ListServingConfigsRequest payload, int pageSize) {
            return ListServingConfigsRequest.newBuilder((ListServingConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServingConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServingConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ServingConfig> extractResources(ListServingConfigsResponse payload) {
            return payload.getServingConfigsList() == null ? ImmutableList.of() : payload.getServingConfigsList();
        }
    };
    private static final PagedListResponseFactory<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse> LIST_SERVING_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse>(){

        public ApiFuture<ServingConfigServiceClient.ListServingConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListServingConfigsRequest, ListServingConfigsResponse> callable, ListServingConfigsRequest request, ApiCallContext context, ApiFuture<ListServingConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVING_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ServingConfigServiceClient.ListServingConfigsPagedResponse.createAsync((PageContext<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfig>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateServingConfigRequest, ServingConfig> createServingConfigSettings() {
        return this.createServingConfigSettings;
    }

    public UnaryCallSettings<DeleteServingConfigRequest, Empty> deleteServingConfigSettings() {
        return this.deleteServingConfigSettings;
    }

    public UnaryCallSettings<UpdateServingConfigRequest, ServingConfig> updateServingConfigSettings() {
        return this.updateServingConfigSettings;
    }

    public UnaryCallSettings<GetServingConfigRequest, ServingConfig> getServingConfigSettings() {
        return this.getServingConfigSettings;
    }

    public PagedCallSettings<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsSettings() {
        return this.listServingConfigsSettings;
    }

    public UnaryCallSettings<AddControlRequest, ServingConfig> addControlSettings() {
        return this.addControlSettings;
    }

    public UnaryCallSettings<RemoveControlRequest, ServingConfig> removeControlSettings() {
        return this.removeControlSettings;
    }

    public ServingConfigServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcServingConfigServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonServingConfigServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return ServingConfigServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "retail";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ServingConfigServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServingConfigServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ServingConfigServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ServingConfigServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ServingConfigServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createServingConfigSettings = settingsBuilder.createServingConfigSettings().build();
        this.deleteServingConfigSettings = settingsBuilder.deleteServingConfigSettings().build();
        this.updateServingConfigSettings = settingsBuilder.updateServingConfigSettings().build();
        this.getServingConfigSettings = settingsBuilder.getServingConfigSettings().build();
        this.listServingConfigsSettings = settingsBuilder.listServingConfigsSettings().build();
        this.addControlSettings = settingsBuilder.addControlSettings().build();
        this.removeControlSettings = settingsBuilder.removeControlSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ServingConfigServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateServingConfigRequest, ServingConfig> createServingConfigSettings;
        private final UnaryCallSettings.Builder<DeleteServingConfigRequest, Empty> deleteServingConfigSettings;
        private final UnaryCallSettings.Builder<UpdateServingConfigRequest, ServingConfig> updateServingConfigSettings;
        private final UnaryCallSettings.Builder<GetServingConfigRequest, ServingConfig> getServingConfigSettings;
        private final PagedCallSettings.Builder<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsSettings;
        private final UnaryCallSettings.Builder<AddControlRequest, ServingConfig> addControlSettings;
        private final UnaryCallSettings.Builder<RemoveControlRequest, ServingConfig> removeControlSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createServingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteServingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateServingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getServingConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listServingConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVING_CONFIGS_PAGE_STR_FACT);
            this.addControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.removeControlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServingConfigSettings, this.deleteServingConfigSettings, this.updateServingConfigSettings, this.getServingConfigSettings, this.listServingConfigsSettings, this.addControlSettings, this.removeControlSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ServingConfigServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createServingConfigSettings = settings.createServingConfigSettings.toBuilder();
            this.deleteServingConfigSettings = settings.deleteServingConfigSettings.toBuilder();
            this.updateServingConfigSettings = settings.updateServingConfigSettings.toBuilder();
            this.getServingConfigSettings = settings.getServingConfigSettings.toBuilder();
            this.listServingConfigsSettings = settings.listServingConfigsSettings.toBuilder();
            this.addControlSettings = settings.addControlSettings.toBuilder();
            this.removeControlSettings = settings.removeControlSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createServingConfigSettings, this.deleteServingConfigSettings, this.updateServingConfigSettings, this.getServingConfigSettings, this.listServingConfigsSettings, this.addControlSettings, this.removeControlSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ServingConfigServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ServingConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServingConfigServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServingConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ServingConfigServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ServingConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ServingConfigServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ServingConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createServingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteServingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateServingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getServingConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listServingConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.addControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.removeControlSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateServingConfigRequest, ServingConfig> createServingConfigSettings() {
            return this.createServingConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteServingConfigRequest, Empty> deleteServingConfigSettings() {
            return this.deleteServingConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateServingConfigRequest, ServingConfig> updateServingConfigSettings() {
            return this.updateServingConfigSettings;
        }

        public UnaryCallSettings.Builder<GetServingConfigRequest, ServingConfig> getServingConfigSettings() {
            return this.getServingConfigSettings;
        }

        public PagedCallSettings.Builder<ListServingConfigsRequest, ListServingConfigsResponse, ServingConfigServiceClient.ListServingConfigsPagedResponse> listServingConfigsSettings() {
            return this.listServingConfigsSettings;
        }

        public UnaryCallSettings.Builder<AddControlRequest, ServingConfig> addControlSettings() {
            return this.addControlSettings;
        }

        public UnaryCallSettings.Builder<RemoveControlRequest, ServingConfig> removeControlSettings() {
            return this.removeControlSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return ServingConfigServiceStubSettings.getDefaultEndpoint();
        }

        public ServingConfigServiceStubSettings build() throws IOException {
            return new ServingConfigServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

