/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.CatalogName;
import com.google.cloud.retail.v2alpha.CreateMerchantCenterAccountLinkMetadata;
import com.google.cloud.retail.v2alpha.CreateMerchantCenterAccountLinkRequest;
import com.google.cloud.retail.v2alpha.DeleteMerchantCenterAccountLinkRequest;
import com.google.cloud.retail.v2alpha.ListMerchantCenterAccountLinksRequest;
import com.google.cloud.retail.v2alpha.ListMerchantCenterAccountLinksResponse;
import com.google.cloud.retail.v2alpha.MerchantCenterAccountLink;
import com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkName;
import com.google.cloud.retail.v2alpha.MerchantCenterAccountLinkServiceSettings;
import com.google.cloud.retail.v2alpha.stub.MerchantCenterAccountLinkServiceStub;
import com.google.cloud.retail.v2alpha.stub.MerchantCenterAccountLinkServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MerchantCenterAccountLinkServiceClient
implements BackgroundResource {
    private final MerchantCenterAccountLinkServiceSettings settings;
    private final MerchantCenterAccountLinkServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final MerchantCenterAccountLinkServiceClient create() throws IOException {
        return MerchantCenterAccountLinkServiceClient.create(MerchantCenterAccountLinkServiceSettings.newBuilder().build());
    }

    public static final MerchantCenterAccountLinkServiceClient create(MerchantCenterAccountLinkServiceSettings settings) throws IOException {
        return new MerchantCenterAccountLinkServiceClient(settings);
    }

    public static final MerchantCenterAccountLinkServiceClient create(MerchantCenterAccountLinkServiceStub stub) {
        return new MerchantCenterAccountLinkServiceClient(stub);
    }

    protected MerchantCenterAccountLinkServiceClient(MerchantCenterAccountLinkServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MerchantCenterAccountLinkServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected MerchantCenterAccountLinkServiceClient(MerchantCenterAccountLinkServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final MerchantCenterAccountLinkServiceSettings getSettings() {
        return this.settings;
    }

    public MerchantCenterAccountLinkServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListMerchantCenterAccountLinksResponse listMerchantCenterAccountLinks(CatalogName parent) {
        ListMerchantCenterAccountLinksRequest request = ListMerchantCenterAccountLinksRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMerchantCenterAccountLinks(request);
    }

    public final ListMerchantCenterAccountLinksResponse listMerchantCenterAccountLinks(String parent) {
        ListMerchantCenterAccountLinksRequest request = ListMerchantCenterAccountLinksRequest.newBuilder().setParent(parent).build();
        return this.listMerchantCenterAccountLinks(request);
    }

    public final ListMerchantCenterAccountLinksResponse listMerchantCenterAccountLinks(ListMerchantCenterAccountLinksRequest request) {
        return (ListMerchantCenterAccountLinksResponse)this.listMerchantCenterAccountLinksCallable().call((Object)request);
    }

    public final UnaryCallable<ListMerchantCenterAccountLinksRequest, ListMerchantCenterAccountLinksResponse> listMerchantCenterAccountLinksCallable() {
        return this.stub.listMerchantCenterAccountLinksCallable();
    }

    public final OperationFuture<MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkAsync(CatalogName parent, MerchantCenterAccountLink merchantCenterAccountLink) {
        CreateMerchantCenterAccountLinkRequest request = CreateMerchantCenterAccountLinkRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMerchantCenterAccountLink(merchantCenterAccountLink).build();
        return this.createMerchantCenterAccountLinkAsync(request);
    }

    public final OperationFuture<MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkAsync(String parent, MerchantCenterAccountLink merchantCenterAccountLink) {
        CreateMerchantCenterAccountLinkRequest request = CreateMerchantCenterAccountLinkRequest.newBuilder().setParent(parent).setMerchantCenterAccountLink(merchantCenterAccountLink).build();
        return this.createMerchantCenterAccountLinkAsync(request);
    }

    public final OperationFuture<MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkAsync(CreateMerchantCenterAccountLinkRequest request) {
        return this.createMerchantCenterAccountLinkOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMerchantCenterAccountLinkRequest, MerchantCenterAccountLink, CreateMerchantCenterAccountLinkMetadata> createMerchantCenterAccountLinkOperationCallable() {
        return this.stub.createMerchantCenterAccountLinkOperationCallable();
    }

    public final UnaryCallable<CreateMerchantCenterAccountLinkRequest, Operation> createMerchantCenterAccountLinkCallable() {
        return this.stub.createMerchantCenterAccountLinkCallable();
    }

    public final void deleteMerchantCenterAccountLink(MerchantCenterAccountLinkName name) {
        DeleteMerchantCenterAccountLinkRequest request = DeleteMerchantCenterAccountLinkRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteMerchantCenterAccountLink(request);
    }

    public final void deleteMerchantCenterAccountLink(String name) {
        DeleteMerchantCenterAccountLinkRequest request = DeleteMerchantCenterAccountLinkRequest.newBuilder().setName(name).build();
        this.deleteMerchantCenterAccountLink(request);
    }

    public final void deleteMerchantCenterAccountLink(DeleteMerchantCenterAccountLinkRequest request) {
        this.deleteMerchantCenterAccountLinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMerchantCenterAccountLinkRequest, Empty> deleteMerchantCenterAccountLinkCallable() {
        return this.stub.deleteMerchantCenterAccountLinkCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

