/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesRequest;
import com.google.cloud.retail.v2alpha.AddFulfillmentPlacesResponse;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesMetadata;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesRequest;
import com.google.cloud.retail.v2alpha.AddLocalInventoriesResponse;
import com.google.cloud.retail.v2alpha.CreateProductRequest;
import com.google.cloud.retail.v2alpha.DeleteProductRequest;
import com.google.cloud.retail.v2alpha.GetProductRequest;
import com.google.cloud.retail.v2alpha.ImportMetadata;
import com.google.cloud.retail.v2alpha.ImportProductsRequest;
import com.google.cloud.retail.v2alpha.ImportProductsResponse;
import com.google.cloud.retail.v2alpha.ListProductsRequest;
import com.google.cloud.retail.v2alpha.ListProductsResponse;
import com.google.cloud.retail.v2alpha.Product;
import com.google.cloud.retail.v2alpha.ProductServiceClient;
import com.google.cloud.retail.v2alpha.PurgeProductsMetadata;
import com.google.cloud.retail.v2alpha.PurgeProductsRequest;
import com.google.cloud.retail.v2alpha.PurgeProductsResponse;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesMetadata;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesRequest;
import com.google.cloud.retail.v2alpha.RemoveFulfillmentPlacesResponse;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesMetadata;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesRequest;
import com.google.cloud.retail.v2alpha.RemoveLocalInventoriesResponse;
import com.google.cloud.retail.v2alpha.SetInventoryMetadata;
import com.google.cloud.retail.v2alpha.SetInventoryRequest;
import com.google.cloud.retail.v2alpha.SetInventoryResponse;
import com.google.cloud.retail.v2alpha.UpdateProductRequest;
import com.google.cloud.retail.v2alpha.stub.GrpcProductServiceCallableFactory;
import com.google.cloud.retail.v2alpha.stub.ProductServiceStub;
import com.google.cloud.retail.v2alpha.stub.ProductServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcProductServiceStub
extends ProductServiceStub {
    private static final MethodDescriptor<CreateProductRequest, Product> createProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/CreateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<GetProductRequest, Product> getProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/GetProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)GetProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<ListProductsRequest, ListProductsResponse> listProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/ListProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListProductsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateProductRequest, Product> updateProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/UpdateProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Product.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteProductRequest, Empty> deleteProductMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/DeleteProduct").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteProductRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<PurgeProductsRequest, Operation> purgeProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/PurgeProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)PurgeProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ImportProductsRequest, Operation> importProductsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/ImportProducts").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportProductsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<SetInventoryRequest, Operation> setInventoryMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/SetInventory").setRequestMarshaller(ProtoUtils.marshaller((Message)SetInventoryRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/AddFulfillmentPlaces").setRequestMarshaller(ProtoUtils.marshaller((Message)AddFulfillmentPlacesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/RemoveFulfillmentPlaces").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveFulfillmentPlacesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<AddLocalInventoriesRequest, Operation> addLocalInventoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/AddLocalInventories").setRequestMarshaller(ProtoUtils.marshaller((Message)AddLocalInventoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.retail.v2alpha.ProductService/RemoveLocalInventories").setRequestMarshaller(ProtoUtils.marshaller((Message)RemoveLocalInventoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateProductRequest, Product> createProductCallable;
    private final UnaryCallable<GetProductRequest, Product> getProductCallable;
    private final UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable;
    private final UnaryCallable<ListProductsRequest, ProductServiceClient.ListProductsPagedResponse> listProductsPagedCallable;
    private final UnaryCallable<UpdateProductRequest, Product> updateProductCallable;
    private final UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable;
    private final UnaryCallable<PurgeProductsRequest, Operation> purgeProductsCallable;
    private final OperationCallable<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationCallable;
    private final UnaryCallable<ImportProductsRequest, Operation> importProductsCallable;
    private final OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable;
    private final UnaryCallable<SetInventoryRequest, Operation> setInventoryCallable;
    private final OperationCallable<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationCallable;
    private final UnaryCallable<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesCallable;
    private final OperationCallable<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationCallable;
    private final UnaryCallable<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesCallable;
    private final OperationCallable<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationCallable;
    private final UnaryCallable<AddLocalInventoriesRequest, Operation> addLocalInventoriesCallable;
    private final OperationCallable<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationCallable;
    private final UnaryCallable<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesCallable;
    private final OperationCallable<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProductServiceStub create(ProductServiceStubSettings settings) throws IOException {
        return new GrpcProductServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProductServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProductServiceStub(ProductServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProductServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProductServiceStub(ProductServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProductServiceStub(ProductServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProductServiceCallableFactory());
    }

    protected GrpcProductServiceStub(ProductServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createProductMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getProductMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listProductsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateProductMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"product.name", (Object)String.valueOf(request.getProduct().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteProductTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteProductMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings purgeProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(purgeProductsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings importProductsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importProductsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings setInventoryTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setInventoryMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"inventory.name", (Object)String.valueOf(request.getInventory().getName()));
            return params.build();
        }).build();
        GrpcCallSettings addFulfillmentPlacesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addFulfillmentPlacesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"product", (Object)String.valueOf(request.getProduct()));
            return params.build();
        }).build();
        GrpcCallSettings removeFulfillmentPlacesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeFulfillmentPlacesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"product", (Object)String.valueOf(request.getProduct()));
            return params.build();
        }).build();
        GrpcCallSettings addLocalInventoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(addLocalInventoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"product", (Object)String.valueOf(request.getProduct()));
            return params.build();
        }).build();
        GrpcCallSettings removeLocalInventoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(removeLocalInventoriesMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"product", (Object)String.valueOf(request.getProduct()));
            return params.build();
        }).build();
        this.createProductCallable = callableFactory.createUnaryCallable(createProductTransportSettings, settings.createProductSettings(), clientContext);
        this.getProductCallable = callableFactory.createUnaryCallable(getProductTransportSettings, settings.getProductSettings(), clientContext);
        this.listProductsCallable = callableFactory.createUnaryCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.listProductsPagedCallable = callableFactory.createPagedCallable(listProductsTransportSettings, settings.listProductsSettings(), clientContext);
        this.updateProductCallable = callableFactory.createUnaryCallable(updateProductTransportSettings, settings.updateProductSettings(), clientContext);
        this.deleteProductCallable = callableFactory.createUnaryCallable(deleteProductTransportSettings, settings.deleteProductSettings(), clientContext);
        this.purgeProductsCallable = callableFactory.createUnaryCallable(purgeProductsTransportSettings, settings.purgeProductsSettings(), clientContext);
        this.purgeProductsOperationCallable = callableFactory.createOperationCallable(purgeProductsTransportSettings, settings.purgeProductsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importProductsCallable = callableFactory.createUnaryCallable(importProductsTransportSettings, settings.importProductsSettings(), clientContext);
        this.importProductsOperationCallable = callableFactory.createOperationCallable(importProductsTransportSettings, settings.importProductsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.setInventoryCallable = callableFactory.createUnaryCallable(setInventoryTransportSettings, settings.setInventorySettings(), clientContext);
        this.setInventoryOperationCallable = callableFactory.createOperationCallable(setInventoryTransportSettings, settings.setInventoryOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.addFulfillmentPlacesCallable = callableFactory.createUnaryCallable(addFulfillmentPlacesTransportSettings, settings.addFulfillmentPlacesSettings(), clientContext);
        this.addFulfillmentPlacesOperationCallable = callableFactory.createOperationCallable(addFulfillmentPlacesTransportSettings, settings.addFulfillmentPlacesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.removeFulfillmentPlacesCallable = callableFactory.createUnaryCallable(removeFulfillmentPlacesTransportSettings, settings.removeFulfillmentPlacesSettings(), clientContext);
        this.removeFulfillmentPlacesOperationCallable = callableFactory.createOperationCallable(removeFulfillmentPlacesTransportSettings, settings.removeFulfillmentPlacesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.addLocalInventoriesCallable = callableFactory.createUnaryCallable(addLocalInventoriesTransportSettings, settings.addLocalInventoriesSettings(), clientContext);
        this.addLocalInventoriesOperationCallable = callableFactory.createOperationCallable(addLocalInventoriesTransportSettings, settings.addLocalInventoriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.removeLocalInventoriesCallable = callableFactory.createUnaryCallable(removeLocalInventoriesTransportSettings, settings.removeLocalInventoriesSettings(), clientContext);
        this.removeLocalInventoriesOperationCallable = callableFactory.createOperationCallable(removeLocalInventoriesTransportSettings, settings.removeLocalInventoriesOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateProductRequest, Product> createProductCallable() {
        return this.createProductCallable;
    }

    @Override
    public UnaryCallable<GetProductRequest, Product> getProductCallable() {
        return this.getProductCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ListProductsResponse> listProductsCallable() {
        return this.listProductsCallable;
    }

    @Override
    public UnaryCallable<ListProductsRequest, ProductServiceClient.ListProductsPagedResponse> listProductsPagedCallable() {
        return this.listProductsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateProductRequest, Product> updateProductCallable() {
        return this.updateProductCallable;
    }

    @Override
    public UnaryCallable<DeleteProductRequest, Empty> deleteProductCallable() {
        return this.deleteProductCallable;
    }

    @Override
    public UnaryCallable<PurgeProductsRequest, Operation> purgeProductsCallable() {
        return this.purgeProductsCallable;
    }

    @Override
    public OperationCallable<PurgeProductsRequest, PurgeProductsResponse, PurgeProductsMetadata> purgeProductsOperationCallable() {
        return this.purgeProductsOperationCallable;
    }

    @Override
    public UnaryCallable<ImportProductsRequest, Operation> importProductsCallable() {
        return this.importProductsCallable;
    }

    @Override
    public OperationCallable<ImportProductsRequest, ImportProductsResponse, ImportMetadata> importProductsOperationCallable() {
        return this.importProductsOperationCallable;
    }

    @Override
    public UnaryCallable<SetInventoryRequest, Operation> setInventoryCallable() {
        return this.setInventoryCallable;
    }

    @Override
    public OperationCallable<SetInventoryRequest, SetInventoryResponse, SetInventoryMetadata> setInventoryOperationCallable() {
        return this.setInventoryOperationCallable;
    }

    @Override
    public UnaryCallable<AddFulfillmentPlacesRequest, Operation> addFulfillmentPlacesCallable() {
        return this.addFulfillmentPlacesCallable;
    }

    @Override
    public OperationCallable<AddFulfillmentPlacesRequest, AddFulfillmentPlacesResponse, AddFulfillmentPlacesMetadata> addFulfillmentPlacesOperationCallable() {
        return this.addFulfillmentPlacesOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveFulfillmentPlacesRequest, Operation> removeFulfillmentPlacesCallable() {
        return this.removeFulfillmentPlacesCallable;
    }

    @Override
    public OperationCallable<RemoveFulfillmentPlacesRequest, RemoveFulfillmentPlacesResponse, RemoveFulfillmentPlacesMetadata> removeFulfillmentPlacesOperationCallable() {
        return this.removeFulfillmentPlacesOperationCallable;
    }

    @Override
    public UnaryCallable<AddLocalInventoriesRequest, Operation> addLocalInventoriesCallable() {
        return this.addLocalInventoriesCallable;
    }

    @Override
    public OperationCallable<AddLocalInventoriesRequest, AddLocalInventoriesResponse, AddLocalInventoriesMetadata> addLocalInventoriesOperationCallable() {
        return this.addLocalInventoriesOperationCallable;
    }

    @Override
    public UnaryCallable<RemoveLocalInventoriesRequest, Operation> removeLocalInventoriesCallable() {
        return this.removeLocalInventoriesCallable;
    }

    @Override
    public OperationCallable<RemoveLocalInventoriesRequest, RemoveLocalInventoriesResponse, RemoveLocalInventoriesMetadata> removeLocalInventoriesOperationCallable() {
        return this.removeLocalInventoriesOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

