/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.retail.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.retail.v2.Catalog;
import com.google.cloud.retail.v2.CatalogServiceClient;
import com.google.cloud.retail.v2.GetDefaultBranchRequest;
import com.google.cloud.retail.v2.GetDefaultBranchResponse;
import com.google.cloud.retail.v2.ListCatalogsRequest;
import com.google.cloud.retail.v2.ListCatalogsResponse;
import com.google.cloud.retail.v2.SetDefaultBranchRequest;
import com.google.cloud.retail.v2.UpdateCatalogRequest;
import com.google.cloud.retail.v2.stub.CatalogServiceStub;
import com.google.cloud.retail.v2.stub.GrpcCatalogServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CatalogServiceStubSettings
extends StubSettings<CatalogServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
    private final UnaryCallSettings<UpdateCatalogRequest, Catalog> updateCatalogSettings;
    private final UnaryCallSettings<SetDefaultBranchRequest, Empty> setDefaultBranchSettings;
    private final UnaryCallSettings<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings;
    private static final PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog> LIST_CATALOGS_PAGE_STR_DESC = new PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog>(){

        public String emptyToken() {
            return "";
        }

        public ListCatalogsRequest injectToken(ListCatalogsRequest payload, String token) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageToken(token).build();
        }

        public ListCatalogsRequest injectPageSize(ListCatalogsRequest payload, int pageSize) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCatalogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCatalogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Catalog> extractResources(ListCatalogsResponse payload) {
            return payload.getCatalogsList() == null ? ImmutableList.of() : payload.getCatalogsList();
        }
    };
    private static final PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> LIST_CATALOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse>(){

        public ApiFuture<CatalogServiceClient.ListCatalogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> callable, ListCatalogsRequest request, ApiCallContext context, ApiFuture<ListCatalogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CATALOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CatalogServiceClient.ListCatalogsPagedResponse.createAsync((PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
        return this.listCatalogsSettings;
    }

    public UnaryCallSettings<UpdateCatalogRequest, Catalog> updateCatalogSettings() {
        return this.updateCatalogSettings;
    }

    public UnaryCallSettings<SetDefaultBranchRequest, Empty> setDefaultBranchSettings() {
        return this.setDefaultBranchSettings;
    }

    public UnaryCallSettings<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings() {
        return this.getDefaultBranchSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CatalogServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCatalogServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "retail.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "retail.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CatalogServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CatalogServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CatalogServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCatalogsSettings = settingsBuilder.listCatalogsSettings().build();
        this.updateCatalogSettings = settingsBuilder.updateCatalogSettings().build();
        this.setDefaultBranchSettings = settingsBuilder.setDefaultBranchSettings().build();
        this.getDefaultBranchSettings = settingsBuilder.getDefaultBranchSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CatalogServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
        private final UnaryCallSettings.Builder<UpdateCatalogRequest, Catalog> updateCatalogSettings;
        private final UnaryCallSettings.Builder<SetDefaultBranchRequest, Empty> setDefaultBranchSettings;
        private final UnaryCallSettings.Builder<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCatalogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CATALOGS_PAGE_STR_FACT);
            this.updateCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDefaultBranchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDefaultBranchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCatalogsSettings, this.updateCatalogSettings, this.setDefaultBranchSettings, this.getDefaultBranchSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CatalogServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCatalogsSettings = settings.listCatalogsSettings.toBuilder();
            this.updateCatalogSettings = settings.updateCatalogSettings.toBuilder();
            this.setDefaultBranchSettings = settings.setDefaultBranchSettings.toBuilder();
            this.getDefaultBranchSettings = settings.getDefaultBranchSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCatalogsSettings, this.updateCatalogSettings, this.setDefaultBranchSettings, this.getDefaultBranchSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CatalogServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CatalogServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CatalogServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CatalogServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CatalogServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCatalogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setDefaultBranchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDefaultBranchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, CatalogServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
            return this.listCatalogsSettings;
        }

        public UnaryCallSettings.Builder<UpdateCatalogRequest, Catalog> updateCatalogSettings() {
            return this.updateCatalogSettings;
        }

        public UnaryCallSettings.Builder<SetDefaultBranchRequest, Empty> setDefaultBranchSettings() {
            return this.setDefaultBranchSettings;
        }

        public UnaryCallSettings.Builder<GetDefaultBranchRequest, GetDefaultBranchResponse> getDefaultBranchSettings() {
            return this.getDefaultBranchSettings;
        }

        public CatalogServiceStubSettings build() throws IOException {
            return new CatalogServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

